/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.client.animation;

import net.minecraft.client.model.ModelRenderer;
import zeldaswordskills.api.client.animation.AnimationTimed;
import zeldaswordskills.api.client.animation.RotationAxis;

public class AnimationTargetAngle
extends AnimationTimed {
    protected final ModelRenderer part;
    protected final RotationAxis axis;
    protected final float targetAngle;

    public AnimationTargetAngle(ModelRenderer part, RotationAxis axis, float targetAngle, int startFrame, int endFrame, boolean convert) {
        super(startFrame, endFrame);
        this.part = part;
        this.axis = axis;
        this.targetAngle = convert ? (float)Math.toRadians(targetAngle) : targetAngle;
    }

    public AnimationTargetAngle(ModelRenderer part, RotationAxis axis, float targetAngle, int startFrame, int endFrame) {
        this(part, axis, targetAngle, startFrame, endFrame, false);
    }

    @Override
    public void apply(int frame, float partialTick, float speed, float multiplier, float offset, boolean invert) {
        multiplier = this.allowMultiplier ? multiplier : 1.0f;
        offset = this.allowOffset ? offset : 0.0f;
        speed = this.allowSpeed ? speed : 1.0f;
        float progress = this.getProgress(frame, partialTick, speed);
        this.axis.addRotation(this.part, this.getRotationAmount(progress, multiplier, offset, invert &= this.allowInvert));
    }

    protected float getRotationAmount(float progress, float multiplier, float offset, boolean invert) {
        float angle = invert ? -this.targetAngle : this.targetAngle;
        angle = angle + (invert ? -offset : offset) - this.axis.getRotation(this.part);
        return multiplier * progress * angle;
    }
}

