/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.client.animation;

import net.minecraft.util.MathHelper;
import zeldaswordskills.api.client.animation.AnimationBase;
import zeldaswordskills.api.client.animation.IProgressType;

public abstract class AnimationTimed
extends AnimationBase {
    protected final float startFrame;
    protected final float endFrame;
    protected boolean strict;
    protected IProgressType progressType = IProgressType.LINEAR;

    public AnimationTimed(int startFrame, int endFrame) {
        this.startFrame = startFrame;
        this.endFrame = endFrame;
    }

    public AnimationTimed setStrict() {
        this.strict = true;
        return this;
    }

    public AnimationTimed setProgressType(IProgressType type) {
        this.progressType = type;
        return this;
    }

    @Override
    public boolean shouldApply(int frame, float partialTick, float speed) {
        if (this.strict && (float)frame > this.endFrame / speed) {
            return false;
        }
        return (float)frame >= this.startFrame / speed;
    }

    protected final float getProgress(int frame, float partialTick, float speed) {
        float start = this.startFrame / speed;
        float end = this.endFrame / speed;
        float f = (float)frame - start;
        return this.progressType.getProgress(MathHelper.clamp_float((float)((f + partialTick) / (end - start)), (float)0.0f, (float)1.0f));
    }
}

