/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.damage;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import zeldaswordskills.api.damage.EnumDamageType;
import zeldaswordskills.api.damage.IDamageAoE;
import zeldaswordskills.api.damage.IDamageSourceStun;
import zeldaswordskills.api.damage.IDamageType;

public class DamageUtils {
    public static final String ARMOR_BREAK = "armorBreak";
    public static final String IARMOR_BREAK = "iArmorBreak";
    public static final String NON_SWORD = "nonSword";
    public static final String INDIRECT_SWORD = "indirectSword";
    public static final String INDIRECT_COMBO = "indirectCombo";

    public static DamageSource causeArmorBreakDamage(Entity entity) {
        return new DamageSourceArmorBreak(ARMOR_BREAK, entity);
    }

    public static DamageSource causeIArmorBreakDamage(Entity entity) {
        return new DamageSourceArmorBreak(IARMOR_BREAK, entity);
    }

    public static DamageSource causeNonSwordDamage(Entity entity) {
        return new EntityDamageSource(NON_SWORD, entity);
    }

    public static DamageSource causeIndirectSwordDamage(Entity direct, Entity indirect) {
        return new EntityDamageSourceIndirect(INDIRECT_SWORD, direct, indirect);
    }

    public static DamageSource causeIndirectComboDamage(Entity direct, Entity indirect) {
        return new EntityDamageSourceIndirect(INDIRECT_COMBO, direct, indirect);
    }

    public static class DamageSourceQuakeIndirect
    extends DamageSourceBaseIndirect {
        private final int duration;
        private final int amplifier;

        public DamageSourceQuakeIndirect(String name, Entity direct, Entity indirect, int duration, int amplifier) {
            this(name, direct, indirect, duration, amplifier, true);
        }

        public DamageSourceQuakeIndirect(String name, Entity direct, Entity indirect, int duration, int amplifier, boolean isAoE) {
            super(name, direct, indirect, isAoE, EnumDamageType.QUAKE);
            this.duration = duration;
            this.amplifier = amplifier;
        }

        @Override
        public int getDuration(EnumDamageType type) {
            return type == EnumDamageType.QUAKE ? this.duration : super.getDuration(type);
        }

        @Override
        public int getAmplifier(EnumDamageType type) {
            return type == EnumDamageType.QUAKE ? this.amplifier : super.getAmplifier(type);
        }
    }

    public static class DamageSourceIceIndirect
    extends DamageSourceBaseIndirect {
        private final int duration;
        private final int amplifier;

        public DamageSourceIceIndirect(String name, Entity direct, Entity indirect, int duration, int amplifier) {
            this(name, direct, indirect, duration, amplifier, false);
        }

        public DamageSourceIceIndirect(String name, Entity direct, Entity indirect, int duration, int amplifier, boolean isAoE) {
            super(name, direct, indirect, isAoE, EnumDamageType.COLD);
            this.duration = duration;
            this.amplifier = amplifier;
        }

        @Override
        public int getDuration(EnumDamageType type) {
            return type == EnumDamageType.COLD ? this.duration : super.getDuration(type);
        }

        @Override
        public int getAmplifier(EnumDamageType type) {
            return type == EnumDamageType.COLD ? this.amplifier : super.getAmplifier(type);
        }
    }

    public static class DamageSourceIce
    extends DamageSourceBaseDirect {
        private final int duration;
        private final int amplifier;

        public DamageSourceIce(String name, Entity entity, int duration, int amplifier) {
            this(name, entity, duration, amplifier, false);
        }

        public DamageSourceIce(String name, Entity entity, int duration, int amplifier, boolean isAoE) {
            super(name, entity, isAoE, EnumDamageType.COLD);
            this.duration = duration;
            this.amplifier = amplifier;
        }

        @Override
        public int getDuration(EnumDamageType type) {
            return type == EnumDamageType.COLD ? this.duration : super.getDuration(type);
        }

        @Override
        public int getAmplifier(EnumDamageType type) {
            return type == EnumDamageType.COLD ? this.amplifier : super.getAmplifier(type);
        }
    }

    public static class DamageSourceFireIndirect
    extends DamageSourceBaseIndirect {
        public DamageSourceFireIndirect(String name, Entity direct, Entity indirect) {
            this(name, direct, indirect, false);
        }

        public DamageSourceFireIndirect(String name, Entity direct, Entity indirect, boolean isAoE) {
            super(name, direct, indirect, isAoE, EnumDamageType.FIRE);
            this.setFireDamage();
        }
    }

    public static class DamageSourceFire
    extends DamageSourceBaseDirect {
        public DamageSourceFire(String name, Entity entity) {
            this(name, entity, false);
        }

        public DamageSourceFire(String name, Entity entity, boolean isAoE) {
            super(name, entity, isAoE, EnumDamageType.FIRE);
            this.setFireDamage();
        }
    }

    public static class DamageSourceShockIndirect
    extends DamageSourceBaseIndirect {
        private final float hunger;

        public DamageSourceShockIndirect(String name, Entity direct, Entity indirect, int duration, float hunger) {
            this(name, direct, indirect, duration, hunger, false);
        }

        public DamageSourceShockIndirect(String name, Entity direct, Entity indirect, int duration, float hunger, boolean isAoE) {
            super(name, direct, indirect, isAoE, EnumDamageType.SHOCK);
            this.hunger = hunger;
            this.setDamageBypassesArmor();
            this.setStunDamage(duration, 5, true);
        }

        @Override
        public boolean alwaysStuns() {
            return true;
        }

        public float getHungerDamage() {
            return this.hunger;
        }
    }

    public static class DamageSourceShock
    extends DamageSourceBaseDirect {
        private final float hunger;

        public DamageSourceShock(String name, Entity entity, int duration, float hunger) {
            this(name, entity, duration, hunger, false);
        }

        public DamageSourceShock(String name, Entity entity, int duration, float hunger, boolean isAoE) {
            super(name, entity, isAoE, EnumDamageType.SHOCK);
            this.hunger = hunger;
            this.setDamageBypassesArmor();
            this.setStunDamage(duration, 5, true);
        }

        @Override
        public boolean alwaysStuns() {
            return true;
        }

        public float getHungerDamage() {
            return this.hunger;
        }
    }

    public static class DamageSourceBaseIndirect
    extends EntityDamageSourceIndirect
    implements IDamageAoE,
    IDamageType,
    IDamageSourceStun {
        protected final boolean isAoE;
        private final Set<EnumDamageType> enumDamageTypes = new HashSet<EnumDamageType>();
        private int stunDuration;
        private int stunAmplifier;
        private boolean canStunPlayers;

        public DamageSourceBaseIndirect(String name, Entity direct, Entity indirect) {
            this(name, direct, indirect, false);
        }

        public DamageSourceBaseIndirect(String name, Entity direct, Entity indirect, boolean isAoE) {
            super(name, direct, indirect);
            this.isAoE = isAoE;
        }

        public DamageSourceBaseIndirect(String name, Entity direct, Entity indirect, EnumDamageType type) {
            this(name, direct, indirect, false, type);
        }

        public DamageSourceBaseIndirect(String name, Entity direct, Entity indirect, boolean isAoE, EnumDamageType type) {
            this(name, direct, indirect, isAoE);
            this.addDamageType(type);
        }

        @Override
        public final boolean isAoEDamage() {
            return this.isAoE;
        }

        protected void addDamageType(EnumDamageType type) {
            this.enumDamageTypes.add(type);
        }

        @Override
        public Set<EnumDamageType> getEnumDamageTypes() {
            return Collections.unmodifiableSet(this.enumDamageTypes);
        }

        public DamageSourceBaseIndirect setStunDamage(int duration, int amplifier, boolean canStunPlayers) {
            this.addDamageType(EnumDamageType.STUN);
            this.stunDuration = duration;
            this.stunAmplifier = amplifier;
            this.canStunPlayers = canStunPlayers;
            return this;
        }

        @Override
        public int getDuration(EnumDamageType type) {
            return this.stunDuration;
        }

        @Override
        public int getAmplifier(EnumDamageType type) {
            return this.stunAmplifier;
        }

        public DamageSourceBaseIndirect setCanStunPlayers() {
            this.canStunPlayers = true;
            return this;
        }

        @Override
        public boolean canStunPlayers() {
            return this.canStunPlayers;
        }

        @Override
        public boolean alwaysStuns() {
            return false;
        }
    }

    public static class DamageSourceBaseDirect
    extends EntityDamageSource
    implements IDamageAoE,
    IDamageType,
    IDamageSourceStun {
        protected final boolean isAoE;
        private final Set<EnumDamageType> enumDamageTypes = new HashSet<EnumDamageType>();
        private int stunDuration;
        private int stunAmplifier;
        private boolean canStunPlayers;

        public DamageSourceBaseDirect(String name, Entity entity) {
            this(name, entity, false);
        }

        public DamageSourceBaseDirect(String name, Entity entity, boolean isAoE) {
            super(name, entity);
            this.isAoE = isAoE;
        }

        public DamageSourceBaseDirect(String name, Entity entity, EnumDamageType type) {
            this(name, entity, false, type);
        }

        public DamageSourceBaseDirect(String name, Entity entity, boolean isAoE, EnumDamageType type) {
            this(name, entity, isAoE);
            this.addDamageType(type);
        }

        @Override
        public final boolean isAoEDamage() {
            return this.isAoE;
        }

        protected void addDamageType(EnumDamageType type) {
            this.enumDamageTypes.add(type);
        }

        @Override
        public Set<EnumDamageType> getEnumDamageTypes() {
            return Collections.unmodifiableSet(this.enumDamageTypes);
        }

        public DamageSourceBaseDirect setStunDamage(int duration, int amplifier, boolean canStunPlayers) {
            this.addDamageType(EnumDamageType.STUN);
            this.stunDuration = duration;
            this.stunAmplifier = amplifier;
            this.canStunPlayers = canStunPlayers;
            return this;
        }

        @Override
        public int getDuration(EnumDamageType type) {
            return this.stunDuration;
        }

        @Override
        public int getAmplifier(EnumDamageType type) {
            return this.stunAmplifier;
        }

        public DamageSourceBaseDirect setCanStunPlayers() {
            this.canStunPlayers = true;
            return this;
        }

        @Override
        public boolean canStunPlayers() {
            return this.canStunPlayers;
        }

        @Override
        public boolean alwaysStuns() {
            return false;
        }
    }

    public static class DamageSourceArmorBreak
    extends EntityDamageSource {
        public DamageSourceArmorBreak(String name, Entity entity) {
            super(name, entity);
            this.setDamageBypassesArmor();
        }
    }
}

