/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.damage;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import zeldaswordskills.api.damage.IDamageSourceStun;
import zeldaswordskills.api.damage.IPostDamageEffect;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;

public enum EnumDamageType {
    COLD,
    FIRE,
    HOLY,
    QUAKE,
    SHOCK,
    STUN;

    public static final Map<EnumDamageType, Buff> damageResistMap;
    public static final Map<EnumDamageType, Buff> damageWeaknessMap;

    public void handleSecondaryEffects(IPostDamageEffect source, EntityLivingBase entity, float damage) {
        switch (this) {
            case COLD: {
                entity.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, (int)(damage * (float)source.getDuration(this)), source.getAmplifier(this)));
                break;
            }
            case QUAKE: {
                entity.addPotionEffect(new PotionEffect(Potion.confusion.id, (int)(damage * (float)source.getDuration(this)), source.getAmplifier(this)));
                entity.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, (int)(damage * (float)source.getDuration(this)), 0));
                break;
            }
            case STUN: {
                if (!(source instanceof IDamageSourceStun)) break;
                IDamageSourceStun stunSource = (IDamageSourceStun)source;
                int stunTime = Math.max(source.getDuration(this), 2);
                int modifier = Math.max(source.getAmplifier(this), 1);
                stunTime += entity.worldObj.rand.nextInt((int)(Math.max(damage, 1.0f) * (float)modifier)) - entity.worldObj.rand.nextInt(stunTime / 2);
                if (entity instanceof EntityPlayer && !stunSource.canStunPlayers()) break;
                ZSSEntityInfo.get(entity).stun(stunTime, stunSource.alwaysStuns());
                break;
            }
        }
    }

    static {
        damageResistMap = new EnumMap<EnumDamageType, Buff>(EnumDamageType.class);
        damageWeaknessMap = new EnumMap<EnumDamageType, Buff>(EnumDamageType.class);
        damageResistMap.put(COLD, Buff.RESIST_COLD);
        damageResistMap.put(HOLY, Buff.RESIST_HOLY);
        damageResistMap.put(QUAKE, Buff.RESIST_QUAKE);
        damageResistMap.put(SHOCK, Buff.RESIST_SHOCK);
        damageWeaknessMap.put(COLD, Buff.WEAKNESS_COLD);
        damageWeaknessMap.put(HOLY, Buff.WEAKNESS_HOLY);
        damageWeaknessMap.put(QUAKE, Buff.WEAKNESS_QUAKE);
        damageWeaknessMap.put(SHOCK, Buff.WEAKNESS_SHOCK);
    }
}

