/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S27PacketExplosion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import zeldaswordskills.api.block.IExplodable;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.IEntityBomb;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.ref.Config;

public class CustomExplosion
extends Explosion {
    public boolean inflictsDamage = true;
    public boolean scalesWithDistance = true;
    public IgnoreLiquid ignoreLiquidType = IgnoreLiquid.NONE;
    public Block targetBlock = null;
    protected DamageSource source = null;
    protected float damage = 0.0f;
    protected int burnTime = 0;
    protected float motionFactor = 1.0f;
    protected static final int MAX_RADIUS = 16;
    protected float restrictExplosion = 1.0f;
    protected final Random rand = new Random();
    protected final World worldObj;
    protected Map<EntityPlayer, Vec3> affectedPlayers = new HashMap<EntityPlayer, Vec3>();

    public static DamageSource getExplosionSource(CustomExplosion explosion) {
        if (explosion.exploder instanceof EntityThrowable) {
            return new EntityDamageSourceIndirect("explosion", explosion.exploder, (Entity)((EntityThrowable)explosion.exploder).getThrower()).setExplosion().setDifficultyScaled();
        }
        return DamageSource.setExplosionSource((Explosion)explosion);
    }

    public static void createExplosion(World world, double x, double y, double z, float radius, BombType type) {
        CustomExplosion.createExplosion(new EntityBomb(world).setType(type), world, x, y, z, radius, 0.0f, true);
    }

    public static void createExplosion(IEntityBomb bomb, World world, double x, double y, double z, float radius, float damage, boolean canGrief) {
        CustomExplosion explosion = new CustomExplosion(world, (Entity)bomb, x, y, z, radius).setDamage(damage);
        BombType type = bomb.getType();
        boolean restrictBlocks = false;
        explosion.setMotionFactor(bomb.getMotionFactor());
        explosion.scalesWithDistance = damage == 0.0f;
        explosion.isSmoking = canGrief;
        explosion.targetBlock = restrictBlocks || Config.onlyBombSecretStone() ? ZSSBlocks.secretStone : null;
        explosion.ignoreLiquidType = type.ignoreLiquidType;
        float f = bomb.getDestructionFactor();
        if (world.provider.isHellWorld && type != BombType.BOMB_FIRE) {
            f *= 0.5f;
        }
        explosion.restrictExplosionBy(f);
        explosion.doExplosionA();
        explosion.doExplosionB(true);
        if (bomb.hasPostExplosionEffect()) {
            type.postExplosionEffect(world, explosion);
        }
    }

    public CustomExplosion(World world, Entity exploder, double x, double y, double z, float explosionSize) {
        super(world, exploder, x, y, z, explosionSize);
        this.worldObj = world;
    }

    public CustomExplosion setSource(DamageSource source) {
        this.source = source;
        return this;
    }

    protected DamageSource getDamageSource() {
        return this.source != null ? this.source : CustomExplosion.getExplosionSource(this);
    }

    public CustomExplosion setDamage(float amount) {
        this.damage = amount;
        return this;
    }

    public CustomExplosion setBurnTime(int ticks) {
        this.burnTime = ticks;
        return this;
    }

    public CustomExplosion setMotionFactor(float amount) {
        this.motionFactor = amount;
        return this;
    }

    public CustomExplosion restrictExplosionBy(float factor) {
        this.restrictExplosion = factor;
        return this;
    }

    public void doExplosionA() {
        if (this.isSmoking && this.restrictExplosion > 0.0f) {
            this.populateAffectedBlocksList();
        }
        if (this.inflictsDamage) {
            this.affectEntitiesWithin();
        }
    }

    public void doExplosionB(boolean spawnExtraParticles) {
        Block block;
        int k;
        int j;
        int i;
        this.worldObj.playSoundEffect(this.explosionX, this.explosionY, this.explosionZ, "random.explode", 4.0f, (1.0f + (this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()) * 0.2f) * 0.7f);
        if (this.explosionSize >= 2.0f && this.isSmoking) {
            this.worldObj.spawnParticle("hugeexplosion", this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0);
        } else {
            this.worldObj.spawnParticle("largeexplode", this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0);
        }
        if (this.isSmoking) {
            for (ChunkPosition chunkposition : this.affectedBlockPositions) {
                i = chunkposition.chunkPosX;
                j = chunkposition.chunkPosY;
                k = chunkposition.chunkPosZ;
                block = this.worldObj.getBlock(i, j, k);
                this.explodeBlockAt(block, i, j, k, spawnExtraParticles);
            }
        }
        if (this.isFlaming) {
            for (ChunkPosition chunkposition : this.affectedBlockPositions) {
                i = chunkposition.chunkPosX;
                j = chunkposition.chunkPosY;
                k = chunkposition.chunkPosZ;
                block = this.worldObj.getBlock(i, j, k);
                Block block1 = this.worldObj.getBlock(i, j - 1, k);
                if (block != Blocks.air || !block1.func_149730_j() || this.rand.nextInt(3) != 0) continue;
                this.worldObj.setBlock(i, j, k, (Block)Blocks.fire);
            }
        }
        this.notifyClients();
    }

    private void explodeBlockAt(Block block, int i, int j, int k, boolean spawnExtraParticles) {
        if (spawnExtraParticles) {
            double d0 = (float)i + this.worldObj.rand.nextFloat();
            double d1 = (float)j + this.worldObj.rand.nextFloat();
            double d2 = (float)k + this.worldObj.rand.nextFloat();
            double d3 = d0 - this.explosionX;
            double d4 = d1 - this.explosionY;
            double d5 = d2 - this.explosionZ;
            double d6 = MathHelper.sqrt_double((double)(d3 * d3 + d4 * d4 + d5 * d5));
            d3 /= d6;
            d4 /= d6;
            d5 /= d6;
            double d7 = 0.5 / (d6 / (double)this.explosionSize + 0.1);
            this.worldObj.spawnParticle("explode", (d0 + this.explosionX * 1.0) / 2.0, (d1 + this.explosionY * 1.0) / 2.0, (d2 + this.explosionZ * 1.0) / 2.0, d3 *= (d7 *= (double)(this.worldObj.rand.nextFloat() * this.worldObj.rand.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
            this.worldObj.spawnParticle("smoke", d0, d1, d2, d3, d4, d5);
        }
        if (block.getMaterial() != Material.air) {
            if (block.canDropFromExplosion((Explosion)this)) {
                block.dropBlockAsItemWithChance(this.worldObj, i, j, k, this.worldObj.getBlockMetadata(i, j, k), 1.0f / this.explosionSize, 0);
            }
            block.onBlockExploded(this.worldObj, i, j, k, (Explosion)this);
        }
    }

    protected void populateAffectedBlocksList() {
        HashSet<ChunkPosition> hashset = new HashSet<ChunkPosition>();
        float radius = Math.min(this.explosionSize * this.restrictExplosion, 16.0f);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    double d3 = (float)i / 15.0f * 2.0f - 1.0f;
                    double d4 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d5 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d0 = this.explosionX;
                    double d1 = this.explosionY;
                    double d2 = this.explosionZ;
                    float f2 = 0.3f;
                    for (float f1 = radius * (0.7f + this.worldObj.rand.nextFloat() * 0.6f); f1 > 0.0f; f1 -= f2 * 0.75f) {
                        int j1;
                        int i1;
                        int l = MathHelper.floor_double((double)d0);
                        Block block = this.worldObj.getBlock(l, i1 = MathHelper.floor_double((double)d1), j1 = MathHelper.floor_double((double)d2));
                        if (block.getMaterial() != Material.air) {
                            boolean flag;
                            boolean bl = flag = !block.getMaterial().isLiquid() || this.ignoreLiquidType == IgnoreLiquid.NONE || this.ignoreLiquidType == IgnoreLiquid.WATER && block.getMaterial() != Material.water || this.ignoreLiquidType == IgnoreLiquid.LAVA && block.getMaterial() != Material.lava;
                            if (flag) {
                                float f3 = this.exploder != null ? this.exploder.func_145772_a((Explosion)this, this.worldObj, l, i1, j1, block) : block.getExplosionResistance(this.exploder, this.worldObj, l, i1, j1, this.explosionX, this.explosionY, this.explosionZ);
                                f1 -= (f3 + 0.3f) * f2;
                            }
                        }
                        if (f1 > 0.0f && (this.targetBlock == null || block == this.targetBlock || block instanceof IExplodable) && (this.exploder == null || this.exploder.func_145774_a((Explosion)this, this.worldObj, l, i1, j1, block, f1))) {
                            hashset.add(new ChunkPosition(l, i1, j1));
                        }
                        d0 += d3 * (double)f2;
                        d1 += d4 * (double)f2;
                        d2 += d5 * (double)f2;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(hashset);
    }

    protected void affectEntitiesWithin() {
        float diameter = this.explosionSize * 2.0f;
        int i = MathHelper.floor_double((double)(this.explosionX - (double)this.explosionSize - 1.0));
        int j = MathHelper.floor_double((double)(this.explosionX + (double)this.explosionSize + 1.0));
        int k = MathHelper.floor_double((double)(this.explosionY - (double)this.explosionSize - 1.0));
        int l1 = MathHelper.floor_double((double)(this.explosionY + (double)this.explosionSize + 1.0));
        int i2 = MathHelper.floor_double((double)(this.explosionZ - (double)this.explosionSize - 1.0));
        int j2 = MathHelper.floor_double((double)(this.explosionZ + (double)this.explosionSize + 1.0));
        List list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this.exploder, AxisAlignedBB.getBoundingBox((double)i, (double)k, (double)i2, (double)j, (double)l1, (double)j2));
        Vec3 vec3 = Vec3.createVectorHelper((double)this.explosionX, (double)this.explosionY, (double)this.explosionZ);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            float amount;
            double d2;
            double d1;
            double d0;
            double d8;
            double d7;
            Entity entity = (Entity)list.get(k2);
            double d = d7 = this.scalesWithDistance ? entity.getDistance(this.explosionX, this.explosionY, this.explosionZ) / (double)diameter : 0.0;
            if (!(d7 <= 1.0) || (d8 = (double)MathHelper.sqrt_double((double)((d0 = entity.posX - this.explosionX) * d0 + (d1 = entity.posY + (double)entity.getEyeHeight() - this.explosionY) * d1 + (d2 = entity.posZ - this.explosionZ) * d2))) == 0.0) continue;
            d0 /= d8;
            d1 /= d8;
            d2 /= d8;
            double d9 = this.worldObj.getBlockDensity(vec3, entity.boundingBox);
            double d10 = (1.0 - d7) * d9;
            float f = amount = this.damage == 0.0f ? (float)((int)((d10 * d10 + d10) / 2.0 * 8.0 * (double)diameter + 1.0)) : this.damage * (float)d10;
            if (entity.attackEntityFrom(this.getDamageSource(), amount) && this.isFlaming && !entity.isImmuneToFire() && (!this.scalesWithDistance || (double)this.rand.nextFloat() < d10)) {
                entity.setFire(this.burnTime);
            }
            double d11 = EnchantmentProtection.func_92092_a((Entity)entity, (double)d10);
            entity.motionX += d0 * d11 * (double)this.motionFactor;
            entity.motionY += d1 * d11 * (double)this.motionFactor;
            entity.motionZ += d2 * d11 * (double)this.motionFactor;
            if (!(entity instanceof EntityPlayer)) continue;
            this.affectedPlayers.put((EntityPlayer)entity, Vec3.createVectorHelper((double)(d0 * d10), (double)(d1 * d10), (double)(d2 * d10)));
        }
    }

    public Map func_77277_b() {
        return this.affectedPlayers;
    }

    protected void notifyClients() {
        if (!this.worldObj.isRemote) {
            for (EntityPlayer player : this.worldObj.playerEntities) {
                if (!(player.getDistanceSq(this.explosionX, this.explosionY, this.explosionZ) < 4096.0)) continue;
                ((EntityPlayerMP)player).playerNetServerHandler.sendPacket((Packet)new S27PacketExplosion(this.explosionX, this.explosionY, this.explosionZ, this.explosionSize, this.affectedBlockPositions, (Vec3)this.func_77277_b().get(player)));
            }
        }
    }

    public static enum IgnoreLiquid {
        NONE,
        ALL,
        WATER,
        LAVA;

    }
}

