/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.entity;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.eventhandler.Event;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.entity.ICustomMerchant;
import zeldaswordskills.api.entity.INpcVillager;
import zeldaswordskills.entity.npc.EntityNpcBarnes;
import zeldaswordskills.entity.npc.EntityNpcMaskTrader;
import zeldaswordskills.entity.npc.EntityNpcOrca;
import zeldaswordskills.entity.npc.EntityNpcZelda;

public class NpcHelper {
    private static final Map<String, Class<? extends EntityLiving>> nameToClassMap = Maps.newHashMap();

    public static void addVillagerConversion(String name, Class<? extends EntityLiving> npcClass) {
        if (!npcClass.isAssignableFrom(INpcVillager.class)) {
            throw new IllegalArgumentException("Entity class must implement INpcVillager to add a villager conversion mapping");
        }
        if (nameToClassMap.containsKey(name)) {
            ZSSMain.logger.warn("Failed to add villager conversion for " + name + ": entry already exists - " + nameToClassMap.get(name));
        }
        nameToClassMap.put(name, npcClass);
    }

    public static Event.Result convertVillager(EntityPlayer player, EntityVillager villager, boolean rightClick) {
        Event.Result result = Event.Result.DEFAULT;
        String name = villager.getCustomNameTag();
        for (String match : nameToClassMap.keySet()) {
            if (!match.equals(name)) continue;
            EntityLiving npc = NpcHelper.getNpcForName(name, villager.worldObj);
            if (!(npc instanceof INpcVillager)) break;
            npc.setLocationAndAngles(villager.posX, villager.posY + (double)0.2f, villager.posZ, villager.rotationYaw, villager.rotationPitch);
            Event.Result result2 = result = rightClick ? ((INpcVillager)npc).canInteractConvert(player, villager) : ((INpcVillager)npc).canLeftClickConvert(player, villager);
            if (result != Event.Result.ALLOW || villager.worldObj.isRemote) break;
            if (npc instanceof ICustomMerchant) {
                ((ICustomMerchant)npc).setMerchantTrades(villager.getRecipes(player));
            }
            if (npc instanceof EntityLiving) {
                npc.onSpawnWithEgg(null);
            }
            npc.setCustomNameTag(name);
            villager.setDead();
            villager.worldObj.spawnEntityInWorld((Entity)npc);
            ((INpcVillager)npc).onConverted(player);
            break;
        }
        return result;
    }

    private static EntityLiving getNpcForName(String name, World world) {
        EntityLiving npc = null;
        try {
            npc = nameToClassMap.get(name).getConstructor(World.class).newInstance(world);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return npc;
    }

    static {
        nameToClassMap.put("Barnes", EntityNpcBarnes.class);
        nameToClassMap.put("Happy Mask Salesman", EntityNpcMaskTrader.class);
        nameToClassMap.put("Mask Salesman", EntityNpcMaskTrader.class);
        nameToClassMap.put("Orca", EntityNpcOrca.class);
        nameToClassMap.put("Princess Zelda", EntityNpcZelda.class);
        nameToClassMap.put("Zelda", EntityNpcZelda.class);
    }
}

