/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.entity.ai;

import net.minecraft.entity.EntityCreature;
import net.minecraft.util.MathHelper;
import zeldaswordskills.api.entity.ai.EntityAIDynamicAction;
import zeldaswordskills.api.entity.ai.EntityAction;

public class EntityAIDynamicRangedAction
extends EntityAIDynamicAction {
    protected final float range;
    protected final float minRangeSq;
    protected final int minDelay;
    protected final int maxDelay;
    protected final float speed;
    protected int visibilityTimer;
    protected int delay;
    protected int timer;
    protected boolean difficultScaled;

    public <T extends EntityCreature> EntityAIDynamicRangedAction(T entity, EntityAction action, float rangeMin, float rangeMax, int minDelay, int maxDelay, float speed, boolean require_ground) {
        this(entity, action, rangeMin, rangeMax, minDelay, maxDelay, speed, require_ground, true);
    }

    public <T extends EntityCreature> EntityAIDynamicRangedAction(T entity, EntityAction action, float rangeMin, float rangeMax, int minDelay, int maxDelay, float speed, boolean require_ground, boolean require_sight) {
        super(entity, action, rangeMax, require_ground, require_sight);
        this.range = rangeMax;
        this.minRangeSq = rangeMin * rangeMin;
        this.minDelay = minDelay;
        this.maxDelay = maxDelay;
        this.speed = speed;
    }

    public EntityAIDynamicRangedAction setDifficultyScaled() {
        this.difficultScaled = true;
        return this;
    }

    @Override
    protected boolean checkRange() {
        double distance = this.entity.getDistanceSqToEntity(this.target);
        return distance > (double)this.minRangeSq && distance <= (double)this.rangeSq;
    }

    @Override
    protected boolean canPerformAction() {
        if (this.target == null || !this.target.isEntityAlive()) {
            return false;
        }
        if (this.require_ground && !this.entity.onGround) {
            return false;
        }
        return !this.require_sight || this.entity.getEntitySenses().canSee(this.target);
    }

    @Override
    public boolean continueExecuting() {
        return super.continueExecuting() || !this.entity.getNavigator().noPath();
    }

    @Override
    public boolean shouldExecute() {
        if (super.shouldExecute()) {
            if (this.target == null) {
                return true;
            }
            if (this.delay == 0) {
                float f = this.entity.getDistanceToEntity(this.target) / this.range;
                float scale = this.difficultScaled ? 2.0f - 0.5f * (float)this.entity.worldObj.difficultySetting.getDifficultyId() : 1.0f;
                this.delay = MathHelper.floor_float((float)(f * scale * (float)(this.maxDelay - this.minDelay)));
                this.delay += this.minDelay - this.entity.worldObj.rand.nextInt(Math.max(1, this.minDelay));
            }
            return this.timer++ > this.delay;
        }
        if (this.target != null) {
            this.moveIntoPosition();
        }
        return false;
    }

    protected boolean moveIntoPosition() {
        double distance = this.entity.getDistanceSq(this.target.posX, this.target.boundingBox.minY, this.target.posZ);
        boolean flag = this.entity.getEntitySenses().canSee(this.target);
        this.visibilityTimer = flag ? ++this.visibilityTimer : 0;
        if (distance <= (double)this.rangeSq && this.visibilityTimer >= 20) {
            this.entity.getNavigator().clearPathEntity();
            return false;
        }
        if (this.speed > 0.0f) {
            this.entity.getNavigator().tryMoveToEntityLiving(this.target, (double)this.speed);
        }
        this.entity.getLookHelper().setLookPositionWithEntity(this.target, 30.0f, 30.0f);
        return this.speed > 0.0f;
    }

    @Override
    public void resetTask() {
        super.resetTask();
        this.target = null;
        this.delay = 0;
        this.timer = 0;
        this.visibilityTimer = 0;
    }
}

