/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import zeldaswordskills.api.block.IBoomerangBlock;
import zeldaswordskills.api.block.IExplodable;
import zeldaswordskills.api.block.IQuakeBlock;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.CustomExplosion;
import zeldaswordskills.api.entity.IEntityBomb;
import zeldaswordskills.client.render.block.RenderSpecialCrop;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.entity.projectile.EntityBoomerang;
import zeldaswordskills.entity.projectile.EntityWhip;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;

public class BlockBombFlower
extends BlockCrops
implements IBoomerangBlock,
IExplodable,
IQuakeBlock,
IWhipBlock {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public BlockBombFlower() {
        this.setCreativeTab(null);
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Cave;
    }

    protected Item func_149866_i() {
        return ZSSItems.bombFlowerSeed;
    }

    protected Item func_149865_P() {
        return ZSSItems.bombFlowerSeed;
    }

    public boolean canDropFromExplosion(Explosion explosion) {
        return false;
    }

    protected boolean canPlaceBlockOn(Block block) {
        return block.getMaterial() == Material.rock;
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        Block soil = world.getBlock(x, y - 1, z);
        return this.canPlaceBlockOn(soil) && this.hasLava(world, x, y - 1, z);
    }

    private boolean hasLava(World world, int x, int y, int z) {
        boolean hasLava = world.getBlock(x - 1, y, z).getMaterial() == Material.lava || world.getBlock(x + 1, y, z).getMaterial() == Material.lava || world.getBlock(x, y, z - 1).getMaterial() == Material.lava || world.getBlock(x, y, z + 1).getMaterial() == Material.lava;
        return hasLava;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.getHeldItem() != null || world.getBlockMetadata(x, y, z) != 7) {
            return false;
        }
        if (!world.isRemote) {
            player.setCurrentItemOrArmor(0, new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_FLOWER.ordinal()));
            world.setBlockMetadataWithNotify(x, y, z, 0, 2);
        }
        return true;
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        if (world.getBlockMetadata(x, y, z) == 7) {
            if (PlayerUtils.isHoldingWeapon(player)) {
                this.createExplosion(world, x, y, z, true);
            } else {
                this.disperseSeeds(world, x, y, z, true);
            }
        }
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 7) {
            world.setBlockMetadataWithNotify(x, y, z, 15, 2);
            world.scheduleBlockUpdate(x, y, z, (Block)this, 5);
        } else if (meta < 7) {
            Entity exploder;
            Entity entity = exploder = explosion instanceof CustomExplosion ? ((CustomExplosion)explosion).exploder : null;
            if (!(exploder instanceof IEntityBomb) || ((IEntityBomb)exploder).getType() != BombType.BOMB_FLOWER) {
                super.onBlockExploded(world, x, y, z, explosion);
            }
        }
    }

    @Override
    public boolean onBoomerangCollided(World world, int x, int y, int z, EntityBoomerang boomerang) {
        if (!world.isRemote && world.getBlockMetadata(x, y, z) == 7) {
            boolean captured = false;
            world.setBlockMetadataWithNotify(x, y, z, 0, 2);
            EntityItem bomb = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_FLOWER.ordinal()));
            world.spawnEntityInWorld((Entity)bomb);
            if (boomerang.captureItem(bomb)) {
                captured = true;
            } else {
                bomb.setDead();
            }
            if (!captured) {
                this.createExplosion(world, x, y, z, true);
            }
        }
        return false;
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (world.getBlockMetadata(x, y, z) == 7 && entity instanceof IProjectile) {
            this.createExplosion(world, x, y, z, true);
        }
    }

    @Override
    public void handleQuakeEffect(World world, int x, int y, int z, EntityPlayer player) {
        if (world.getBlockMetadata(x, y, z) == 7) {
            this.createExplosion(world, x, y, z, true);
        }
    }

    @Override
    public boolean canBreakBlock(IWhipBlock.WhipType whip, EntityLivingBase thrower, World world, int x, int y, int z, int side) {
        return this.getGrowthStage(world.getBlockMetadata(x, y, z)) < 2;
    }

    @Override
    public boolean canGrabBlock(IWhipBlock.WhipType whip, EntityLivingBase thrower, World world, int x, int y, int z, int side) {
        return side != 0 && world.getBlockMetadata(x, y, z) == 7;
    }

    @Override
    public Event.Result shouldSwing(EntityWhip whip, World world, int x, int y, int z, int ticksInGround) {
        if (ticksInGround > 30 && world.getBlockMetadata(x, y, z) == 7) {
            EntityLivingBase thrower = whip.getThrower();
            EntityItem bomb = new EntityItem(world, whip.posX, whip.posY + 1.0, whip.posZ, new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_FLOWER.ordinal()));
            double dx = thrower.posX - bomb.posX;
            double dy = thrower.posY + (double)thrower.getEyeHeight() - bomb.posY;
            double dz = thrower.posZ - bomb.posZ;
            TargetUtils.setEntityHeading((Entity)bomb, dx, dy * 1.5, dz, 1.0f, 0.0f, true);
            if (!world.isRemote) {
                world.spawnEntityInWorld((Entity)bomb);
            }
            world.setBlockToAir(x, y, z);
            whip.setDead();
        }
        return Event.Result.DENY;
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        this.checkAndDropBlock(world, x, y, z);
        int meta = world.getBlockMetadata(x, y, z);
        if (meta > 7) {
            this.createExplosion(world, x, y, z, true);
        } else if (meta < 7 && rand.nextInt(6) == 0) {
            world.setBlockMetadataWithNotify(x, y, z, meta + 1, 2);
        } else if (meta == 7 && rand.nextInt(16) == 0) {
            this.disperseSeeds(world, x, y, z, false);
        }
    }

    private void createExplosion(World world, int x, int y, int z, boolean toAir) {
        if (!world.isRemote) {
            if (toAir) {
                world.setBlockToAir(x, y, z);
            }
            CustomExplosion.createExplosion(world, x, y, z, 3.0f, BombType.BOMB_FLOWER);
        }
    }

    private void disperseSeeds(World world, int x, int y, int z, boolean isGriefing) {
        if (!world.isRemote) {
            world.setBlockMetadataWithNotify(x, y, z, 0, 2);
            EntityBomb bomb = new EntityBomb(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5).setType(BombType.BOMB_FLOWER).setFuseTime(64);
            if (!isGriefing) {
                bomb.setNoGrief();
            }
            world.spawnEntityInWorld((Entity)bomb);
        }
    }

    public int getRenderType() {
        return RenderSpecialCrop.renderId;
    }

    private int getGrowthStage(int meta) {
        return (meta &= 7) == 6 ? 2 : meta >> 1;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        int stage = this.getGrowthStage(world.getBlockMetadata(x, y, z));
        if (stage == 0) {
            return null;
        }
        return AxisAlignedBB.getBoundingBox((double)((double)x + this.minX), (double)((double)y + this.minY), (double)((double)z + this.minZ), (double)((double)x + this.maxX), (double)((double)y + this.maxY), (double)((double)z + this.maxZ));
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        int stage = this.getGrowthStage(world.getBlockMetadata(x, y, z));
        this.setBlockBounds(0.1f, 0.0f, 0.1f, 0.9f, 0.2f + (float)stage * 0.15f, 0.9f);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.iconArray[this.getGrowthStage(meta)];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        String s = "zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_stage_";
        this.iconArray = new IIcon[4];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = register.registerIcon(s + i);
        }
    }
}

