/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import zeldaswordskills.api.block.ISongBlock;
import zeldaswordskills.block.BlockChestLocked;
import zeldaswordskills.block.tileentity.TileEntityChestLocked;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.songs.ZeldaSongs;

public class BlockChestInvisible
extends BlockChestLocked
implements ISongBlock {
    public BlockChestInvisible() {
        this.setBlockBounds(0.475f, 0.0f, 0.475f, 0.525f, 0.05f, 0.525f);
    }

    @Override
    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileEntityChestInvisible();
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        TileEntity te = world.getTileEntity(x, y, z);
        if (!(te instanceof IInventory)) {
            return false;
        }
        if (player.capabilities.isCreativeMode) {
            player.displayGUIChest((IInventory)te);
            return true;
        }
        return false;
    }

    @Override
    public boolean onSongPlayed(World world, int x, int y, int z, EntityPlayer player, AbstractZeldaSong song, int power, int affected) {
        TileEntity te;
        if (power > 4 && song == ZeldaSongs.songZeldasLullaby && affected == 0 && (te = world.getTileEntity(x, y, z)) instanceof IInventory) {
            this.convertToChest((IInventory)te, world, x, y, z);
            world.playSoundAtEntity((Entity)player, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        double dx = (double)x + (double)rand.nextFloat();
        double dy = (double)y + 0.1 + (double)rand.nextFloat() * 0.5;
        double dz = (double)z + (double)rand.nextFloat();
        world.spawnParticle("depthsuspend", dx, dy, dz, 0.0, 0.0, 0.0);
    }

    public static class TileEntityChestInvisible
    extends TileEntityChestLocked {
    }
}

