/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.block.tileentity.TileEntityChestLocked;
import zeldaswordskills.client.render.block.RenderChestLocked;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class BlockChestLocked
extends BlockContainer {
    private static boolean keepInventory;

    public BlockChestLocked() {
        super(Material.wood);
        this.setBlockUnbreakable();
        this.setResistance(BlockWeight.IMPOSSIBLE.weight);
        this.setStepSound(soundTypeWood);
        this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        this.setCreativeTab(ZSSCreativeTabs.tabBlocks);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getMobilityFlag() {
        return 2;
    }

    public int getRenderType() {
        return RenderChestLocked.renderId;
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileEntityChestLocked();
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return false;
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        if (!keepInventory) {
            WorldUtils.dropContainerBlockInventory(world, x, y, z);
        }
        super.breakBlock(world, x, y, z, block, meta);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        TileEntity te = world.getTileEntity(x, y, z);
        if (!(te instanceof IInventory)) {
            return false;
        }
        if (player.capabilities.isCreativeMode && !player.isSneaking()) {
            player.displayGUIChest((IInventory)te);
            return true;
        }
        if (this.canUnlock(player)) {
            this.convertToChest((IInventory)te, world, x, y, z);
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:lock_chest", 0.4f, 0.5f);
            return true;
        }
        WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:lock_rattle", 0.4f, 0.5f);
        return false;
    }

    protected void convertToChest(IInventory inv, World world, int x, int y, int z) {
        TileEntity chest;
        boolean isChest;
        int meta = world.getBlockMetadata(x, y, z);
        keepInventory = true;
        world.setBlock(x, y, z, (Block)Blocks.chest);
        keepInventory = false;
        boolean bl = isChest = world.getBlock(x + 1, y, z) == Blocks.chest;
        if (!isChest) {
            boolean bl2 = isChest = world.getBlock(x - 1, y, z) == Blocks.chest;
        }
        if (!isChest) {
            boolean bl3 = isChest = world.getBlock(x, y, z + 1) == Blocks.chest;
        }
        if (!isChest) {
            boolean bl4 = isChest = world.getBlock(x, y, z - 1) == Blocks.chest;
        }
        if (!isChest) {
            world.setBlockMetadataWithNotify(x, y, z, meta, 3);
        }
        if ((chest = world.getTileEntity(x, y, z)) instanceof TileEntityChest) {
            IInventory inv2 = (IInventory)chest;
            for (int i = 0; i < inv.getSizeInventory() && i < inv2.getSizeInventory(); ++i) {
                inv2.setInventorySlotContents(i, inv.getStackInSlot(i));
            }
        }
    }

    private boolean canUnlock(EntityPlayer player) {
        ItemStack key = player.getHeldItem();
        if (key != null) {
            if (key.getItem() == ZSSItems.keySmall) {
                return PlayerUtils.consumeHeldItem(player, ZSSItems.keySmall, 1);
            }
            if (key.getItem() == ZSSItems.keySkeleton) {
                key.damageItem(1, (EntityLivingBase)player);
                return true;
            }
        }
        return false;
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        super.onBlockAdded(world, x, y, z);
        Block l = world.getBlock(x, y, z - 1);
        Block i1 = world.getBlock(x, y, z + 1);
        Block j1 = world.getBlock(x - 1, y, z);
        Block k1 = world.getBlock(x + 1, y, z);
        int meta = 3;
        if (l.func_149730_j() && !i1.func_149730_j()) {
            meta = 3;
        }
        if (i1.func_149730_j() && !l.func_149730_j()) {
            meta = 2;
        }
        if (j1.func_149730_j() && !k1.func_149730_j()) {
            meta = 5;
        }
        if (k1.func_149730_j() && !j1.func_149730_j()) {
            meta = 4;
        }
        world.setBlockMetadataWithNotify(x, y, z, meta, 3);
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int face = MathHelper.floor_double((double)((double)(entity.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        byte meta = (byte)(face == 0 ? 2 : (face == 1 ? 5 : (face == 2 ? 3 : 4)));
        world.setBlockMetadataWithNotify(x, y, z, (int)meta, 3);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.blockIcon = register.registerIcon("planks_oak");
    }
}

