/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.client.render.block.RenderGiantLever;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.projectile.EntityWhip;
import zeldaswordskills.util.WorldUtils;

public class BlockGiantLever
extends BlockLever
implements IWhipBlock {
    public BlockGiantLever() {
        this.setHardness(1.0f);
        this.setStepSound(soundTypeWood);
        this.setBlockTextureName("zeldaswordskills:lever_giant");
        this.setCreativeTab(ZSSCreativeTabs.tabBlocks);
        this.setBlockBounds(0.125f, 0.0f, 0.125f, 0.875f, 0.8f, 0.875f);
    }

    @Override
    public boolean canBreakBlock(IWhipBlock.WhipType whip, EntityLivingBase thrower, World world, int x, int y, int z, int side) {
        return false;
    }

    @Override
    public boolean canGrabBlock(IWhipBlock.WhipType whip, EntityLivingBase thrower, World world, int x, int y, int z, int side) {
        return true;
    }

    @Override
    public Event.Result shouldSwing(EntityWhip whip, World world, int x, int y, int z, int ticksInGround) {
        if (ticksInGround > 40 - whip.getType().ordinal() * 5) {
            WorldUtils.activateButton(world, (Block)this, x, y, z);
            whip.setDead();
        }
        return Event.Result.DENY;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        switch (world.getBlockMetadata(x, y, z) & 7) {
            case 0: {
                return AxisAlignedBB.getBoundingBox((double)((float)x + 0.125f), (double)((float)y + 0.625f), (double)((float)z + 0.2f), (double)((float)x + 0.875f), (double)((float)y + 1.0f), (double)((float)z + 0.8f));
            }
            case 1: {
                return AxisAlignedBB.getBoundingBox((double)((float)x + 0.0f), (double)((float)y + 0.125f), (double)((float)z + 0.2f), (double)((float)x + 0.375f), (double)((float)y + 0.875f), (double)((float)z + 0.8f));
            }
            case 2: {
                return AxisAlignedBB.getBoundingBox((double)((float)x + 0.625f), (double)((float)y + 0.125f), (double)((float)z + 0.2f), (double)((float)x + 1.0f), (double)((float)y + 0.875f), (double)((float)z + 0.8f));
            }
            case 3: {
                return AxisAlignedBB.getBoundingBox((double)((float)x + 0.2f), (double)((float)y + 0.125f), (double)((float)z + 0.0f), (double)((float)x + 0.8f), (double)((float)y + 0.875f), (double)((float)z + 0.375f));
            }
            case 4: {
                return AxisAlignedBB.getBoundingBox((double)((float)x + 0.2f), (double)((float)y + 0.125f), (double)((float)z + 0.625f), (double)((float)x + 0.8f), (double)((float)y + 0.875f), (double)((float)z + 1.0f));
            }
            case 5: {
                return AxisAlignedBB.getBoundingBox((double)((float)x + 0.2f), (double)((float)y + 0.0f), (double)((float)z + 0.125f), (double)((float)x + 0.8f), (double)((float)y + 0.375f), (double)((float)z + 0.875f));
            }
            case 6: {
                return AxisAlignedBB.getBoundingBox((double)((float)x + 0.125f), (double)((float)y + 0.0f), (double)((float)z + 0.2f), (double)((float)x + 0.875f), (double)((float)y + 0.375f), (double)((float)z + 0.8f));
            }
            case 7: {
                return AxisAlignedBB.getBoundingBox((double)((float)x + 0.2f), (double)((float)y + 0.625f), (double)((float)z + 0.125f), (double)((float)x + 0.8f), (double)((float)y + 1.0f), (double)((float)z + 0.875f));
            }
        }
        return null;
    }

    public int getRenderType() {
        return RenderGiantLever.renderId;
    }

    public int getMobilityFlag() {
        return 2;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        switch (world.getBlockMetadata(x, y, z) & 7) {
            case 0: {
                this.setBlockBounds(0.125f, 0.2f, 0.2f, 0.875f, 1.0f, 0.8f);
                break;
            }
            case 1: {
                this.setBlockBounds(0.0f, 0.125f, 0.2f, 0.8f, 0.875f, 0.8f);
                break;
            }
            case 2: {
                this.setBlockBounds(0.2f, 0.125f, 0.2f, 1.0f, 0.875f, 0.8f);
                break;
            }
            case 3: {
                this.setBlockBounds(0.2f, 0.125f, 0.0f, 0.8f, 0.875f, 0.8f);
                break;
            }
            case 4: {
                this.setBlockBounds(0.2f, 0.125f, 0.2f, 0.8f, 0.875f, 1.0f);
                break;
            }
            case 5: {
                this.setBlockBounds(0.2f, 0.0f, 0.125f, 0.8f, 0.8f, 0.875f);
                break;
            }
            case 6: {
                this.setBlockBounds(0.125f, 0.0f, 0.2f, 0.875f, 0.8f, 0.8f);
                break;
            }
            case 7: {
                this.setBlockBounds(0.2f, 0.2f, 0.125f, 0.8f, 1.0f, 0.875f);
            }
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z) > 7 ? this.blockHardness : -1.0f;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return world.getBlockMetadata(x, y, z) > 7;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return world.getBlockMetadata(x, y, z) > 7 ? this.getExplosionResistance(entity) : BlockWeight.getMaxResistance();
    }
}

