/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.item.WeaponRegistry;
import zeldaswordskills.block.tileentity.TileEntityPedestal;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.util.WorldUtils;

public class BlockPedestal
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBottom;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconSide;

    public BlockPedestal() {
        super(Material.rock);
        this.setHardness(1.5f);
        this.setResistance(15.0f);
        this.setLightLevel(0.5f);
        this.setStepSound(soundTypeStone);
        this.setCreativeTab(ZSSCreativeTabs.tabBlocks);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileEntityPedestal();
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getMobilityFlag() {
        return 2;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return meta == 8;
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z) == 8 ? this.blockHardness : -1.0f;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return world.getBlockMetadata(x, y, z) == 8 ? this.getExplosionResistance(entity) : BlockWeight.getMaxResistance();
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (world.getBlockMetadata(x, y, z) == 8) {
            super.onBlockExploded(world, x, y, z, explosion);
        }
    }

    public int damageDropped(int meta) {
        return meta == 8 ? 8 : 0;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.isSneaking() || !(world.getTileEntity(x, y, z) instanceof TileEntityPedestal)) {
            return false;
        }
        if (!world.isRemote) {
            TileEntityPedestal te = (TileEntityPedestal)world.getTileEntity(x, y, z);
            if (!te.hasSword() && player.getHeldItem() != null && WeaponRegistry.INSTANCE.isSword(player.getHeldItem().getItem())) {
                te.setSword(player.getHeldItem(), player);
                player.setCurrentItemOrArmor(0, null);
            } else if (world.getBlockMetadata(x, y, z) == 8 && te.hasSword()) {
                te.retrieveSword();
            } else {
                player.openGui((Object)ZSSMain.instance, 0, world, x, y, z);
            }
        }
        return true;
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity te;
        if (!world.isRemote && (te = world.getTileEntity(x, y, z)) instanceof TileEntityPedestal) {
            ((TileEntityPedestal)te).changeOrientation();
        }
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity te;
        if (stack.getItemDamage() == 8 && (te = world.getTileEntity(x, y, z)) instanceof TileEntityPedestal) {
            ((TileEntityPedestal)te).onBlockPlaced();
        }
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te;
        if (meta != 8) {
            WorldUtils.dropContainerBlockInventory(world, x, y, z);
        } else if (meta == 8 && (te = world.getTileEntity(x, y, z)) instanceof TileEntityPedestal) {
            ((TileEntityPedestal)te).retrieveSword();
        }
        super.breakBlock(world, x, y, z, block, meta);
    }

    public boolean canProvidePower() {
        return true;
    }

    public int isProvidingWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPedestal) {
            return ((TileEntityPedestal)te).getPowerLevel();
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 8));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return side == 0 ? this.iconBottom : (side == 1 ? this.iconTop : this.iconSide[Math.min(meta, 7)]);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.iconTop = register.registerIcon("zeldaswordskills:pedestal_top");
        this.iconBottom = register.registerIcon("zeldaswordskills:pedestal_bottom");
        this.iconSide = new IIcon[8];
        for (int i = 0; i < this.iconSide.length; ++i) {
            this.iconSide[i] = register.registerIcon("zeldaswordskills:pedestal_side_" + i);
        }
    }
}

