/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.IHookable;
import zeldaswordskills.api.block.ISmashable;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.api.item.ISmashBlock;
import zeldaswordskills.block.IDungeonBlock;
import zeldaswordskills.block.ZSSBlockMaterials;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.projectile.EntityWhip;

public class BlockPeg
extends Block
implements IDungeonBlock,
IHookable,
ISmashable,
IWhipBlock {
    private final BlockWeight weight;
    private static final int MAX_STATE = 3;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBottom;

    public BlockPeg(Material material, BlockWeight weight) {
        super(material);
        this.weight = weight;
        this.disableStats();
        this.setTickRandomly(true);
        this.setBlockUnbreakable();
        this.setResistance(BlockWeight.IMPOSSIBLE.weight);
        this.setStepSound(soundTypeStone);
        this.setCreativeTab(ZSSCreativeTabs.tabBlocks);
        this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 0.8f, 0.75f);
    }

    private String getHitSound() {
        return this.blockMaterial == ZSSBlockMaterials.pegRustyMaterial ? "zeldaswordskills:hit_rusty" : "zeldaswordskills:hit_peg";
    }

    @Override
    public Event.Result canGrabBlock(IHookable.HookshotType type, World world, int x, int y, int z, int side) {
        if (side == 0 || side == 1 || world.getBlockMetadata(x, y, z) > 0) {
            return Event.Result.DENY;
        }
        return type.getBaseType() == IHookable.HookshotType.MULTI_SHOT ? Event.Result.ALLOW : Event.Result.DEFAULT;
    }

    @Override
    public Event.Result canDestroyBlock(IHookable.HookshotType type, World world, int x, int y, int z, int side) {
        return Event.Result.DENY;
    }

    @Override
    public Material getHookableMaterial(IHookable.HookshotType type, World world, int x, int y, int z) {
        return this.blockMaterial == ZSSBlockMaterials.pegWoodMaterial ? Material.wood : Material.iron;
    }

    @Override
    public BlockWeight getSmashWeight(EntityPlayer player, ItemStack stack, int meta, int side) {
        return this.weight;
    }

    @Override
    public Event.Result onSmashed(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int side) {
        world.playSoundEffect((double)x, (double)y, (double)z, this.getHitSound(), world.rand.nextFloat() * 0.4f + 0.5f, 1.0f / (world.rand.nextFloat() * 0.4f + 0.5f));
        if (side == 1) {
            int meta = world.getBlockMetadata(x, y, z);
            int impact = 1 + ((ISmashBlock)stack.getItem()).getSmashStrength(player, stack, this, meta).ordinal() - this.weight.ordinal();
            if (impact > 0) {
                boolean flag;
                boolean bl = flag = meta < 3;
                if ((meta += impact) >= 3) {
                    if (this == ZSSBlocks.pegRusty) {
                        player.triggerAchievement((StatBase)ZSSAchievements.hardHitter);
                    } else if (this == ZSSBlocks.pegWooden) {
                        player.triggerAchievement((StatBase)ZSSAchievements.hammerTime);
                    }
                }
                if (meta > 3 && impact > 1) {
                    flag = true;
                    world.func_147480_a(x, y, z, false);
                } else {
                    world.setBlockMetadataWithNotify(x, y, z, Math.min(meta, 3), 3);
                }
                return flag ? Event.Result.ALLOW : Event.Result.DENY;
            }
        }
        return Event.Result.DENY;
    }

    @Override
    public boolean canBreakBlock(IWhipBlock.WhipType whip, EntityLivingBase thrower, World world, int x, int y, int z, int side) {
        return false;
    }

    @Override
    public boolean canGrabBlock(IWhipBlock.WhipType whip, EntityLivingBase thrower, World world, int x, int y, int z, int side) {
        return side != 0 && side != 1 && world.getBlockMetadata(x, y, z) < 3;
    }

    @Override
    public Event.Result shouldSwing(EntityWhip whip, World world, int x, int y, int z, int ticksInGround) {
        if (world.getBlockMetadata(x, y, z) >= 3) {
            whip.setDead();
            return Event.Result.DENY;
        }
        return Event.Result.DEFAULT;
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta > 0) {
            world.setBlockMetadataWithNotify(x, y, z, meta - 1, 3);
        }
    }

    public int tickRate(World world) {
        return 60;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 0) {
            return AxisAlignedBB.getBoundingBox((double)((double)x + this.minX), (double)((double)y + this.minY), (double)((double)z + this.minZ), (double)((double)x + this.maxX), (double)((double)y + this.maxY + 0.5), (double)((double)z + this.maxZ));
        }
        if (meta >= 3) {
            return null;
        }
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        int meta = Math.min(world.getBlockMetadata(x, y, z), 3);
        this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 0.8f - (float)meta * 0.2f, 0.75f);
    }

    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 0.8f, 0.75f);
    }

    @Override
    public boolean isSameVariant(World world, int x, int y, int z, int expected) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return side == 0 ? this.iconBottom : (side == 1 ? this.iconTop : this.blockIcon);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.blockIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_side");
        this.iconTop = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_top");
        this.iconBottom = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_bottom");
    }
}

