/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.IExplodable;
import zeldaswordskills.api.block.ILiftable;
import zeldaswordskills.api.block.ISmashable;
import zeldaswordskills.block.IDungeonBlock;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.PlayerUtils;

public class BlockSecretStone
extends Block
implements IDungeonBlock,
IExplodable,
ILiftable,
ISmashable {
    public static final String[] names = new String[]{"stone", "sandstone_normal", "nether_brick", "stonebrick", "cobblestone_mossy", "ice", "cobblestone", "end_stone"};
    private static final int[] slabs = new int[]{0, 1, 6, 5, 3, 7, 3, 7};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public BlockSecretStone(Material material) {
        super(material);
        this.setBlockUnbreakable();
        this.setResistance(6.0f);
        this.setStepSound(soundTypeStone);
        this.setCreativeTab(ZSSCreativeTabs.tabBlocks);
    }

    @Override
    public BlockWeight getLiftWeight(EntityPlayer player, ItemStack stack, int meta, int side) {
        return meta > 7 || !Config.canLiftSecretStone() ? BlockWeight.IMPOSSIBLE : null;
    }

    @Override
    public void onLifted(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int meta) {
        NBTTagCompound tag = stack.getTagCompound();
        if (tag != null) {
            tag.setInteger("blockId", Block.getIdFromBlock((Block)BlockSecretStone.getBlockFromMeta(meta)));
            tag.setInteger("metadata", 0);
        }
    }

    @Override
    public void onHeldBlockPlaced(World world, ItemStack stack, int x, int y, int z, int meta) {
    }

    @Override
    public BlockWeight getSmashWeight(EntityPlayer player, ItemStack stack, int meta, int side) {
        return meta < 8 ? BlockWeight.VERY_HEAVY : BlockWeight.IMPOSSIBLE;
    }

    @Override
    public Event.Result onSmashed(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int side) {
        return Event.Result.DEFAULT;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return world.getBlockMetadata(x, y, z) < 8;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public int getMobilityFlag() {
        return 2;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return false;
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public Item getItemDropped(int meta, Random rand, int fortune) {
        return Item.getItemFromBlock((Block)BlockSecretStone.getBlockFromMeta(meta));
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack(this.getItemDropped(meta, world.rand, fortune)));
        return drops;
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        if (player.getHeldItem() != null && player.getHeldItem().getItem() instanceof ItemPickaxe) {
            if (!world.isRemote) {
                world.playSoundAtEntity((Entity)player, "random.break", 0.25f, 1.0f / (world.rand.nextFloat() * 0.4f + 0.5f));
            } else if (Config.showSecretMessage) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.block.secret", new Object[0]);
            }
        }
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return world.getBlockMetadata(x, y, z) < 8 ? this.getExplosionResistance(entity) : BlockWeight.getMaxResistance();
    }

    @Override
    public boolean isSameVariant(World world, int x, int y, int z, int expected) {
        return world.getBlockMetadata(x, y, z) == expected;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < names.length; ++i) {
            list.add(new ItemStack(item, 1, i));
            list.add(new ItemStack(item, 1, i | 8));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.iconArray[(meta & 0xFFFFFFF7) % names.length];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.iconArray = new IIcon[names.length];
        for (int i = 0; i < names.length; ++i) {
            this.iconArray[i] = register.registerIcon(names[i]);
        }
    }

    public static Block getBlockFromMeta(int meta) {
        switch (meta & 0xFFFFFFF7) {
            case 0: {
                return Blocks.stone;
            }
            case 1: {
                return Blocks.sandstone;
            }
            case 2: {
                return Blocks.nether_brick;
            }
            case 3: {
                return Blocks.stonebrick;
            }
            case 4: {
                return Blocks.mossy_cobblestone;
            }
            case 5: {
                return Blocks.ice;
            }
            case 6: {
                return Blocks.cobblestone;
            }
            case 7: {
                return Blocks.end_stone;
            }
        }
        return Blocks.stone;
    }

    public static Block getStairsFromMeta(int meta) {
        switch (meta & 0xFFFFFFF7) {
            case 0: 
            case 3: {
                return Blocks.stone_brick_stairs;
            }
            case 1: {
                return Blocks.sandstone_stairs;
            }
            case 2: {
                return Blocks.nether_brick_stairs;
            }
            case 5: 
            case 7: {
                return Blocks.quartz_stairs;
            }
        }
        return Blocks.stone_stairs;
    }

    public static int getSlabTypeFromMeta(int meta) {
        return slabs[meta % 8];
    }
}

