/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block.tileentity;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.block.BlockSecretStone;
import zeldaswordskills.block.BlockWarpStone;
import zeldaswordskills.block.IDungeonBlock;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.block.tileentity.TileEntityDungeonBlock;
import zeldaswordskills.entity.IEntityVariant;
import zeldaswordskills.entity.mobs.EntityChu;
import zeldaswordskills.entity.mobs.EntityDarknut;
import zeldaswordskills.entity.mobs.EntityKeese;
import zeldaswordskills.entity.mobs.EntityOctorok;
import zeldaswordskills.entity.mobs.EntityWizzrobe;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.BossType;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.world.crisis.BossBattle;
import zeldaswordskills.world.gen.feature.FairySpawner;

public class TileEntityDungeonCore
extends TileEntityDungeonBlock {
    protected StructureBoundingBox box;
    private FairySpawner fairySpawner = null;
    private boolean isBossRoom = false;
    private BossType dungeonType;
    private BossBattle bossBattle = null;
    private boolean isOpened;
    private Block door = null;
    private int doorMeta = 0;
    private int doorSide;
    private boolean alreadyVerified = false;

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void setDungeonBoundingBox(StructureBoundingBox box) {
        this.box = box;
    }

    public StructureBoundingBox getDungeonBoundingBox() {
        return this.box;
    }

    public void setBossType(BossType type) {
        this.dungeonType = type;
        this.isBossRoom = true;
    }

    public BossType getBossType() {
        return this.dungeonType;
    }

    public void setDoor(Block block, int meta, int side) {
        this.door = block;
        this.doorMeta = meta;
        this.doorSide = side;
    }

    public boolean isSpawner() {
        return this.fairySpawner != null;
    }

    public void setSpawner() {
        if (this.box == null) {
            this.alreadyVerified = true;
            this.setDungeonBoundingBox(new StructureBoundingBox(this.xCoord - 3, this.yCoord, this.zCoord - 3, this.xCoord + 3, this.yCoord + 4, this.zCoord + 3));
        }
        this.fairySpawner = new FairySpawner(this).setMaxFairies(this.worldObj.rand.nextInt(5) + 2);
    }

    public void scheduleItemUpdate(EntityPlayer player) {
        if (this.isSpawner()) {
            this.fairySpawner.scheduleItemUpdate(player);
        }
    }

    public boolean consumeRupees(int amount) {
        return this.isSpawner() && this.fairySpawner.consumeRupees(amount);
    }

    private boolean shouldUpdate() {
        return this.bossBattle == null && this.worldObj.getTotalWorldTime() % 20L == 0L && this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, 16.0) != null;
    }

    public void updateEntity() {
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.isBossRoom && this.bossBattle == null) {
            if (this.box == null) {
                ZSSMain.logger.warn(String.format("Boss room at %d/%d/%d missing structure bounding box - dungeon is being disabled", this.xCoord, this.yCoord, this.zCoord));
                this.verifyStructure(true);
                this.removeCoreBlock();
            } else {
                EntityPlayer closestPlayer = this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, (double)(this.box.getXSize() - 2) / 2.0);
                if (closestPlayer != null && this.box.isVecInside(MathHelper.floor_double((double)closestPlayer.posX), MathHelper.floor_double((double)closestPlayer.posY), MathHelper.floor_double((double)closestPlayer.posZ))) {
                    if (!this.isOpened) {
                        PlayerUtils.sendTranslatedChat(closestPlayer, "chat.zss.dungeon.sneak_in", new Object[0]);
                        this.verifyStructure(true);
                        this.alreadyVerified = true;
                    }
                    this.bossBattle = this.dungeonType.getBossBattle(this);
                    if (this.bossBattle != null) {
                        this.bossBattle.beginCrisis(this.worldObj);
                    }
                }
            }
        }
        if (this.bossBattle != null) {
            this.bossBattle.onUpdate(this.worldObj);
            if (this.bossBattle.isFinished()) {
                this.bossBattle = null;
                this.removeCoreBlock();
            }
        } else if (this.shouldUpdate()) {
            if (!this.alreadyVerified && this.box != null && !this.verifyStructure(false)) {
                this.verifyStructure(true);
                this.alreadyVerified = true;
                if (this.isBossRoom) {
                    this.isOpened = true;
                } else {
                    this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)(this.yCoord + 1), (double)this.zCoord + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
                    this.removeCoreBlock();
                }
            } else if (this.isSpawner()) {
                this.fairySpawner.onUpdate();
            }
        }
    }

    protected void removeCoreBlock() {
        EntityPlayer player = this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 2.5, (double)this.zCoord + 0.5, 16.0);
        if (player != null) {
            ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
            if (this.dungeonType != null) {
                this.clearDungeon();
                info.addStat(ZSSPlayerInfo.Stats.STAT_BOSS_ROOMS, 1 << this.dungeonType.ordinal());
                player.triggerAchievement((StatBase)ZSSAchievements.bossBattle);
                if (info.getStat(ZSSPlayerInfo.Stats.STAT_BOSS_ROOMS) == 127) {
                    player.triggerAchievement((StatBase)ZSSAchievements.bossComplete);
                }
                if (this.dungeonType == BossType.DESERT || this.dungeonType == BossType.OCEAN || this.dungeonType == BossType.HELL) {
                    player.triggerAchievement((StatBase)ZSSAchievements.swordPendant);
                }
            } else {
                info.addStat(ZSSPlayerInfo.Stats.STAT_SECRET_ROOMS, 1);
                player.triggerAchievement((StatBase)ZSSAchievements.bombsAway);
                if (info.getStat(ZSSPlayerInfo.Stats.STAT_SECRET_ROOMS) > 49) {
                    player.triggerAchievement((StatBase)ZSSAchievements.bombJunkie);
                }
                if (this.worldObj.rand.nextFloat() < Config.getRoomSpawnMobChance()) {
                    this.spawnRandomMob();
                }
            }
        }
        int meta = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
        if (this.isSpawner()) {
            this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, meta & 0xFFFFFFF7, 2);
        } else {
            this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, BlockSecretStone.getBlockFromMeta(meta), 0, 2);
        }
    }

    public void removeHinderBlock() {
        int x = this.box.getCenterX() + (this.doorSide == 3 ? 1 : (this.doorSide == 1 ? -1 : 0));
        int z = this.box.getCenterZ() + (this.doorSide == 0 ? 1 : (this.doorSide == 2 ? -1 : 0));
        int y = this.worldObj.getBlock(x, this.box.minY + 2, z) == ZSSBlocks.secretStone ? this.box.minY + 2 : this.box.minY + 3;
        this.worldObj.setBlockToAir(x, y, z);
    }

    private void spawnRandomMob() {
        if (this.worldObj.isRemote || this.box == null || this.box.getXSize() < 5) {
            return;
        }
        Block block = this.worldObj.getBlock(this.xCoord, this.yCoord + 1, this.zCoord);
        Object mob = null;
        int rarity = this.worldObj.rand.nextInt(64) - this.worldObj.difficultySetting.getDifficultyId() * 2;
        int type = -1;
        if (block.getMaterial() == Material.water) {
            mob = new EntityOctorok(this.worldObj);
            type = rarity < 8 ? 1 : 0;
        } else if (block.getMaterial() == Material.lava) {
            mob = new EntityKeese(this.worldObj).setSpawnSwarm(false);
            type = rarity > 7 ? EntityKeese.KeeseType.FIRE.ordinal() : EntityKeese.KeeseType.CURSED.ordinal();
        } else {
            mob = rarity > 50 ? new EntityZombie(this.worldObj) : (rarity > 40 ? new EntitySkeleton(this.worldObj) : (rarity > 30 ? (this.worldObj.rand.nextInt(8) > 1 ? new EntitySpider(this.worldObj) : new EntityCaveSpider(this.worldObj)) : (rarity > 20 ? new EntityCreeper(this.worldObj) : (rarity > 10 ? new EntityKeese(this.worldObj).setSpawnSwarm(false) : (rarity > 4 ? new EntityChu(this.worldObj) : (rarity > -2 ? new EntityWizzrobe(this.worldObj) : new EntityDarknut(this.worldObj)))))));
        }
        if (mob != null) {
            mob.setPosition((double)this.xCoord + 0.5, (double)this.yCoord + 1.5, (double)this.zCoord + 0.5);
            mob.onSpawnWithEgg(null);
            if (type > -1 && mob instanceof IEntityVariant) {
                ((IEntityVariant)mob).setType(type);
            }
            this.worldObj.spawnEntityInWorld((Entity)mob);
            mob.playLivingSound();
        }
    }

    private void clearDungeon() {
        Integer meta;
        int x = this.box.getCenterX();
        int z = this.box.getCenterZ();
        switch (this.doorSide) {
            case 0: {
                z = this.box.maxZ - 1;
                break;
            }
            case 2: {
                z = this.box.minZ + 1;
                break;
            }
            case 3: {
                x = this.box.maxX - 1;
                break;
            }
            case 1: {
                x = this.box.minX + 1;
            }
        }
        if (this.worldObj.getBlock(x, this.box.minY + 1, z) == Blocks.web) {
            this.worldObj.setBlockToAir(x, this.box.minY + 1, z);
        }
        if (this.worldObj.getBlock(x, this.box.minY + 2, z) == Blocks.web) {
            this.worldObj.setBlockToAir(x, this.box.minY + 2, z);
        }
        this.placeOpenDoor(this.worldObj.getBlock(x, this.box.minY + 1, z).getMaterial().isLiquid() ? 2 : 1);
        if (this.dungeonType.warpSong != null && (meta = BlockWarpStone.reverseLookup.get(this.dungeonType.warpSong)) != null) {
            this.worldObj.setBlock(x, this.box.minY, z, ZSSBlocks.warpStone, meta.intValue(), 2);
        }
    }

    private void placeOpenDoor(int dy) {
        int x = this.box.getCenterX();
        int z = this.box.getCenterZ();
        switch (this.doorSide) {
            case 0: {
                z = this.box.maxZ;
                break;
            }
            case 2: {
                z = this.box.minZ;
                break;
            }
            case 3: {
                x = this.box.maxX;
                break;
            }
            case 1: {
                x = this.box.minX;
            }
        }
        this.worldObj.setBlockToAir(x, this.box.minY + dy, z);
        this.worldObj.setBlockToAir(x, this.box.minY + dy + 1, z);
    }

    private boolean verifyDoor() {
        int x = this.box.getCenterX();
        int z = this.box.getCenterZ();
        switch (this.doorSide) {
            case 0: {
                z = this.box.maxZ;
                break;
            }
            case 2: {
                z = this.box.minZ;
                break;
            }
            case 3: {
                x = this.box.maxX;
                break;
            }
            case 1: {
                x = this.box.minX;
                break;
            }
            default: {
                ZSSMain.logger.warn(String.format("Verifying door in Dungeon Core with invalid door side at %d/%d/%d", this.xCoord, this.yCoord, this.zCoord));
            }
        }
        for (int y = this.box.minY; y < this.box.maxY; ++y) {
            if (this.worldObj.getBlock(x, y, z) != this.door) continue;
            return this.door instanceof IDungeonBlock ? ((IDungeonBlock)this.door).isSameVariant(this.worldObj, x, y, z, this.doorMeta) : true;
        }
        return false;
    }

    public void onBlockBroken() {
        if (!this.alreadyVerified) {
            this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)(this.yCoord + 1), (double)this.zCoord + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
            this.verifyStructure(true);
        }
        if (this.isSpawner()) {
            this.fairySpawner.onBlockBroken();
        }
    }

    protected boolean verifyStructure(boolean replace) {
        if (this.box != null && this.hasWorldObj()) {
            if (!replace && this.door != null) {
                return this.verifyDoor();
            }
            int invalid = 0;
            for (int i = this.box.minX; i <= this.box.maxX; ++i) {
                for (int j = this.box.minY; j <= this.box.maxY; ++j) {
                    for (int k = this.box.minZ; k <= this.box.maxZ; ++k) {
                        if (i != this.box.minX && i != this.box.maxX && j != this.box.minY && j != this.box.maxY && k != this.box.minZ && k != this.box.maxZ) continue;
                        Block block = this.worldObj.getBlock(i, j, k);
                        if (replace) {
                            if (block != ZSSBlocks.secretStone) continue;
                            int meta = this.worldObj.getBlockMetadata(i, j, k);
                            this.worldObj.setBlock(i, j, k, BlockSecretStone.getBlockFromMeta(meta), 0, 2);
                            continue;
                        }
                        if (block instanceof IDungeonBlock || ++invalid <= 2) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, tag);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readFromNBT(packet.func_148857_g());
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagCompound tag = new NBTTagCompound();
        tag.setBoolean("hasBB", this.box != null);
        if (this.box != null) {
            tag.setTag("boxBounds", (NBTBase)this.box.func_151535_h());
        }
        tag.setBoolean("verified", this.alreadyVerified);
        tag.setBoolean("isBossRoom", this.isBossRoom);
        if (this.isBossRoom) {
            tag.setString("dungeonName", this.dungeonType.getUnlocalizedName());
            tag.setBoolean("isOpened", this.isOpened);
            tag.setBoolean("hasBossBattle", this.bossBattle != null);
            if (this.bossBattle != null) {
                this.bossBattle.writeToNBT(tag);
            }
        }
        tag.setBoolean("hasDoor", this.door != null);
        if (this.door != null) {
            tag.setInteger("doorBlockId", Block.getIdFromBlock((Block)this.door));
            tag.setInteger("doorMeta", this.doorMeta);
            tag.setInteger("doorSide", this.doorSide);
        }
        if (this.isSpawner()) {
            this.fairySpawner.writeToNBT(tag);
        }
        compound.setTag("ZSSDungeonCore", (NBTBase)tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagCompound tag = compound.getCompoundTag("ZSSDungeonCore");
        if (tag.hasKey("boxBounds")) {
            this.box = new StructureBoundingBox(tag.getIntArray("boxBounds"));
        }
        this.alreadyVerified = tag.hasKey("verified") ? tag.getBoolean("verified") : false;
        boolean bl = this.isBossRoom = tag.hasKey("isBossRoom") ? tag.getBoolean("isBossRoom") : tag.getBoolean("isLocked");
        if (this.isBossRoom) {
            if (tag.hasKey("dungeonName")) {
                this.dungeonType = BossType.getBossType(tag.getString("dungeonName"));
            } else {
                ZSSMain.logger.warn(String.format("Detected old boss dungeon save format at %d/%d/%d - if you still see this message after saving and reloading near this location, please contact the mod author", this.xCoord, this.yCoord, this.zCoord));
                this.dungeonType = BossType.values()[tag.getInteger("dungeonType") % BossType.values().length];
            }
            this.isOpened = tag.getBoolean("isOpened");
            if (this.dungeonType == null) {
                ZSSMain.logger.error(String.format("Error retrieving Boss Type from string %s while loading Dungeon Core from NBT at %d/%d/%d", tag.getString("dungeonName"), this.xCoord, this.yCoord, this.zCoord));
            } else if (tag.getBoolean("hasBossBattle")) {
                this.bossBattle = this.dungeonType.getBossBattle(this);
                if (this.bossBattle != null) {
                    this.bossBattle.readFromNBT(tag);
                } else {
                    ZSSMain.logger.warn(String.format("Error retrieving Boss Battle while loading Dungeon Core from NBT at %d/%d/%d - returned NULL", this.xCoord, this.yCoord, this.zCoord));
                }
            }
        }
        if (tag.getBoolean("hasDoor")) {
            int id = tag.getInteger("doorBlockId");
            this.door = id > 0 ? Block.getBlockById((int)id) : null;
            this.doorMeta = tag.getInteger("doorMeta");
            this.doorSide = tag.getInteger("doorSide");
        }
        if (tag.getBoolean("isSpawner")) {
            ZSSMain.logger.warn(String.format("Detected old fairy spawner save format at %d/%d/%d - if you still see this message after saving and reloading near this location, please contact the mod author", this.xCoord, this.yCoord, this.zCoord));
            NBTTagCompound spawnerData = new NBTTagCompound();
            spawnerData.setInteger("maxFairies", tag.getInteger("maxFairies"));
            spawnerData.setInteger("spawned", tag.getInteger("spawned"));
            spawnerData.setInteger("nextResetDate", tag.getInteger("nextResetDate"));
            spawnerData.setInteger("itemUpdate", tag.getInteger("itemUpdate"));
            spawnerData.setInteger("rupees", tag.getInteger("rupees"));
            spawnerData.setString("playerName", tag.getString("playerName"));
            tag.setTag("FairySpawner", (NBTBase)spawnerData);
        }
        if (tag.hasKey("FairySpawner")) {
            this.fairySpawner = new FairySpawner(this);
            this.fairySpawner.readFromNBT(tag);
        }
    }
}

