/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block.tileentity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import zeldaswordskills.entity.EntityFairy;
import zeldaswordskills.ref.Config;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.songs.ZeldaSongs;

public class TileEntityGossipStone
extends TileEntity {
    public static final int LINE_LENGTH = 64;
    public static final int MAX_MESSAGE_LENGTH = 192;
    private String message = "";
    private long nextFairySpawn;

    public boolean canUpdate() {
        return false;
    }

    public String getMessage() {
        return this.message == null || this.message.equals("") ? "chat.zss.block.gossip_stone.default" : this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this.markDirty();
    }

    public boolean onSongPlayed(EntityPlayer player, AbstractZeldaSong song, int power, int affected) {
        if (this.worldObj.isDaytime() || this.nextFairySpawn > this.worldObj.getTotalWorldTime() || power < 5) {
            return false;
        }
        if (song == ZeldaSongs.songStorms || song == ZeldaSongs.songSun || song == ZeldaSongs.songZeldasLullaby) {
            EntityFairy fairy = new EntityFairy(this.worldObj);
            fairy.setFairyHome(this.xCoord, this.yCoord + 2, this.zCoord);
            this.worldObj.spawnEntityInWorld((Entity)fairy);
            this.nextFairySpawn = this.worldObj.getTotalWorldTime() + (long)(24000 * (this.worldObj.rand.nextInt(Config.getDaysToRespawn()) + 1));
            this.markDirty();
            return true;
        }
        return false;
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.message = compound.getString("message");
        this.nextFairySpawn = compound.getLong("nextFairySpawn");
    }

    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setString("message", this.message == null ? "" : this.message);
        compound.setLong("nextFairySpawn", this.nextFairySpawn);
    }
}

