/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block.tileentity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import zeldaswordskills.ref.Config;

public class TileEntitySacredFlame
extends TileEntity {
    private long nextResetDate = 0L;

    public void extinguish() {
        this.nextResetDate = this.worldObj.getTotalWorldTime() + (long)(24000 * Config.getSacredFlameRefreshRate());
    }

    public void updateEntity() {
        if (this.nextResetDate > 0L && this.worldObj.getTotalWorldTime() > this.nextResetDate) {
            this.nextResetDate = 0L;
            int meta = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
            this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, meta & 0xFFFFFFF7, 3);
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setLong("nextResetDate", this.nextResetDate);
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.nextResetDate = compound.hasKey("nextResetDate") && compound.getTag("nextResetDate").getId() == 4 ? compound.getLong("nextResetDate") : 0L;
    }
}

