/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;
import zeldaswordskills.api.item.ISwingSpeed;
import zeldaswordskills.api.item.IZoom;
import zeldaswordskills.api.item.IZoomHelper;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.client.gui.ComboOverlay;
import zeldaswordskills.client.gui.GuiBuffBar;
import zeldaswordskills.client.gui.GuiItemModeOverlay;
import zeldaswordskills.client.gui.GuiMagicMeter;
import zeldaswordskills.client.gui.IGuiOverlay;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.handler.ZSSCombatEvents;
import zeldaswordskills.item.ItemHeldBlock;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.ICombo;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.TargetUtils;

@SideOnly(value=Side.CLIENT)
public class ZSSClientEvents {
    private final Minecraft mc;
    private final List<IGuiOverlay> overlays = new ArrayList<IGuiOverlay>();
    private boolean needsPop;
    private int mouseKey;
    private boolean isAttackKey;
    private boolean isUseKey;

    public ZSSClientEvents() {
        this.mc = Minecraft.getMinecraft();
        this.overlays.add(new ComboOverlay(this.mc));
        this.overlays.add(new GuiBuffBar(this.mc));
        this.overlays.add(new GuiItemModeOverlay(this.mc));
        this.overlays.add(new GuiMagicMeter(this.mc));
    }

    @SubscribeEvent
    public void onRenderExperienceBar(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        for (IGuiOverlay overlay : this.overlays) {
            if (!overlay.shouldRender()) continue;
            overlay.renderOverlay(event.resolution);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void performComboAttack(Minecraft mc, ILockOnTarget skill) {
        if (!mc.thePlayer.isUsingItem()) {
            mc.thePlayer.swingItem();
            ZSSCombatEvents.setPlayerAttackTime((EntityPlayer)mc.thePlayer);
            if (skill instanceof ICombo && ((ICombo)((Object)skill)).onAttack((EntityPlayer)mc.thePlayer)) {
                Entity entity = TargetUtils.getMouseOverEntity();
                mc.playerController.attackEntity((EntityPlayer)mc.thePlayer, entity != null ? entity : skill.getCurrentTarget());
            }
        }
    }

    @SubscribeEvent
    public void updateFOV(FOVUpdateEvent event) {
        boolean flag;
        ItemStack stack;
        ItemStack itemStack = stack = event.entity.isUsingItem() ? event.entity.getItemInUse() : null;
        if (stack != null && ((flag = stack.getItem() instanceof IZoom) || stack.getItem() == Items.bow)) {
            float magify = 1.0f;
            for (ItemStack armor : event.entity.inventory.armorInventory) {
                if (armor == null || !(armor.getItem() instanceof IZoomHelper)) continue;
                magify += ((IZoomHelper)armor.getItem()).getMagnificationFactor();
            }
            if (flag || magify != 1.0f) {
                float maxTime = flag ? ((IZoom)stack.getItem()).getMaxZoomTime() : 20.0f;
                float factor = flag ? ((IZoom)stack.getItem()).getZoomFactor() : 0.15f;
                float charge = (float)event.entity.getItemInUseDuration() / maxTime;
                IAttributeInstance iattributeinstance = event.entity.getEntityAttribute(SharedMonsterAttributes.movementSpeed);
                float fov = event.entity.capabilities.isFlying ? 1.1f : 1.0f;
                fov = (float)((double)fov * ((iattributeinstance.getAttributeValue() / (double)event.entity.capabilities.getWalkSpeed() + 1.0) / 2.0));
                if (event.entity.capabilities.getWalkSpeed() == 0.0f || Float.isNaN(fov) || Float.isInfinite(fov)) {
                    fov = 1.0f;
                }
                charge = charge > 1.0f ? 1.0f : (charge *= charge);
                event.newfov = fov * (1.0f - charge * factor * magify);
            }
        }
    }

    @SubscribeEvent
    public void onMouseChanged(MouseEvent event) {
        this.mouseKey = event.button - 100;
        this.isAttackKey = this.mouseKey == this.mc.gameSettings.keyBindAttack.getKeyCode();
        boolean bl = this.isUseKey = this.mouseKey == this.mc.gameSettings.keyBindUseItem.getKeyCode();
        if (event.dwheel == 0) {
            if (event.button == -1) {
                return;
            }
            if (!this.isAttackKey && !this.isUseKey) {
                if (event.buttonstate) {
                    ZSSKeyHandler.onKeyPressed(this.mc, this.mouseKey);
                }
                return;
            }
        }
        ZSSPlayerSkills skills = ZSSPlayerSkills.get((EntityPlayer)this.mc.thePlayer);
        if (event.buttonstate || event.dwheel != 0) {
            if (this.isAttackKey) {
                if (skills.isSkillActive(SkillBase.spinAttack) && skills.getActiveSkill(SkillBase.spinAttack).isAnimating()) {
                    skills.getActiveSkill(SkillBase.spinAttack).keyPressed(this.mc, this.mc.gameSettings.keyBindAttack, (EntityPlayer)this.mc.thePlayer);
                    event.setCanceled(true);
                } else if (skills.isSkillActive(SkillBase.backSlice) && skills.getActiveSkill(SkillBase.backSlice).isAnimating()) {
                    skills.getActiveSkill(SkillBase.backSlice).keyPressed(this.mc, this.mc.gameSettings.keyBindAttack, (EntityPlayer)this.mc.thePlayer);
                    event.setCanceled(true);
                } else if (!skills.canInteract() || ZSSEntityInfo.get((EntityLivingBase)this.mc.thePlayer).isBuffActive(Buff.STUN)) {
                    event.setCanceled(true);
                } else {
                    Item heldItem = this.mc.thePlayer.getHeldItem() != null ? this.mc.thePlayer.getHeldItem().getItem() : null;
                    event.setCanceled(heldItem instanceof ItemHeldBlock || this.mc.thePlayer.attackTime > 0 && (Config.affectAllSwings() || heldItem instanceof ISwingSpeed));
                }
            } else if (this.isUseKey) {
                event.setCanceled(!skills.canInteract() || ZSSEntityInfo.get((EntityLivingBase)this.mc.thePlayer).isBuffActive(Buff.STUN));
            } else {
                event.setCanceled(!skills.canInteract());
            }
        }
        if (event.isCanceled() || !event.buttonstate) {
            return;
        }
        ILockOnTarget skill = skills.getTargetingSkill();
        if (skill != null && skill.isLockedOn()) {
            if (this.isAttackKey) {
                if (Config.allowVanillaControls) {
                    if (!skills.onKeyPressed(this.mc, this.mc.gameSettings.keyBindAttack)) {
                        ZSSClientEvents.performComboAttack(this.mc, skill);
                    }
                    if (skills.hasSkill(SkillBase.armorBreak)) {
                        skills.getActiveSkill(SkillBase.armorBreak).keyPressed(this.mc, this.mc.gameSettings.keyBindAttack, (EntityPlayer)this.mc.thePlayer);
                    }
                }
                event.setCanceled(true);
            } else if (this.isUseKey && Config.allowVanillaControls && !skills.canInteract()) {
                event.setCanceled(true);
            }
        } else if (this.isAttackKey) {
            ZSSCombatEvents.setPlayerAttackTime((EntityPlayer)this.mc.thePlayer);
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        ItemStack mask = event.entityPlayer.getCurrentArmor(3);
        if (mask != null && mask.getItem() == ZSSItems.maskGiants) {
            GL11.glPushMatrix();
            this.needsPop = true;
            if (event.entityPlayer == this.mc.thePlayer) {
                if (this.mc.inGameHasFocus) {
                    GL11.glTranslatef((float)0.0f, (float)-6.325f, (float)0.0f);
                    GL11.glScalef((float)3.0f, (float)3.0f, (float)3.0f);
                }
            } else {
                GL11.glScalef((float)3.0f, (float)3.0f, (float)3.0f);
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Post event) {
        if (this.needsPop) {
            GL11.glPopMatrix();
            this.needsPop = false;
        }
    }
}

