/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;
import zeldaswordskills.api.item.ISwingSpeed;
import zeldaswordskills.client.ZSSClientEvents;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.item.ICyclableItem;
import zeldaswordskills.item.ItemHeldBlock;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.ActivateSkillPacket;
import zeldaswordskills.network.server.CycleItemModePacket;
import zeldaswordskills.network.server.GetBombPacket;
import zeldaswordskills.network.server.OpenGuiPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.PlayerUtils;

@SideOnly(value=Side.CLIENT)
public class ZSSKeyHandler {
    private final Minecraft mc = Minecraft.getMinecraft();
    public static final byte KEY_SKILL_ACTIVATE = 0;
    public static final byte KEY_NEXT_TARGET = 1;
    public static final byte KEY_ATTACK = 2;
    public static final byte KEY_LEFT = 3;
    public static final byte KEY_RIGHT = 4;
    public static final byte KEY_DOWN = 5;
    public static final byte KEY_BLOCK = 6;
    public static final byte KEY_BOMB = 7;
    public static final byte KEY_TOGGLE_AUTOTARGET = 8;
    public static final byte KEY_TOGGLE_BUFFBAR = 9;
    public static final byte KEY_SKILLS_GUI = 10;
    public static final byte KEY_PREV_MODE = 11;
    public static final byte KEY_NEXT_MODE = 12;
    public static final String[] desc = new String[]{"activate", "next", "attack", "left", "right", "down", "block", "bomb", "toggleat", "togglebuff", "skills_gui", "prev_mode", "next_mode"};
    private static final int[] keyValues = new int[]{45, 15, 200, 203, 205, 208, 157, 48, 52, 47, 25, 26, 27};
    public static final KeyBinding[] keys = new KeyBinding[desc.length];

    public ZSSKeyHandler() {
        for (int i = 0; i < desc.length; ++i) {
            ZSSKeyHandler.keys[i] = new KeyBinding("key.zss." + desc[i] + ".desc", keyValues[i], StatCollector.translateToLocal((String)"key.zss.label"));
            ClientRegistry.registerKeyBinding((KeyBinding)keys[i]);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (Keyboard.getEventKeyState()) {
            ZSSKeyHandler.onKeyPressed(this.mc, Keyboard.getEventKey());
        }
    }

    public static void onKeyPressed(Minecraft mc, int kb) {
        if (mc.inGameHasFocus && mc.thePlayer != null) {
            ZSSPlayerSkills skills = ZSSPlayerSkills.get((EntityPlayer)mc.thePlayer);
            if (kb == mc.gameSettings.keyBindSprint.getKeyCode()) {
                int z;
                int y;
                int x = MathHelper.floor_double((double)mc.thePlayer.posX);
                if (!mc.theWorld.getBlock(x, (y = MathHelper.floor_double((double)(mc.thePlayer.posY - (double)mc.thePlayer.yOffset))) - 1, z = MathHelper.floor_double((double)mc.thePlayer.posZ)).isSideSolid((IBlockAccess)mc.theWorld, x, y - 1, z, ForgeDirection.UP)) {
                    KeyBinding.setKeyBindState((int)kb, (boolean)false);
                }
            } else if (kb == keys[0].getKeyCode()) {
                if (skills.hasSkill(SkillBase.swordBasic)) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(SkillBase.swordBasic));
                }
            } else if (kb == keys[7].getKeyCode()) {
                if (mc.gameSettings.keyBindUseItem.getIsKeyPressed()) {
                    KeyBinding.setKeyBindState((int)mc.gameSettings.keyBindUseItem.getKeyCode(), (boolean)false);
                }
                PacketDispatcher.sendToServer(new GetBombPacket());
            } else if (kb == keys[8].getKeyCode()) {
                if (mc.thePlayer.isSneaking()) {
                    PlayerUtils.sendTranslatedChat((EntityPlayer)mc.thePlayer, "chat.zss.key.toggletp", Config.toggleTargetPlayers() ? new ChatComponentTranslation("chat.zss.key.enable", new Object[0]) : new ChatComponentTranslation("chat.zss.key.disable", new Object[0]));
                } else {
                    PlayerUtils.sendTranslatedChat((EntityPlayer)mc.thePlayer, "chat.zss.key.toggleat", Config.toggleAutoTarget() ? new ChatComponentTranslation("chat.zss.key.enable", new Object[0]) : new ChatComponentTranslation("chat.zss.key.disable", new Object[0]));
                }
            } else if (kb == keys[9].getKeyCode()) {
                if (mc.thePlayer.isSneaking()) {
                    Config.isComboHudEnabled = !Config.isComboHudEnabled;
                    PlayerUtils.sendTranslatedChat((EntityPlayer)mc.thePlayer, "chat.zss.key.togglehud", Config.isComboHudEnabled ? new ChatComponentTranslation("chat.zss.key.enable", new Object[0]) : new ChatComponentTranslation("chat.zss.key.disable", new Object[0]));
                } else {
                    Config.isBuffBarEnabled = !Config.isBuffBarEnabled;
                }
            } else if (kb == keys[10].getKeyCode()) {
                PacketDispatcher.sendToServer(new OpenGuiPacket(2));
            } else if (kb == keys[11].getKeyCode() || kb == keys[12].getKeyCode()) {
                boolean next = kb == keys[12].getKeyCode();
                ItemStack stack = mc.thePlayer.getHeldItem();
                if (stack != null && stack.getItem() instanceof ICyclableItem) {
                    if (next) {
                        ((ICyclableItem)stack.getItem()).nextItemMode(stack, (EntityPlayer)mc.thePlayer);
                    } else {
                        ((ICyclableItem)stack.getItem()).prevItemMode(stack, (EntityPlayer)mc.thePlayer);
                    }
                    PacketDispatcher.sendToServer(new CycleItemModePacket(next));
                }
            } else {
                ZSSKeyHandler.handleTargetingKeys(mc, kb, skills);
            }
        }
    }

    private static void handleTargetingKeys(Minecraft mc, int kb, ZSSPlayerSkills skills) {
        KeyBinding key;
        boolean canInteract;
        ILockOnTarget skill = skills.getTargetingSkill();
        boolean bl = canInteract = skills.canInteract() && !ZSSEntityInfo.get((EntityLivingBase)mc.thePlayer).isBuffActive(Buff.STUN);
        if (skill == null || !skill.isLockedOn()) {
            return;
        }
        if (kb == keys[1].getKeyCode()) {
            skill.getNextTarget((EntityPlayer)mc.thePlayer);
        } else if (kb == keys[2].getKeyCode() || kb == mc.gameSettings.keyBindAttack.getKeyCode()) {
            boolean flag;
            KeyBinding key2 = kb == keys[2].getKeyCode() ? keys[2] : mc.gameSettings.keyBindAttack;
            Item heldItem = mc.thePlayer.getHeldItem() != null ? mc.thePlayer.getHeldItem().getItem() : null;
            boolean bl2 = flag = heldItem instanceof ItemHeldBlock || mc.thePlayer.attackTime > 0 && (Config.affectAllSwings() || heldItem instanceof ISwingSpeed);
            if (canInteract && !flag) {
                KeyBinding.setKeyBindState((int)key2.getKeyCode(), (boolean)true);
            } else if (!flag) {
                if (skills.isSkillActive(SkillBase.spinAttack)) {
                    skills.getActiveSkill(SkillBase.spinAttack).keyPressed(mc, key2, (EntityPlayer)mc.thePlayer);
                    return;
                }
                if (skills.isSkillActive(SkillBase.backSlice)) {
                    skills.getActiveSkill(SkillBase.backSlice).keyPressed(mc, key2, (EntityPlayer)mc.thePlayer);
                    return;
                }
            }
            if (key2.getIsKeyPressed()) {
                if (!skills.onKeyPressed(mc, key2)) {
                    ZSSClientEvents.performComboAttack(mc, skill);
                }
                if (skills.hasSkill(SkillBase.armorBreak)) {
                    skills.getActiveSkill(SkillBase.armorBreak).keyPressed(mc, key2, (EntityPlayer)mc.thePlayer);
                }
            }
        } else if (canInteract && (key = ZSSKeyHandler.getKeyBindFromCode(mc, kb)) != null) {
            KeyBinding.setKeyBindState((int)kb, (boolean)true);
            skills.onKeyPressed(mc, key);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static KeyBinding getKeyBindFromCode(Minecraft mc, int keyCode) {
        for (KeyBinding k : keys) {
            if (k.getKeyCode() != keyCode) continue;
            return k;
        }
        if (keyCode == mc.gameSettings.keyBindForward.getKeyCode()) {
            return mc.gameSettings.keyBindForward;
        }
        if (keyCode == mc.gameSettings.keyBindJump.getKeyCode()) {
            return mc.gameSettings.keyBindJump;
        }
        if (Config.allowVanillaControls) {
            if (keyCode == mc.gameSettings.keyBindLeft.getKeyCode()) {
                return mc.gameSettings.keyBindLeft;
            }
            if (keyCode == mc.gameSettings.keyBindRight.getKeyCode()) {
                return mc.gameSettings.keyBindRight;
            }
            if (keyCode == mc.gameSettings.keyBindBack.getKeyCode()) {
                return mc.gameSettings.keyBindBack;
            }
        }
        return null;
    }
}

