/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import zeldaswordskills.client.RenderHelperQ;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.ref.Config;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.util.SongNote;

@SideOnly(value=Side.CLIENT)
public abstract class GuiMusicBase
extends GuiScreen {
    protected final Minecraft mc;
    protected static final int MAX_NOTES = 8;
    protected static final int NOTE_SIZE = 12;
    protected static final int INT_Y = 5;
    protected int xSize = 213;
    protected int ySize = 90;
    protected int fullX = 256;
    protected int fullY = 128;
    protected int guiLeft;
    protected int guiTop;
    protected AbstractZeldaSong song;
    protected final List<SongNote> melody = new ArrayList<SongNote>();
    protected int ticksSinceLastNote;
    protected final int x;
    protected final int y;
    protected final int z;

    public GuiMusicBase(int x, int y, int z) {
        this.mc = Minecraft.getMinecraft();
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void initGui() {
        super.initGui();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2 + 25;
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    protected abstract ResourceLocation getTexture();

    public void drawScreen(int mouseX, int mouseY, float f) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(this.getTexture());
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        RenderHelperQ.drawTexturedRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize, this.fullX, this.fullY);
        GL11.glPopAttrib();
        int i1 = this.melody.size() > 8 ? (this.melody.size() - 1) / 8 * 8 : 0;
        int i = 0;
        while (i + i1 < this.melody.size()) {
            SongNote note = this.melody.get(i + i1);
            int j = SongNote.Note.values().length - (note.note.ordinal() + 1) + SongNote.Note.values().length * (2 - note.getOctave());
            int dy = 6 + 5 * j;
            int dx = 46 + 20 * i;
            if (j > 10) {
                int dy2 = 65;
                for (int n = 0; n < (j - 9) / 2; ++n) {
                    RenderHelperQ.drawTexturedRect(this.guiLeft + (dx - 2), this.guiTop + dy2 + n * 2 * 5, 8, 15, 16, 5, this.fullX, this.fullY);
                }
            }
            RenderHelperQ.drawTexturedRect(this.guiLeft + dx, this.guiTop + dy, this.xSize, SongNote.PlayableNote.getOrdinalFromNote(note) * 12, 12, 12, this.fullX, this.fullY);
            if (note.isSharp() || note.isFlat()) {
                RenderHelperQ.drawTexturedRect(this.guiLeft + dx + 12 - 2, this.guiTop + dy, this.xSize + 12, note.isSharp() ? 0 : 5, 5, 5, this.fullX, this.fullY);
            }
            ++i;
        }
        if (this.song != null) {
            String s = this.song.getDisplayName();
            this.fontRendererObj.drawString(s, this.guiLeft + this.xSize / 2 - this.fontRendererObj.getStringWidth(s) / 2, this.guiTop + 3, 0xFFFFFF);
        }
        super.drawScreen(mouseX, mouseY, f);
    }

    public void updateScreen() {
        ++this.ticksSinceLastNote;
        if (this.song != null) {
            if (this.ticksSinceLastNote > this.song.getMinDuration()) {
                this.mc.thePlayer.closeScreen();
            }
        } else if (this.ticksSinceLastNote > Config.getNoteResetInterval()) {
            this.ticksSinceLastNote = 0;
            this.melody.clear();
        }
    }

    protected boolean allowKeyInput() {
        return this.song == null;
    }

    protected void keyTyped(char c, int key) {
        if (!this.allowKeyInput()) {
            super.keyTyped(c, key);
            return;
        }
        SongNote.PlayableNote playedNote = null;
        if (key == ZSSKeyHandler.keys[2].getKeyCode()) {
            playedNote = SongNote.PlayableNote.D2;
        } else if (key == ZSSKeyHandler.keys[5].getKeyCode()) {
            playedNote = SongNote.PlayableNote.F1;
        } else if (key == ZSSKeyHandler.keys[3].getKeyCode()) {
            playedNote = SongNote.PlayableNote.B2;
        } else if (key == ZSSKeyHandler.keys[4].getKeyCode()) {
            playedNote = SongNote.PlayableNote.A2;
        } else if (key == this.mc.gameSettings.keyBindJump.getKeyCode()) {
            playedNote = SongNote.PlayableNote.D1;
        }
        if (playedNote == null) {
            super.keyTyped(c, key);
        } else {
            int modifier = 0;
            if (Keyboard.isKeyDown((int)this.mc.gameSettings.keyBindRight.getKeyCode())) {
                ++modifier;
            } else if (Keyboard.isKeyDown((int)this.mc.gameSettings.keyBindLeft.getKeyCode())) {
                --modifier;
            }
            if (Keyboard.isKeyDown((int)this.mc.gameSettings.keyBindForward.getKeyCode())) {
                modifier += 2;
            } else if (Keyboard.isKeyDown((int)this.mc.gameSettings.keyBindBack.getKeyCode())) {
                modifier -= 2;
            }
            SongNote note = SongNote.getNote(playedNote, modifier);
            if (note != null) {
                this.onNotePlayed(note);
                this.onNoteAdded();
            }
        }
    }

    protected abstract void onNoteAdded();

    protected void onNotePlayed(SongNote note) {
        this.melody.add(note);
        this.ticksSinceLastNote = 0;
        float f = (float)Math.pow(2.0, (double)(note.ordinal() - 12) / 12.0);
        this.mc.thePlayer.playSound("zeldaswordskills:note.ocarina", 3.0f, f);
        Vec3 look = this.mc.thePlayer.getLookVec();
        this.mc.theWorld.spawnParticle("note", this.mc.thePlayer.posX + look.xCoord + this.mc.theWorld.rand.nextDouble() - 0.5, this.mc.thePlayer.posY + look.yCoord + (double)this.mc.thePlayer.getEyeHeight() + this.mc.theWorld.rand.nextDouble() - 0.5, this.mc.thePlayer.posZ + look.zCoord + this.mc.theWorld.rand.nextDouble() - 0.5, (double)note.ordinal() / 24.0, 0.0, 0.0);
    }
}

