/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import zeldaswordskills.client.model.IModelBiped;
import zeldaswordskills.entity.mobs.EntityDarknut;

@SideOnly(value=Side.CLIENT)
public class ModelDarknut
extends ModelBase
implements IModelBiped {
    private ModelRenderer head;
    private ModelRenderer body;
    private ModelRenderer leftArm;
    private ModelRenderer rightArm;
    private ModelRenderer rightLeg;
    private ModelRenderer leftLeg;
    private ModelRenderer shoulderPlateRight;
    private ModelRenderer shoulderPlateLeft;
    private ModelRenderer upperArmor;
    private ModelRenderer lowerArmor;
    private ModelRenderer helmRightPlate;
    private ModelRenderer helmTopPlate;
    private ModelRenderer helmBackPlate;
    private ModelRenderer helmLeftPlate;
    private ModelRenderer cheekGuardLeft;
    private ModelRenderer noseGuard;
    private ModelRenderer cheekGuardRight;
    private ModelRenderer helmVisor;
    private ModelRenderer hornHolderLeft;
    private ModelRenderer hornLeft;
    private ModelRenderer hornRight;
    private ModelRenderer hornHolderRight;
    private ModelRenderer cape;
    private int heldItemLeft;
    private int heldItemRight;
    private static final float[] attackRotZ = new float[]{0.2f, 0.45f, 0.75f, 1.0f, 0.75f, 0.45f, 0.2f, 0.0f, -0.2f};
    private static final float[] powRotXR = new float[]{-2.5f, -1.5f, -1.0f, -0.5f, -0.4f};
    private static final float[] powRotYR = new float[]{0.0f, -0.1f, -0.2f, -0.2f, -0.2f};
    private static final float[] powRotZR = new float[]{0.0f, 0.0f, 0.0f, -0.25f, -0.5f};
    private static final float[] powRotXL = new float[]{-2.0f, -1.4f, -1.0f, -0.6f, -0.4f};
    private static final float[] powRotYL = new float[]{1.0f, 0.9f, 0.8f, 0.5f, 0.2f};
    private static final float[] powRotZL = new float[]{0.0f, 0.15f, 0.3f, 0.45f, 0.5f};

    public ModelDarknut() {
        this.textureWidth = 64;
        this.textureHeight = 64;
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.setTextureSize(this.textureWidth, this.textureHeight);
        this.head.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8);
        this.head.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.setRotation(this.head, 0.0f, 0.0f, 0.0f);
        this.body = new ModelRenderer((ModelBase)this, 16, 16);
        this.body.setTextureSize(this.textureWidth, this.textureHeight);
        this.body.addBox(-4.0f, 0.0f, -2.0f, 8, 12, 4);
        this.body.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.setRotation(this.body, 0.0f, 0.0f, 0.0f);
        this.rightArm = new ModelRenderer((ModelBase)this, 40, 16);
        this.rightArm.setTextureSize(this.textureWidth, this.textureHeight);
        this.rightArm.addBox(-3.0f, -2.0f, -2.0f, 4, 12, 4);
        this.rightArm.setRotationPoint(-5.0f, 2.0f, 0.0f);
        this.setRotation(this.rightArm, 0.0f, 0.0f, 0.0f);
        this.leftArm = new ModelRenderer((ModelBase)this, 40, 16);
        this.leftArm.mirror = true;
        this.leftArm.setTextureSize(this.textureWidth, this.textureHeight);
        this.leftArm.addBox(-1.0f, -2.0f, -2.0f, 4, 12, 4);
        this.leftArm.setRotationPoint(5.0f, 2.0f, 0.0f);
        this.setRotation(this.leftArm, 0.0f, 0.0f, 0.0f);
        this.rightLeg = new ModelRenderer((ModelBase)this, 0, 16);
        this.rightLeg.mirror = true;
        this.rightLeg.setTextureSize(this.textureWidth, this.textureHeight);
        this.rightLeg.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.rightLeg.setRotationPoint(-2.0f, 12.0f, 0.0f);
        this.setRotation(this.rightLeg, 0.0f, 0.0f, 0.0f);
        this.leftLeg = new ModelRenderer((ModelBase)this, 0, 16);
        this.leftLeg.setTextureSize(this.textureWidth, this.textureHeight);
        this.leftLeg.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.leftLeg.setRotationPoint(2.0f, 12.0f, 0.0f);
        this.setRotation(this.leftLeg, 0.0f, 0.0f, 0.0f);
        this.shoulderPlateRight = new ModelRenderer((ModelBase)this, 0, 58);
        this.shoulderPlateRight.setTextureSize(this.textureWidth, this.textureHeight);
        this.shoulderPlateRight.addBox(-5.0f, -2.5f, -2.5f, 6, 1, 5);
        this.shoulderPlateRight.setRotationPoint(-5.0f, 2.0f, 0.0f);
        this.setRotation(this.shoulderPlateRight, 0.0f, 0.0f, 0.0f);
        this.shoulderPlateLeft = new ModelRenderer((ModelBase)this, 0, 58);
        this.shoulderPlateLeft.mirror = true;
        this.shoulderPlateLeft.setTextureSize(this.textureWidth, this.textureHeight);
        this.shoulderPlateLeft.addBox(-1.0f, -2.5f, -2.5f, 6, 1, 5);
        this.shoulderPlateLeft.setRotationPoint(5.0f, 2.0f, 0.0f);
        this.setRotation(this.shoulderPlateLeft, 0.0f, 0.0f, 0.0f);
        this.upperArmor = new ModelRenderer((ModelBase)this, 0, 32);
        this.upperArmor.setTextureSize(this.textureWidth, this.textureHeight);
        this.upperArmor.addBox(-5.0f, -3.2f, -3.0f, 10, 7, 6);
        this.upperArmor.setRotationPoint(0.0f, 3.0f, 0.0f);
        this.setRotation(this.upperArmor, 0.0f, 0.0f, 0.0f);
        this.lowerArmor = new ModelRenderer((ModelBase)this, 0, 46);
        this.lowerArmor.setTextureSize(this.textureWidth, this.textureHeight);
        this.lowerArmor.addBox(-4.5f, -3.2f, -2.5f, 9, 6, 5);
        this.lowerArmor.setRotationPoint(0.0f, 10.0f, 0.0f);
        this.setRotation(this.lowerArmor, 0.0f, 0.0f, 0.0f);
        this.helmBackPlate = new ModelRenderer((ModelBase)this, 0, 55);
        this.helmBackPlate.setTextureSize(this.textureWidth, this.textureHeight);
        this.helmBackPlate.addBox(-4.5f, -7.6f, 3.5f, 9, 8, 1);
        this.helmBackPlate.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.setRotation(this.helmBackPlate, 0.0f, 0.0f, 0.0f);
        this.helmTopPlate = new ModelRenderer((ModelBase)this, 0, 54);
        this.helmTopPlate.setTextureSize(this.textureWidth, this.textureHeight);
        this.helmTopPlate.addBox(-4.5f, -7.6f, -4.5f, 9, 1, 9);
        this.helmTopPlate.setRotationPoint(0.0f, -1.0f, 0.0f);
        this.setRotation(this.helmTopPlate, 0.0f, 0.0f, 0.0f);
        this.helmBackPlate.addChild(this.helmTopPlate);
        this.helmRightPlate = new ModelRenderer((ModelBase)this, 0, 48);
        this.helmRightPlate.setTextureSize(this.textureWidth, this.textureHeight);
        this.helmRightPlate.addBox(-3.5f, -7.6f, -4.5f, 1, 8, 8);
        this.helmRightPlate.setRotationPoint(-1.0f, 0.0f, 0.0f);
        this.setRotation(this.helmRightPlate, 0.0f, 0.0f, 0.0f);
        this.helmBackPlate.addChild(this.helmRightPlate);
        this.helmLeftPlate = new ModelRenderer((ModelBase)this, 0, 48);
        this.helmLeftPlate.mirror = true;
        this.helmLeftPlate.setTextureSize(this.textureWidth, this.textureHeight);
        this.helmLeftPlate.addBox(2.5f, -7.6f, -4.5f, 1, 8, 8);
        this.helmLeftPlate.setRotationPoint(1.0f, 0.0f, 0.0f);
        this.setRotation(this.helmLeftPlate, 0.0f, 0.0f, 0.0f);
        this.helmBackPlate.addChild(this.helmLeftPlate);
        this.helmVisor = new ModelRenderer((ModelBase)this, 1, 62);
        this.helmVisor.setTextureSize(this.textureWidth, this.textureHeight);
        this.helmVisor.addBox(-3.5f, -6.6f, -4.5f, 7, 1, 1);
        this.helmVisor.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.setRotation(this.helmVisor, 0.0f, 0.0f, 0.0f);
        this.helmTopPlate.addChild(this.helmVisor);
        this.noseGuard = new ModelRenderer((ModelBase)this, 46, 11);
        this.noseGuard.setTextureSize(this.textureWidth, this.textureHeight);
        this.noseGuard.addBox(-1.0f, -5.6f, -4.5f, 2, 4, 1);
        this.noseGuard.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.setRotation(this.noseGuard, 0.0f, 0.0f, 0.0f);
        this.helmVisor.addChild(this.noseGuard);
        this.cheekGuardRight = new ModelRenderer((ModelBase)this, 32, 10);
        this.cheekGuardRight.setTextureSize(this.textureWidth, this.textureHeight);
        this.cheekGuardRight.addBox(-2.5f, -4.5f, -4.5f, 2, 5, 1);
        this.cheekGuardRight.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.setRotation(this.cheekGuardRight, 0.0f, 0.0f, 0.0f);
        this.helmRightPlate.addChild(this.cheekGuardRight);
        this.cheekGuardLeft = new ModelRenderer((ModelBase)this, 32, 10);
        this.cheekGuardLeft.mirror = true;
        this.cheekGuardLeft.setTextureSize(this.textureWidth, this.textureHeight);
        this.cheekGuardLeft.addBox(0.5f, -4.5f, -4.5f, 2, 5, 1);
        this.cheekGuardLeft.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.setRotation(this.cheekGuardLeft, 0.0f, 0.0f, 0.0f);
        this.helmLeftPlate.addChild(this.cheekGuardLeft);
        this.hornHolderRight = new ModelRenderer((ModelBase)this, 53, 0);
        this.hornHolderRight.setTextureSize(this.textureWidth, this.textureHeight);
        this.hornHolderRight.addBox(-5.0f, -6.0f, -1.5f, 2, 3, 3);
        this.hornHolderRight.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.setRotation(this.hornHolderRight, 0.0f, 0.0f, 0.0f);
        this.helmRightPlate.addChild(this.hornHolderRight);
        this.hornHolderLeft = new ModelRenderer((ModelBase)this, 53, 0);
        this.hornHolderLeft.mirror = true;
        this.hornHolderLeft.setTextureSize(this.textureWidth, this.textureHeight);
        this.hornHolderLeft.addBox(3.0f, -6.0f, -1.5f, 2, 3, 3);
        this.hornHolderLeft.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.setRotation(this.hornHolderLeft, 0.0f, 0.0f, 0.0f);
        this.helmLeftPlate.addChild(this.hornHolderLeft);
        this.hornRight = new ModelRenderer((ModelBase)this, 38, 0);
        this.hornRight.setTextureSize(this.textureWidth, this.textureHeight);
        this.hornRight.addBox(-10.0f, -5.5f, -1.0f, 5, 2, 2);
        this.hornRight.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.hornRight.setRotationPoint(-1.5f, 1.75f, 0.0f);
        this.setRotation(this.hornRight, 0.0f, 0.0f, 0.3926991f);
        this.hornHolderRight.addChild(this.hornRight);
        this.hornLeft = new ModelRenderer((ModelBase)this, 38, 0);
        this.hornLeft.mirror = true;
        this.hornLeft.setTextureSize(this.textureWidth, this.textureHeight);
        this.hornLeft.addBox(5.0f, -5.5f, -1.0f, 5, 2, 2);
        this.hornLeft.setRotationPoint(1.5f, 1.75f, 0.0f);
        this.setRotation(this.hornLeft, 0.0f, 0.0f, -0.3926991f);
        this.hornHolderLeft.addChild(this.hornLeft);
        this.cape = new ModelRenderer((ModelBase)this, 32, 45);
        this.cape.addBox(-5.0f, 0.0f, 0.0f, 10, 16, 1);
        this.cape.setRotationPoint(0.0f, 0.0f, 3.0f);
        this.cape.setTextureSize(this.textureWidth, this.textureHeight);
    }

    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        super.render(entity, f, f1, f2, f3, f4, f5);
        this.setRotationAngles(f, f1, f2, f3, f4, f5, entity);
        this.head.render(f5);
        this.body.render(f5);
        this.leftArm.render(f5);
        this.rightArm.render(f5);
        this.rightLeg.render(f5);
        this.leftLeg.render(f5);
        this.renderArmor((EntityDarknut)entity, f, f1, f2, f3, f4, f5);
    }

    private void renderArmor(EntityDarknut entity, float f, float f1, float f2, float f3, float f4, float f5) {
        if (entity.isArmored()) {
            this.shoulderPlateRight.render(f5);
            this.shoulderPlateLeft.render(f5);
            this.upperArmor.render(f5);
            this.lowerArmor.render(f5);
            this.helmBackPlate.render(f5);
        }
        if (entity.isWearingCape()) {
            this.cape.render(f5);
        }
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }

    public void setLivingAnimations(EntityLivingBase entity, float par2, float par3, float partialTick) {
        this.setLivingAnimations((EntityDarknut)entity, par2, par3, partialTick);
    }

    private void setLivingAnimations(EntityDarknut entity, float par2, float par3, float partialTick) {
        int i = entity.attackTimer;
        int j = entity.chargeTimer;
        if (entity.isSpinning()) {
            this.rightArm.rotateAngleX = powRotXR[4];
            this.rightArm.rotateAngleY = powRotYR[4];
            this.rightArm.rotateAngleZ = powRotZR[4];
            this.leftArm.rotateAngleX = powRotXL[4];
            this.leftArm.rotateAngleY = powRotYL[4];
            this.leftArm.rotateAngleZ = powRotZL[4];
        } else if (i > 0 && entity.isPowerAttack) {
            if ((i = 7 - i) < 4) {
                this.rightArm.rotateAngleX = powRotXR[i] + partialTick * (powRotXR[i + 1] - powRotXR[i]);
                this.rightArm.rotateAngleY = powRotYR[i] + partialTick * (powRotYR[i + 1] - powRotYR[i]);
                this.rightArm.rotateAngleZ = powRotZR[i] + partialTick * (powRotZR[i + 1] - powRotZR[i]);
                this.leftArm.rotateAngleX = powRotXL[i] + partialTick * (powRotXL[i + 1] - powRotXL[i]);
                this.leftArm.rotateAngleY = powRotYL[i] + partialTick * (powRotYL[i + 1] - powRotYL[i]);
                this.leftArm.rotateAngleZ = powRotZL[i] + partialTick * (powRotZL[i + 1] - powRotZL[i]);
            } else {
                this.rightArm.rotateAngleX = powRotXR[4];
                this.rightArm.rotateAngleY = powRotYR[4];
                this.rightArm.rotateAngleZ = powRotZR[4];
                this.leftArm.rotateAngleX = powRotXL[4];
                this.leftArm.rotateAngleY = powRotYL[4];
                this.leftArm.rotateAngleZ = powRotZL[4];
            }
        } else if (Math.abs(i) > 0) {
            int isLeft = i > 0 ? 1 : -1;
            i = Math.abs(i);
            this.rightArm.rotateAngleX = MathHelper.clamp_float((float)(-1.0f + 3.5f * this.getSwingAmount((float)i - partialTick, 10.0f)), (float)-4.5f, (float)1.5f);
            this.rightArm.rotateAngleY = 0.0f;
            this.rightArm.rotateAngleZ = (float)isLeft * (attackRotZ[(i + 1) % 9] + partialTick * (attackRotZ[i % 9] - attackRotZ[(i + 1) % 9]));
            this.leftArm.rotateAngleX = 0.0f;
            this.leftArm.rotateAngleZ = 0.0f;
        } else if (j > 0) {
            int max = entity.getChargeTime() - 1;
            i = j == max ? 3 : (j == max - 1 ? 2 : (j == max - 2 ? 1 : 0));
            this.rightArm.rotateAngleX = i == 0 ? -3.5f : powRotXR[i];
            this.rightArm.rotateAngleY = powRotYR[i];
            this.rightArm.rotateAngleZ = 0.0f;
            this.leftArm.rotateAngleX = powRotXL[i];
            this.leftArm.rotateAngleY = powRotYL[i];
            this.leftArm.rotateAngleZ = powRotZL[i];
        } else {
            this.rightArm.rotateAngleZ = 0.0f;
            this.leftArm.rotateAngleZ = 0.0f;
        }
    }

    private float getSwingAmount(float f, float max) {
        return (Math.abs(f % max - max * 0.5f) - max * 0.25f) / (max * 0.25f);
    }

    public void setRotationAngles(float f1, float f2, float f3, float f4, float f5, float f6, Entity entity) {
        boolean adjustArms;
        super.setRotationAngles(f1, f2, f3, f4, f5, f6, entity);
        this.head.rotateAngleY = f4 / 57.295776f;
        this.head.rotateAngleX = f5 / 57.295776f;
        this.helmBackPlate.rotateAngleY = this.head.rotateAngleY;
        this.helmBackPlate.rotateAngleX = this.head.rotateAngleX;
        EntityDarknut darknut = (EntityDarknut)entity;
        boolean bl = adjustArms = darknut.attackTimer == 0 && darknut.chargeTimer == 0 && !darknut.isSpinning();
        if (adjustArms) {
            this.rightArm.rotateAngleX = MathHelper.cos((float)(f1 * 0.6662f)) * 2.0f * f2 * 0.5f;
            this.rightArm.rotateAngleZ = 0.0f;
            this.leftArm.rotateAngleX = MathHelper.cos((float)(f1 * 0.6662f + (float)Math.PI)) * 2.0f * f2 * 0.5f;
            this.leftArm.rotateAngleZ = 0.0f;
            this.rightArm.rotateAngleY = 0.0f;
            this.leftArm.rotateAngleY = 0.0f;
        }
        this.rightLeg.rotateAngleX = MathHelper.cos((float)(f1 * 0.6662f)) * 1.4f * f2;
        this.leftLeg.rotateAngleX = MathHelper.cos((float)(f1 * 0.6662f + (float)Math.PI)) * 1.4f * f2;
        this.rightLeg.rotateAngleY = 0.0f;
        this.leftLeg.rotateAngleY = 0.0f;
        if (this.heldItemLeft != 0) {
            this.leftArm.rotateAngleX = this.leftArm.rotateAngleX * 0.5f - 0.31415927f * (float)this.heldItemLeft;
        }
        if (this.heldItemRight != 0) {
            this.rightArm.rotateAngleX = this.rightArm.rotateAngleX * 0.5f - 0.31415927f * (float)this.heldItemRight;
        }
        if (this.onGround > -9990.0f) {
            f6 = this.onGround;
            this.body.rotateAngleY = MathHelper.sin((float)(MathHelper.sqrt_float((float)f6) * (float)Math.PI * 2.0f)) * 0.2f;
            if (adjustArms) {
                this.rightArm.rotationPointZ = MathHelper.sin((float)this.body.rotateAngleY) * 5.0f;
                this.rightArm.rotationPointX = -MathHelper.cos((float)this.body.rotateAngleY) * 5.0f;
                this.leftArm.rotationPointZ = -MathHelper.sin((float)this.body.rotateAngleY) * 5.0f;
                this.leftArm.rotationPointX = MathHelper.cos((float)this.body.rotateAngleY) * 5.0f;
                this.rightArm.rotateAngleY += this.body.rotateAngleY;
                this.leftArm.rotateAngleY += this.body.rotateAngleY;
                this.leftArm.rotateAngleX += this.body.rotateAngleY;
                f6 = 1.0f - this.onGround;
                f6 *= f6;
                f6 *= f6;
                f6 = 1.0f - f6;
                float f7 = MathHelper.sin((float)(f6 * (float)Math.PI));
                float f8 = MathHelper.sin((float)(this.onGround * (float)Math.PI)) * -(this.head.rotateAngleX - 0.7f) * 0.75f;
                this.rightArm.rotateAngleX = (float)((double)this.rightArm.rotateAngleX - ((double)f7 * 1.2 + (double)f8));
                this.rightArm.rotateAngleY += this.body.rotateAngleY * 2.0f;
                this.rightArm.rotateAngleZ = MathHelper.sin((float)(this.onGround * (float)Math.PI)) * -0.4f;
            }
        }
        if (adjustArms) {
            this.rightArm.rotateAngleZ += MathHelper.cos((float)(f3 * 0.09f)) * 0.05f + 0.05f;
            this.leftArm.rotateAngleZ -= MathHelper.cos((float)(f3 * 0.09f)) * 0.05f + 0.05f;
            this.rightArm.rotateAngleX += MathHelper.sin((float)(f3 * 0.067f)) * 0.05f;
            this.leftArm.rotateAngleX -= MathHelper.sin((float)(f3 * 0.067f)) * 0.05f;
        }
        this.shoulderPlateRight.rotateAngleX = this.rightArm.rotateAngleX;
        this.shoulderPlateRight.rotateAngleY = this.rightArm.rotateAngleY;
        this.shoulderPlateRight.rotateAngleZ = this.rightArm.rotateAngleZ;
        this.shoulderPlateLeft.rotateAngleX = this.leftArm.rotateAngleX;
        this.shoulderPlateLeft.rotateAngleY = this.leftArm.rotateAngleY;
        this.shoulderPlateLeft.rotateAngleZ = this.leftArm.rotateAngleZ;
    }

    @Override
    public void postRenderHead(float scale) {
        this.head.postRender(scale);
    }

    @Override
    public void postRenderArm(boolean isRight, float scale) {
        if (isRight) {
            this.rightArm.postRender(scale);
        } else {
            this.leftArm.postRender(scale);
        }
    }

    @Override
    public void setHeldItemValue(boolean isRight, int heldValue) {
        if (isRight) {
            this.heldItemRight = heldValue;
        } else {
            this.heldItemLeft = heldValue;
        }
    }
}

