/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.render.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.client.model.ModelBomb;
import zeldaswordskills.entity.projectile.EntityBomb;

@SideOnly(value=Side.CLIENT)
public class RenderEntityBomb
extends Render {
    public static final ResourceLocation[] bombTextures = new ResourceLocation[BombType.values().length];
    public static final ResourceLocation[] flashTextures = new ResourceLocation[BombType.values().length];
    protected ModelBase model = new ModelBomb();

    protected ResourceLocation getEntityTexture(Entity bomb) {
        int i = ((EntityBomb)bomb).getType().ordinal();
        return bomb.ticksExisted % 13 > 10 ? flashTextures[i] : bombTextures[i];
    }

    public void doRender(Entity bomb, double x, double y, double z, float yaw, float partialTick) {
        this.renderEntityModel(bomb, x, y, z, yaw, partialTick);
    }

    public void renderEntityModel(Entity bomb, double x, double y, double z, float yaw, float partialTick) {
        GL11.glPushMatrix();
        float scale = bomb.ticksExisted % 13 > 10 ? 1.25f : 1.1f;
        this.bindTexture(this.getEntityTexture(bomb));
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glEnable((int)32826);
        GL11.glRotatef((float)150.0f, (float)1.0f, (float)1.0f, (float)300.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
        this.model.render(bomb, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0475f);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    static {
        for (BombType type : BombType.values()) {
            RenderEntityBomb.bombTextures[type.ordinal()] = new ResourceLocation("zeldaswordskills", "textures/entity/bomb_" + type.unlocalizedName + ".png");
            RenderEntityBomb.flashTextures[type.ordinal()] = new ResourceLocation("zeldaswordskills", "textures/entity/bomb_" + type.unlocalizedName + "_flash.png");
        }
    }
}

