/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.render.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import zeldaswordskills.entity.projectile.EntityBoomerang;

@SideOnly(value=Side.CLIENT)
public class RenderEntityBoomerang
extends Render {
    public void renderBoomerang(EntityBoomerang entity, double x, double y, double z, float yaw, float partialTick) {
        ItemStack boomerang = entity.getBoomerang();
        if (boomerang != null) {
            float rotation;
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            for (rotation = ((float)entity.ticksExisted + partialTick) * 50.0f; rotation > 360.0f; rotation -= 360.0f) {
            }
            GL11.glRotatef((float)(entity.rotationYaw + (entity.prevRotationYaw - entity.rotationYaw) * partialTick - 60.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(Math.abs(entity.rotationPitch + (entity.prevRotationPitch - entity.rotationPitch)) * partialTick - rotation), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
            IIcon icon = boomerang.getItem().getIconFromDamage(0);
            this.bindTexture(this.renderManager.renderEngine.getResourceLocation(boomerang.getItem().getSpriteNumber()));
            Tessellator tessellator = Tessellator.instance;
            ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)icon.getMaxU(), (float)icon.getMinV(), (float)icon.getMinU(), (float)icon.getMaxV(), (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.0625f);
            GL11.glPopMatrix();
        }
    }

    public void doRender(Entity entity, double x, double y, double z, float yaw, float partialTick) {
        this.renderBoomerang((EntityBoomerang)entity, x, y, z, yaw, partialTick);
    }

    protected ResourceLocation getEntityTexture(Entity entity) {
        return null;
    }
}

