/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.render.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import zeldaswordskills.entity.projectile.EntityHookShot;

@SideOnly(value=Side.CLIENT)
public class RenderEntityHookShot
extends Render {
    private static final ResourceLocation arrowTexture = new ResourceLocation("textures/entity/arrow.png");

    public void doRender(Entity entity, double x, double y, double z, float yaw, float partialTick) {
        this.renderArrow((EntityHookShot)entity, x, y, z, yaw, partialTick);
        this.renderLeash((EntityHookShot)entity, x, y, z, yaw, partialTick);
    }

    protected ResourceLocation getEntityTexture(Entity entity) {
        return arrowTexture;
    }

    public void renderArrow(EntityHookShot hookshot, double x, double y, double z, float yaw, float partialTick) {
        this.bindEntityTexture((Entity)hookshot);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotatef((float)(hookshot.prevRotationYaw + (hookshot.rotationYaw - hookshot.prevRotationYaw) * partialTick - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(hookshot.prevRotationPitch + (hookshot.rotationPitch - hookshot.prevRotationPitch) * partialTick), (float)0.0f, (float)0.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.instance;
        int b0 = 0;
        float f2 = 0.0f;
        float f3 = 0.5f;
        float f4 = (float)(0 + b0 * 10) / 32.0f;
        float f5 = (float)(5 + b0 * 10) / 32.0f;
        float f6 = 0.0f;
        float f7 = 0.15625f;
        float f8 = (float)(5 + b0 * 10) / 32.0f;
        float f9 = (float)(10 + b0 * 10) / 32.0f;
        float f10 = 0.05625f;
        GL11.glEnable((int)32826);
        GL11.glRotatef((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)f10, (float)f10, (float)f10);
        GL11.glTranslatef((float)-4.0f, (float)0.0f, (float)0.0f);
        GL11.glNormal3f((float)f10, (float)0.0f, (float)0.0f);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-7.0, -2.0, -2.0, (double)f6, (double)f8);
        tessellator.addVertexWithUV(-7.0, -2.0, 2.0, (double)f7, (double)f8);
        tessellator.addVertexWithUV(-7.0, 2.0, 2.0, (double)f7, (double)f9);
        tessellator.addVertexWithUV(-7.0, 2.0, -2.0, (double)f6, (double)f9);
        tessellator.draw();
        GL11.glNormal3f((float)(-f10), (float)0.0f, (float)0.0f);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-7.0, 2.0, -2.0, (double)f6, (double)f8);
        tessellator.addVertexWithUV(-7.0, 2.0, 2.0, (double)f7, (double)f8);
        tessellator.addVertexWithUV(-7.0, -2.0, 2.0, (double)f7, (double)f9);
        tessellator.addVertexWithUV(-7.0, -2.0, -2.0, (double)f6, (double)f9);
        tessellator.draw();
        for (int i = 0; i < 4; ++i) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)f10);
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(-8.0, -2.0, 0.0, (double)f2, (double)f4);
            tessellator.addVertexWithUV(8.0, -2.0, 0.0, (double)f3, (double)f4);
            tessellator.addVertexWithUV(8.0, 2.0, 0.0, (double)f3, (double)f5);
            tessellator.addVertexWithUV(-8.0, 2.0, 0.0, (double)f2, (double)f5);
            tessellator.draw();
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    private double interpolateValue(double start, double end, double pct) {
        return start + (end - start) * pct;
    }

    protected void renderLeash(EntityHookShot hookshot, double x, double y, double z, float yaw, float partialTick) {
        EntityLivingBase entity = hookshot.getThrower();
        if (entity != null) {
            float f2;
            int i;
            y -= (3.0 - (double)hookshot.height) * 0.5;
            Tessellator tessellator = Tessellator.instance;
            double d3 = this.interpolateValue(entity.prevRotationYaw, entity.rotationYaw, partialTick * 0.5f) * 0.01745329238474369;
            double d4 = this.interpolateValue(entity.prevRotationPitch, entity.rotationPitch, partialTick * 0.5f) * 0.01745329238474369;
            double d5 = Math.cos(d3);
            double d6 = Math.sin(d3);
            double d7 = Math.sin(d4);
            double d8 = Math.cos(d4);
            double d9 = this.interpolateValue(entity.prevPosX, entity.posX, partialTick) - d5 * 0.7 - d6 * 0.5 * d8;
            double d10 = this.interpolateValue(entity.prevPosY + (double)entity.getEyeHeight() * 0.7, entity.posY + (double)entity.getEyeHeight() * 0.7, partialTick) - d7 * 0.5 - 0.25;
            double d11 = this.interpolateValue(entity.prevPosZ, entity.posZ, partialTick) - d6 * 0.7 + d5 * 0.5 * d8;
            double d12 = this.interpolateValue(hookshot.prevRotationYaw, hookshot.prevRotationPitch, partialTick) * 0.01745329238474369 + 1.5707963267948966;
            d5 = Math.cos(d12) * (double)hookshot.width * 0.4;
            d6 = Math.sin(d12) * (double)hookshot.width * 0.4;
            if (hookshot.isInGround()) {
                hookshot.posX = hookshot.getDataWatcher().getWatchableObjectFloat(26);
                hookshot.posY = hookshot.getDataWatcher().getWatchableObjectFloat(27);
                hookshot.posZ = hookshot.getDataWatcher().getWatchableObjectFloat(28);
                hookshot.prevPosX = hookshot.posX;
                hookshot.prevPosY = hookshot.posY;
                hookshot.prevPosZ = hookshot.posZ;
            }
            double d13 = this.interpolateValue(hookshot.prevPosX, hookshot.posX, partialTick) + d5;
            double d14 = this.interpolateValue(hookshot.prevPosY, hookshot.posY, partialTick);
            double d15 = this.interpolateValue(hookshot.prevPosZ, hookshot.posZ, partialTick) + d6;
            x += d5;
            z += d6;
            double d16 = (float)(d9 - d13);
            double d17 = (float)(d10 - d14);
            double d18 = (float)(d11 - d15);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2884);
            tessellator.startDrawing(5);
            float grey = 0.5019608f;
            float lgrey = grey / 2.0f;
            for (i = 0; i <= 24; ++i) {
                if (i % 2 == 0) {
                    tessellator.setColorRGBA_F(grey, grey, grey, 1.0f);
                } else {
                    tessellator.setColorRGBA_F(lgrey, lgrey, lgrey, 1.0f);
                }
                f2 = (float)i / 24.0f;
                tessellator.addVertex(x + d16 * (double)f2 + 0.0, y + d17 * (double)(f2 * f2 + f2) * 0.5 + (double)((24.0f - (float)i) / 18.0f + 0.125f), z + d18 * (double)f2);
                tessellator.addVertex(x + d16 * (double)f2 + 0.025, y + d17 * (double)(f2 * f2 + f2) * 0.5 + (double)((24.0f - (float)i) / 18.0f + 0.125f) + 0.025, z + d18 * (double)f2);
            }
            tessellator.draw();
            tessellator.startDrawing(5);
            for (i = 0; i <= 24; ++i) {
                if (i % 2 == 0) {
                    tessellator.setColorRGBA_F(grey, grey, grey, 1.0f);
                } else {
                    tessellator.setColorRGBA_F(lgrey, lgrey, lgrey, 1.0f);
                }
                f2 = (float)i / 24.0f;
                tessellator.addVertex(x + d16 * (double)f2 + 0.0, y + d17 * (double)(f2 * f2 + f2) * 0.5 + (double)((24.0f - (float)i) / 18.0f + 0.125f) + 0.025, z + d18 * (double)f2);
                tessellator.addVertex(x + d16 * (double)f2 + 0.025, y + d17 * (double)(f2 * f2 + f2) * 0.5 + (double)((24.0f - (float)i) / 18.0f + 0.125f), z + d18 * (double)f2 + 0.025);
            }
            tessellator.draw();
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2884);
        }
    }
}

