/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.damage.EnumDamageType;

public class EntityEtherLightning
extends EntityLightningBolt {
    private int lightningState;
    private int boltLivingTime;
    protected final EntityLivingBase thrower;
    protected EntityLivingBase target;

    public EntityEtherLightning(World world, EntityLivingBase thrower, EntityLivingBase target, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
        this.thrower = thrower;
        this.target = target;
        this.setLocationAndAngles(posX, posY, posZ, 0.0f, 0.0f);
        this.lightningState = 2;
        this.boltVertex = this.rand.nextLong();
        this.boltLivingTime = this.rand.nextInt(3) + 1;
        if (!world.isRemote && world.getGameRules().getGameRuleBooleanValue("doFireTick") && (world.difficultySetting == EnumDifficulty.NORMAL || world.difficultySetting == EnumDifficulty.HARD) && this.worldObj.doChunksNearChunkExist(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ), 10)) {
            this.extinguishFire(world);
        }
    }

    public void onUpdate() {
        super.onEntityUpdate();
        if (this.lightningState == 2) {
            this.worldObj.playSoundEffect(this.posX, this.posY, this.posZ, "ambient.weather.thunder", 10000.0f, 0.8f + this.rand.nextFloat() * 0.2f);
            this.worldObj.playSoundEffect(this.posX, this.posY, this.posZ, "random.explode", 2.0f, 0.5f + this.rand.nextFloat() * 0.2f);
        }
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.setDead();
            } else if (this.lightningState < -this.rand.nextInt(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                this.boltVertex = this.rand.nextLong();
            }
        }
        if (this.lightningState >= 0) {
            if (this.worldObj.isRemote) {
                this.worldObj.lastLightningBolt = 2;
            } else if (this.target != null) {
                int strength = (this.worldObj.isRaining() ? 20 : 0) + (this.worldObj.isThundering() ? 30 : 0);
                float damage = 15.0f + (float)this.rand.nextInt(11) + (float)strength * 0.2f;
                if (this.target.onGround) {
                    damage /= 3.0f;
                }
                int time = 600 + (strength > 0 || !this.target.onGround ? this.rand.nextInt(10) + this.rand.nextInt(Math.max(1, strength)) + 10 : 0);
                DamageSource source = new DamageUtils.DamageSourceBaseIndirect("lightningBolt", (Entity)this, (Entity)this.thrower, true, EnumDamageType.SHOCK).setMagicDamage().setDamageBypassesArmor();
                if (time > 0) {
                    ((DamageUtils.DamageSourceBaseIndirect)source).setStunDamage(time, 1, true);
                }
                this.target.attackEntityFrom(source, damage);
                if (!ForgeEventFactory.onEntityStruckByLightning((Entity)this.target, (EntityLightningBolt)this)) {
                    this.target.onStruckByLightning((EntityLightningBolt)this);
                }
                this.target = null;
            }
        }
    }

    private void extinguishFire(World world) {
        int dx = MathHelper.floor_double((double)this.posX);
        int dy = MathHelper.floor_double((double)this.posY);
        int dz = MathHelper.floor_double((double)this.posZ);
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (world.getBlock(dx + i, dy + j, dz + k) != Blocks.fire) continue;
                    world.setBlockToAir(dx + i, dy + j, dz + k);
                }
            }
        }
    }
}

