/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelSquid;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.entity.LootableEntityRegistry;
import zeldaswordskills.client.model.ModelDarknut;
import zeldaswordskills.client.model.ModelDekuBaba;
import zeldaswordskills.client.model.ModelDekuFire;
import zeldaswordskills.client.model.ModelDekuWithered;
import zeldaswordskills.client.model.ModelGoron;
import zeldaswordskills.client.model.ModelMaskSalesman;
import zeldaswordskills.client.model.ModelWizzrobe;
import zeldaswordskills.client.render.RenderNothing;
import zeldaswordskills.client.render.entity.RenderCustomArrow;
import zeldaswordskills.client.render.entity.RenderDekuBaba;
import zeldaswordskills.client.render.entity.RenderEntityBomb;
import zeldaswordskills.client.render.entity.RenderEntityBoomerang;
import zeldaswordskills.client.render.entity.RenderEntityChu;
import zeldaswordskills.client.render.entity.RenderEntityFairy;
import zeldaswordskills.client.render.entity.RenderEntityHookShot;
import zeldaswordskills.client.render.entity.RenderEntityJar;
import zeldaswordskills.client.render.entity.RenderEntityKeese;
import zeldaswordskills.client.render.entity.RenderEntityMagicSpell;
import zeldaswordskills.client.render.entity.RenderEntityOctorok;
import zeldaswordskills.client.render.entity.RenderEntitySwordBeam;
import zeldaswordskills.client.render.entity.RenderEntityWhip;
import zeldaswordskills.client.render.entity.RenderEntityWizzrobe;
import zeldaswordskills.client.render.entity.RenderGenericLiving;
import zeldaswordskills.entity.CustomEntityList;
import zeldaswordskills.entity.EntityFairy;
import zeldaswordskills.entity.EntityNavi;
import zeldaswordskills.entity.mobs.EntityBlackKnight;
import zeldaswordskills.entity.mobs.EntityChu;
import zeldaswordskills.entity.mobs.EntityDarknut;
import zeldaswordskills.entity.mobs.EntityDekuBaba;
import zeldaswordskills.entity.mobs.EntityDekuFire;
import zeldaswordskills.entity.mobs.EntityDekuWithered;
import zeldaswordskills.entity.mobs.EntityGrandWizzrobe;
import zeldaswordskills.entity.mobs.EntityKeese;
import zeldaswordskills.entity.mobs.EntityOctorok;
import zeldaswordskills.entity.mobs.EntityWizzrobe;
import zeldaswordskills.entity.npc.EntityGoron;
import zeldaswordskills.entity.npc.EntityNpcBarnes;
import zeldaswordskills.entity.npc.EntityNpcMaskTrader;
import zeldaswordskills.entity.npc.EntityNpcOrca;
import zeldaswordskills.entity.npc.EntityNpcZelda;
import zeldaswordskills.entity.projectile.EntityArrowBomb;
import zeldaswordskills.entity.projectile.EntityArrowCustom;
import zeldaswordskills.entity.projectile.EntityArrowElemental;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.entity.projectile.EntityBombosFireball;
import zeldaswordskills.entity.projectile.EntityBoomerang;
import zeldaswordskills.entity.projectile.EntityCeramicJar;
import zeldaswordskills.entity.projectile.EntityCyclone;
import zeldaswordskills.entity.projectile.EntityHookShot;
import zeldaswordskills.entity.projectile.EntityLeapingBlow;
import zeldaswordskills.entity.projectile.EntityMagicSpell;
import zeldaswordskills.entity.projectile.EntitySeedShot;
import zeldaswordskills.entity.projectile.EntitySwordBeam;
import zeldaswordskills.entity.projectile.EntityThrowingRock;
import zeldaswordskills.entity.projectile.EntityWhip;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.ref.LibPotionID;
import zeldaswordskills.util.BiomeType;
import zeldaswordskills.util.SpawnableEntityData;

public class ZSSEntities {
    private static int spawnGoron;
    private static final Map<Class<? extends EntityLiving>, String[]> defaultSpawnLists;
    private static final Map<Class<? extends EntityLiving>, SpawnableEntityData> spawnableEntityData;

    public static int getGoronRatio() {
        return spawnGoron;
    }

    public static void preInit() {
        ZSSEntities.registerEntities();
        ZSSEntities.addSpawnLocations(EntityChu.class, EntityChu.getDefaultBiomes());
        ZSSEntities.addSpawnLocations(EntityDarknut.class, EntityDarknut.getDefaultBiomes());
        ZSSEntities.addSpawnLocations(EntityDekuBaba.class, EntityDekuBaba.getDefaultBiomes());
        ZSSEntities.addSpawnLocations(EntityDekuFire.class, EntityDekuFire.getDefaultBiomes());
        ZSSEntities.addSpawnLocations(EntityDekuWithered.class, EntityDekuWithered.getDefaultBiomes());
        ZSSEntities.addSpawnLocations(EntityFairy.class, BiomeType.RIVER.defaultBiomes);
        ZSSEntities.addSpawnLocations(EntityKeese.class, EntityKeese.getDefaultBiomes());
        ZSSEntities.addSpawnLocations(EntityWizzrobe.class, EntityWizzrobe.getDefaultBiomes());
        ZSSEntities.addSpawnLocations(EntityOctorok.class, BiomeType.OCEAN.defaultBiomes);
    }

    public static void postInit(Configuration config) {
        int rate = config.get("Mob Spawns", "[Spawn Rate] Chuchu spawn rate (0 to disable)[0+]", 10).getInt();
        ZSSEntities.addSpawnableEntityData(EntityChu.class, EnumCreatureType.monster, 4, 4, rate);
        rate = config.get("Mob Spawns", "[Spawn Rate] Darknut spawn rate (0 to disable)[0+]", 5).getInt();
        ZSSEntities.addSpawnableEntityData(EntityDarknut.class, EnumCreatureType.monster, 1, 1, rate);
        rate = config.get("Mob Spawns", "[Spawn Rate] Deku Baba spawn rate (0 to disable)[0+]", 10).getInt();
        ZSSEntities.addSpawnableEntityData(EntityDekuBaba.class, EnumCreatureType.monster, 1, 3, rate);
        rate = config.get("Mob Spawns", "[Spawn Rate] Deku Baba (Fire) spawn rate (0 to disable)[0+]", 2).getInt();
        ZSSEntities.addSpawnableEntityData(EntityDekuFire.class, EnumCreatureType.monster, 1, 3, rate);
        rate = config.get("Mob Spawns", "[Spawn Rate] Deku Baba (Withered) spawn rate (0 to disable)[0+]", 5).getInt();
        ZSSEntities.addSpawnableEntityData(EntityDekuWithered.class, EnumCreatureType.monster, 1, 3, rate);
        rate = config.get("Mob Spawns", "[Spawn Rate] Fairy (wild) spawn rate (0 to disable)[0+]", 1).getInt();
        ZSSEntities.addSpawnableEntityData(EntityFairy.class, EnumCreatureType.ambient, 1, 3, rate);
        spawnGoron = config.get("Mob Spawns", "[Spawn Rate] Goron spawn rate, as a ratio of regular villagers to Gorons (0 to disable)[0+]", 4).getInt();
        rate = config.get("Mob Spawns", "[Spawn Rate] Keese spawn rate (0 to disable)[0+]", 1).getInt();
        ZSSEntities.addSpawnableEntityData(EntityKeese.class, EnumCreatureType.ambient, 4, 4, rate);
        rate = config.get("Mob Spawns", "[Spawn Rate] Octorok spawn rate (0 to disable)[0+]", 8).getInt();
        ZSSEntities.addSpawnableEntityData(EntityOctorok.class, EnumCreatureType.waterCreature, 2, 4, rate);
        rate = config.get("Mob Spawns", "[Spawn Rate] Wizzrobe spawn rate (0 to disable)[0+]", 10).getInt();
        ZSSEntities.addSpawnableEntityData(EntityWizzrobe.class, EnumCreatureType.monster, 1, 1, rate);
        for (Class<? extends EntityLiving> entity : defaultSpawnLists.keySet()) {
            String[] biomes;
            String[] defaultBiomes = defaultSpawnLists.get(entity);
            SpawnableEntityData spawnData = spawnableEntityData.get(entity);
            if (defaultBiomes == null || spawnData == null || spawnData.spawnRate <= 0 || (biomes = config.get("Mob Spawns", String.format("[Spawn Biomes] List of biomes in which %s are allowed to spawn", entity.getName().substring(entity.getName().lastIndexOf(".") + 1)), defaultBiomes).getStringList()) == null) continue;
            ZSSEntities.addSpawns(entity, biomes, spawnData);
        }
        float f = Config.getVanillaWhipLootChance();
        if (f > 0.0f) {
            LootableEntityRegistry.addLootableEntity(EntityBlaze.class, f, new ItemStack(Items.blaze_rod));
            LootableEntityRegistry.addLootableEntity(EntityCaveSpider.class, f, new ItemStack(Items.spider_eye), new ItemStack(Items.string));
            LootableEntityRegistry.addLootableEntity(EntityCreeper.class, f, new ItemStack(Items.gunpowder));
            LootableEntityRegistry.addLootableEntity(EntityEnderman.class, f, new ItemStack(Items.ender_pearl));
            LootableEntityRegistry.addLootableEntity(EntityGhast.class, f, new ItemStack(Items.ghast_tear), new ItemStack(Items.gunpowder), new ItemStack(Items.gunpowder));
            LootableEntityRegistry.addLootableEntity(EntityIronGolem.class, f, new ItemStack(Items.iron_ingot));
            LootableEntityRegistry.addLootableEntity(EntityMagmaCube.class, f, new ItemStack(Items.magma_cream));
            LootableEntityRegistry.addLootableEntity(EntityPigZombie.class, f, new ItemStack(Items.gold_nugget), new ItemStack(Items.gold_nugget), new ItemStack(Items.gold_ingot));
            LootableEntityRegistry.addLootableEntity(EntitySkeleton.class, f, new ItemStack(Items.arrow), new ItemStack(Items.bone), new ItemStack(Items.flint));
            LootableEntityRegistry.addLootableEntity(EntitySlime.class, f, new ItemStack(Items.slime_ball));
            LootableEntityRegistry.addLootableEntity(EntitySnowman.class, f, new ItemStack(Items.snowball));
            LootableEntityRegistry.addLootableEntity(EntitySpider.class, f, new ItemStack(Items.spider_eye), new ItemStack(Items.string));
            LootableEntityRegistry.addLootableEntity(EntityWitch.class, f, new ItemStack((Item)Items.potionitem, 1, LibPotionID.HEALING.id), new ItemStack((Item)Items.potionitem, 1, LibPotionID.SWIFTNESS.id), new ItemStack((Item)Items.potionitem, 1, LibPotionID.FIRERESIST.id), new ItemStack((Item)Items.potionitem, 1, LibPotionID.WATER_BREATHING.id));
            LootableEntityRegistry.addLootableEntity(EntityZombie.class, f, new ItemStack(Items.iron_ingot), new ItemStack(Items.carrot), new ItemStack(Items.potato));
        }
    }

    private static void addSpawns(Class<? extends EntityLiving> entity, String[] biomes, SpawnableEntityData spawnData) {
        for (String name : biomes) {
            BiomeGenBase biome = ZSSEntities.getBiomeByName(name);
            if (biome != null) {
                EntityRegistry.addSpawn(entity, (int)spawnData.spawnRate, (int)spawnData.min, (int)spawnData.max, (EnumCreatureType)spawnData.creatureType, (BiomeGenBase[])new BiomeGenBase[]{biome});
                continue;
            }
            ZSSMain.logger.warn(String.format("Unable to find matching biome for %s while adding spawns for %s!", name, entity.getName().substring(entity.getName().lastIndexOf(".") + 1)));
        }
    }

    private static BiomeGenBase getBiomeByName(String name) {
        for (BiomeGenBase biome : BiomeGenBase.getBiomeGenArray()) {
            if (biome == null || biome.biomeName == null || !biome.biomeName.toLowerCase().replace(" ", "").equals(name.toLowerCase().replace(" ", ""))) continue;
            return biome;
        }
        return null;
    }

    private static void registerEntities() {
        int modEntityIndex = 0;
        EntityRegistry.registerModEntity(EntityLeapingBlow.class, (String)"leapingblow", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntitySwordBeam.class, (String)"swordbeam", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityBomb.class, (String)"bomb", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityBombosFireball.class, (String)"bombos_fireball", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityBoomerang.class, (String)"boomerang", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityCyclone.class, (String)"cyclone", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityCeramicJar.class, (String)"jar", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityHookShot.class, (String)"hookshot", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntitySeedShot.class, (String)"seedshot", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityThrowingRock.class, (String)"rock", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityArrowBomb.class, (String)"arrowbomb", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(EntityArrowCustom.class, (String)"arrowcustom", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(EntityArrowElemental.class, (String)"arrowelemental", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(EntityMagicSpell.class, (String)"magicspell", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityWhip.class, (String)"whip", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        ZSSEntities.registerEntity(EntityFairy.class, "fairy", ++modEntityIndex, 80, 11403055, 0xFFFF00);
        EntityRegistry.registerModEntity(EntityNavi.class, (String)"navi", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityChu.class, (String)"chu", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)80, (int)3, (boolean)true);
        CustomEntityList.addMapping(EntityChu.class, "chu", 32768, 14423100, 32768, 60928, 32768, 3825613, 32768, 0xFFFF00);
        EntityRegistry.registerModEntity(EntityDarknut.class, (String)"darknut", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)80, (int)3, (boolean)true);
        CustomEntityList.addMapping(EntityDarknut.class, "darknut", 0x1E1E1E, 9118976, 0x1E1E1E, 16459008);
        ZSSEntities.registerEntity(EntityDekuBaba.class, "baba_deku", ++modEntityIndex, 80, 0x33CC33, 255);
        ZSSEntities.registerEntity(EntityDekuFire.class, "baba_fire", ++modEntityIndex, 80, 0xFF0000, 255);
        ZSSEntities.registerEntity(EntityDekuWithered.class, "baba_withered", ++modEntityIndex, 80, 9132544, 255);
        EntityRegistry.registerModEntity(EntityKeese.class, (String)"keese", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)80, (int)3, (boolean)true);
        CustomEntityList.addMapping(EntityKeese.class, "keese", 0, 0x555555, 0, 16729344, 0, 4251856, 0, 16766720, 0, 0x800080);
        EntityRegistry.registerModEntity(EntityOctorok.class, (String)"octorok", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)80, (int)3, (boolean)true);
        CustomEntityList.addMapping(EntityOctorok.class, "octorok", 6824587, 12211667, 6824587, 0xFF00FF);
        EntityRegistry.registerModEntity(EntityWizzrobe.class, (String)"wizzrobe", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)80, (int)3, (boolean)true);
        CustomEntityList.addMapping(EntityWizzrobe.class, "wizzrobe", 9118976, 0xFF0000, 9118976, 45806, 9118976, 0xEEEE00, 9118976, 61046);
        ZSSEntities.registerEntity(EntityGrandWizzrobe.class, "wizzrobe_grand", ++modEntityIndex, 80, 9118976, 0x1E1E1E);
        ZSSEntities.registerEntity(EntityBlackKnight.class, "darknut_boss", ++modEntityIndex, 80, 0x1E1E1E, 0);
        ZSSEntities.registerEntity(EntityGoron.class, "goron", ++modEntityIndex, 80, 12092939, 9132544);
        ZSSEntities.registerEntity(EntityNpcBarnes.class, "npc.barnes", ++modEntityIndex, 80, 9143160, 15569185);
        ZSSEntities.registerEntity(EntityNpcMaskTrader.class, "npc.mask_trader", ++modEntityIndex, 80, 238, 51543);
        ZSSEntities.registerEntity(EntityNpcOrca.class, "npc.orca", ++modEntityIndex, 80, 238, 10105549);
        ZSSEntities.registerEntity(EntityNpcZelda.class, "npc.zelda", ++modEntityIndex, 80, 0xCC0099, 0xFFFFFF);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityArrowCustom.class, (Render)new RenderCustomArrow());
        RenderingRegistry.registerEntityRenderingHandler(EntityBomb.class, (Render)new RenderEntityBomb());
        RenderingRegistry.registerEntityRenderingHandler(EntityBombosFireball.class, (Render)new RenderSnowball(Items.fire_charge));
        RenderingRegistry.registerEntityRenderingHandler(EntityBoomerang.class, (Render)new RenderEntityBoomerang());
        RenderingRegistry.registerEntityRenderingHandler(EntityCeramicJar.class, (Render)new RenderEntityJar());
        RenderingRegistry.registerEntityRenderingHandler(EntityChu.class, (Render)new RenderEntityChu());
        RenderingRegistry.registerEntityRenderingHandler(EntityCyclone.class, (Render)new RenderNothing());
        RenderingRegistry.registerEntityRenderingHandler(EntityDarknut.class, (Render)new RenderGenericLiving(new ModelDarknut(), 0.5f, 1.5f, "zeldaswordskills:textures/entity/darknut_standard.png"));
        RenderingRegistry.registerEntityRenderingHandler(EntityBlackKnight.class, (Render)new RenderGenericLiving(new ModelDarknut(), 0.5f, 1.8f, "zeldaswordskills:textures/entity/darknut_standard.png"));
        RenderingRegistry.registerEntityRenderingHandler(EntityDekuBaba.class, (Render)new RenderDekuBaba(new ModelDekuBaba(), 0.5f, 1.25f, "zeldaswordskills:textures/entity/deku_baba.png"));
        RenderingRegistry.registerEntityRenderingHandler(EntityDekuFire.class, (Render)new RenderDekuBaba(new ModelDekuFire(), 0.5f, 1.25f, "zeldaswordskills:textures/entity/deku_baba.png"));
        RenderingRegistry.registerEntityRenderingHandler(EntityDekuWithered.class, (Render)new RenderDekuBaba(new ModelDekuWithered(), 0.5f, 1.25f, "zeldaswordskills:textures/entity/deku_withered.png"));
        RenderingRegistry.registerEntityRenderingHandler(EntityFairy.class, (Render)new RenderEntityFairy());
        RenderingRegistry.registerEntityRenderingHandler(EntityNavi.class, (Render)new RenderEntityFairy());
        RenderingRegistry.registerEntityRenderingHandler(EntityGoron.class, (Render)new RenderGenericLiving(new ModelGoron(), 0.5f, 1.5f, "zeldaswordskills:textures/entity/goron.png"));
        RenderingRegistry.registerEntityRenderingHandler(EntityKeese.class, (Render)new RenderEntityKeese());
        RenderingRegistry.registerEntityRenderingHandler(EntityHookShot.class, (Render)new RenderEntityHookShot());
        RenderingRegistry.registerEntityRenderingHandler(EntityLeapingBlow.class, (Render)new RenderNothing());
        RenderingRegistry.registerEntityRenderingHandler(EntityMagicSpell.class, (Render)new RenderEntityMagicSpell());
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcBarnes.class, (Render)new RenderGenericLiving((ModelBase)new ModelBiped(0.0f, 0.0f, 64, 64), 0.5f, 1.0f, "zeldaswordskills:textures/entity/npc_barnes.png"));
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcMaskTrader.class, (Render)new RenderGenericLiving(new ModelMaskSalesman(), 0.5f, 1.0f, "zeldaswordskills:textures/entity/npc_mask_salesman.png"));
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcOrca.class, (Render)new RenderGenericLiving((ModelBase)new ModelBiped(0.0f, 0.0f, 64, 64), 0.5f, 1.0f, "zeldaswordskills:textures/entity/npc_orca.png"));
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcZelda.class, (Render)new RenderGenericLiving((ModelBase)new ModelBiped(0.0f, 0.0f, 64, 64), 0.5f, 1.0f, "zeldaswordskills:textures/entity/npc_zelda.png"));
        RenderingRegistry.registerEntityRenderingHandler(EntityOctorok.class, (Render)new RenderEntityOctorok((ModelBase)new ModelSquid(), 0.7f));
        RenderingRegistry.registerEntityRenderingHandler(EntitySeedShot.class, (Render)new RenderSnowball(ZSSItems.dekuNut));
        RenderingRegistry.registerEntityRenderingHandler(EntitySwordBeam.class, (Render)new RenderEntitySwordBeam());
        RenderingRegistry.registerEntityRenderingHandler(EntityThrowingRock.class, (Render)new RenderSnowball(ZSSItems.throwingRock));
        RenderingRegistry.registerEntityRenderingHandler(EntityWhip.class, (Render)new RenderEntityWhip());
        RenderingRegistry.registerEntityRenderingHandler(EntityWizzrobe.class, (Render)new RenderEntityWizzrobe(new ModelWizzrobe(), 1.0f));
        RenderingRegistry.registerEntityRenderingHandler(EntityGrandWizzrobe.class, (Render)new RenderEntityWizzrobe(new ModelWizzrobe(), 1.5f));
    }

    public static void registerEntity(Class<? extends EntityLiving> entityClass, String name, int modEntityIndex, int trackingRange, int primaryColor, int secondaryColor) {
        EntityRegistry.registerModEntity(entityClass, (String)name, (int)modEntityIndex, (Object)ZSSMain.instance, (int)trackingRange, (int)3, (boolean)true);
        CustomEntityList.addMapping(entityClass, name, primaryColor, secondaryColor);
    }

    private static void addSpawnableEntityData(Class<? extends EntityLiving> entity, EnumCreatureType creatureType, int min, int max, int spawnRate) {
        if (spawnableEntityData.containsKey(entity)) {
            ZSSMain.logger.warn("Spawnable entity " + entity.getName().substring(entity.getName().lastIndexOf(".") + 1) + " has already been registered!");
        } else {
            spawnableEntityData.put(entity, new SpawnableEntityData(creatureType, min, max, spawnRate));
        }
    }

    private static void addSpawnLocations(Class<? extends EntityLiving> entity, String ... biomes) {
        if (biomes != null && biomes.length > 0) {
            if (defaultSpawnLists.containsKey(entity)) {
                ZSSMain.logger.warn(entity.getName().substring(entity.getName().lastIndexOf(".") + 1) + " already has an array of default spawn locations!");
            } else {
                defaultSpawnLists.put(entity, biomes);
            }
        }
    }

    static {
        defaultSpawnLists = new HashMap<Class<? extends EntityLiving>, String[]>();
        spawnableEntityData = new HashMap<Class<? extends EntityLiving>, SpawnableEntityData>();
    }
}

