/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import zeldaswordskills.entity.mobs.EntityChu;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.entity.player.quests.QuestMaskSales;
import zeldaswordskills.handler.TradeHandler;
import zeldaswordskills.item.ItemBombBag;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.BossType;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TimedAddItem;
import zeldaswordskills.util.TimedChatDialogue;

public class ZSSVillagerInfo
implements IExtendedEntityProperties {
    private static final String SAVE_KEY = "zssVillagerInfo";
    private static final int NONE = -1;
    private final EntityVillager villager;
    private NBTTagCompound data;
    private int desiredMask;
    private static final Map<ItemTreasure.Treasures, MerchantRecipe> treasureTrades = new EnumMap<ItemTreasure.Treasures, MerchantRecipe>(ItemTreasure.Treasures.class);
    private static final Map<ItemTreasure.Treasures, Integer> treasureVillager = new EnumMap<ItemTreasure.Treasures, Integer>(ItemTreasure.Treasures.class);
    private Village village;
    private EntityVillager mate = null;
    private int matingTime = 0;

    public ZSSVillagerInfo(EntityVillager villager) {
        this.villager = villager;
        this.data = new NBTTagCompound();
        this.desiredMask = QuestMaskSales.MASKS.size();
    }

    public static final void register(EntityVillager villager) {
        villager.registerExtendedProperties(SAVE_KEY, (IExtendedEntityProperties)new ZSSVillagerInfo(villager));
    }

    public static final ZSSVillagerInfo get(EntityVillager villager) {
        return (ZSSVillagerInfo)villager.getExtendedProperties(SAVE_KEY);
    }

    public Item getMaskDesired() {
        if (this.desiredMask == QuestMaskSales.MASKS.size()) {
            this.desiredMask = this.villager.worldObj.rand.nextFloat() < Config.getMaskBuyChance() ? this.villager.worldObj.rand.nextInt(QuestMaskSales.MASKS.size()) : -1;
        }
        return this.desiredMask != -1 ? QuestMaskSales.getMask(this.desiredMask) : null;
    }

    public void handleSkulltulaTrade(ItemStack stack, EntityPlayer player) {
        ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
        String s = "chat.zss.npc.cursed_man.";
        if (this.villager.isChild()) {
            PlayerUtils.sendTranslatedChat(player, s + "child", new Object[0]);
        } else if (info.canIncrementSkulltulaTokens()) {
            if (info.incrementSkulltulaTokens()) {
                int n = info.getSkulltulaTokens();
                ItemStack reward = null;
                switch (n) {
                    case 1: {
                        PlayerUtils.sendTranslatedChat(player, s + "token." + n, new Object[0]);
                        break;
                    }
                    case 10: {
                        reward = new ItemStack(ZSSItems.whip);
                        break;
                    }
                    case 20: {
                        reward = new ItemStack(ZSSItems.tunicZoraChest);
                        break;
                    }
                    case 30: {
                        reward = new ItemStack(ZSSItems.bombBag);
                        ((ItemBombBag)reward.getItem()).addBombs(reward, new ItemStack(ZSSItems.bomb, 10));
                        break;
                    }
                    case 40: {
                        reward = new ItemStack(ZSSItems.keyBig, 1, player.worldObj.rand.nextInt(BossType.values().length));
                        break;
                    }
                    case 50: {
                        ZSSPlayerSkills skills = ZSSPlayerSkills.get(player);
                        for (SkillBase skill : SkillBase.getSkills()) {
                            if (skill.getId() == SkillBase.bonusHeart.getId() || skills.getSkillLevel(skill) >= skill.getMaxLevel() || reward != null && player.worldObj.rand.nextInt(4) != 0) continue;
                            reward = new ItemStack(ZSSItems.skillOrb, 1, (int)skill.getId());
                        }
                        if (reward != null) break;
                        reward = new ItemStack(ZSSItems.arrowLight, 16);
                        break;
                    }
                    case 100: {
                        reward = new ItemStack(Items.emerald, 64);
                        if (Config.getSkulltulaRewardRate() <= 0) break;
                        this.villager.getEntityData().setLong("NextSkulltulaReward", player.worldObj.getTotalWorldTime() + (long)(24000 * Config.getSkulltulaRewardRate()));
                        break;
                    }
                    default: {
                        PlayerUtils.sendTranslatedChat(player, s + "amount", n);
                    }
                }
                if (reward != null) {
                    new TimedChatDialogue(player, new IChatComponent[]{new ChatComponentTranslation(s + "token." + n, new Object[0]), new ChatComponentTranslation(s + "reward." + n, new Object[]{new ChatComponentTranslation(reward.getUnlocalizedName() + ".name", new Object[0])})});
                    new TimedAddItem(player, reward, 2500, "zeldaswordskills:success");
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, s + this.villager.worldObj.rand.nextInt(4), new Object[0]);
            }
        } else if (Config.getSkulltulaRewardRate() > 0 && player.worldObj.getTotalWorldTime() > this.villager.getEntityData().getLong("NextSkulltulaReward")) {
            ItemStack reward = new ItemStack(Items.emerald, 64);
            new TimedChatDialogue(player, new IChatComponent[]{new ChatComponentTranslation(s + "complete", new Object[0]), new ChatComponentTranslation(s + "reward.100", new Object[]{new ChatComponentTranslation(reward.getUnlocalizedName() + ".name", new Object[0])})});
            new TimedAddItem(player, reward, 2500, "zeldaswordskills:success");
            this.villager.getEntityData().setLong("NextSkulltulaReward", player.worldObj.getTotalWorldTime() + (long)(24000 * Config.getSkulltulaRewardRate()));
        } else {
            PlayerUtils.sendTranslatedChat(player, s + "complete", new Object[0]);
        }
    }

    public boolean isHunter() {
        return !this.villager.isChild() && this.villager.getProfession() == TradeHandler.EnumVillager.BUTCHER.ordinal() && this.villager.getCustomNameTag() != null && this.villager.getCustomNameTag().contains("Hunter");
    }

    public boolean isMonsterHunter() {
        return this.isHunter() && this.villager.getCustomNameTag().equals("Monster Hunter");
    }

    public void addHunterTrade(EntityPlayer player, ItemStack toBuy, int price) {
        if (!this.isHunter()) {
            return;
        }
        int n = price = this.isMonsterHunter() ? price + price / 2 : price;
        if (MerchantRecipeHelper.addToListWithCheck(this.villager.getRecipes(player), new MerchantRecipe(toBuy, new ItemStack(Items.emerald, price)))) {
            PlayerUtils.playSound(player, "zeldaswordskills:success", 1.0f, 1.0f);
            PlayerUtils.sendTranslatedChat(player, "chat.zss.treasure.hunter.new", new ChatComponentTranslation(toBuy.getUnlocalizedName() + ".name", new Object[0]));
        } else {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.treasure.hunter.old", new ChatComponentTranslation(toBuy.getUnlocalizedName() + ".name", new Object[0]));
        }
    }

    public MerchantRecipe getTreasureTrade(ItemTreasure.Treasures treasure) {
        if (treasureTrades.containsKey((Object)treasure) && treasureVillager.get((Object)treasure).intValue() == this.villager.getProfession()) {
            return treasureTrades.get((Object)treasure);
        }
        if (this.isHunter() && treasure.canSell()) {
            boolean flag = "Monster Hunter".equals(this.villager.getCustomNameTag());
            int price = treasure.getValue();
            price = flag ? price + price / 2 : price;
            return new MerchantRecipe(new ItemStack(ZSSItems.treasure, 1, treasure.ordinal()), new ItemStack(Items.emerald, price));
        }
        return null;
    }

    public boolean isInterested(ItemTreasure.Treasures treasure, ItemStack stack) {
        return treasureTrades.containsKey((Object)treasure) && treasureVillager.get((Object)treasure).intValue() == this.villager.getProfession();
    }

    public void addJelly(EntityChu.ChuType type, int amount) {
        this.data.setInteger("jelliesReceived" + type.ordinal(), this.getJelliesReceived(type) + amount);
    }

    public int getJelliesReceived(EntityChu.ChuType type) {
        return this.data.hasKey("jelliesReceived" + type.ordinal()) ? this.data.getInteger("jelliesReceived" + type.ordinal()) : 0;
    }

    public boolean isChuTrader() {
        return !this.villager.isChild() && this.villager.getProfession() == TradeHandler.EnumVillager.LIBRARIAN.ordinal() && this.villager.getCustomNameTag().contains("Doc");
    }

    public boolean canSellType(EntityChu.ChuType type, ItemStack stack) {
        int jellies;
        for (jellies = this.getJelliesReceived(type); jellies < 15 && stack.stackSize > 0; ++jellies) {
            --stack.stackSize;
        }
        this.data.setInteger("jelliesReceived" + type.ordinal(), jellies);
        return jellies >= 15;
    }

    private boolean isMating() {
        return this.matingTime > 0 && this.villager.getGrowingAge() == 0 && this.areSufficientDoors();
    }

    public void setMating() {
        if (this.villager.getGrowingAge() == 0 && !this.isMating()) {
            Entity e;
            this.village = this.villager.worldObj.villageCollectionObj.findNearestVillage(MathHelper.floor_double((double)this.villager.posX), MathHelper.floor_double((double)this.villager.posY), MathHelper.floor_double((double)this.villager.posZ), 0);
            if (this.areSufficientDoors() && (e = this.villager.worldObj.findNearestEntityWithinAABB(EntityVillager.class, this.villager.boundingBox.expand(8.0, 3.0, 8.0), (Entity)this.villager)) != null && ((EntityVillager)e).getGrowingAge() == 0) {
                this.mate = (EntityVillager)e;
                this.matingTime = 300;
                this.villager.setMating(true);
            }
        }
    }

    private void updateMating() {
        if (this.isMating()) {
            --this.matingTime;
            this.villager.getLookHelper().setLookPositionWithEntity((Entity)this.mate, 10.0f, 30.0f);
            if (this.villager.getDistanceSqToEntity((Entity)this.mate) > 2.25) {
                this.villager.getNavigator().tryMoveToEntityLiving((Entity)this.mate, 0.25);
            } else if (this.matingTime == 0 && this.mate.isMating()) {
                this.giveBirth();
                this.resetMating();
            }
            if (this.villager.getRNG().nextInt(35) == 0) {
                this.villager.worldObj.setEntityState((Entity)this.villager, (byte)12);
            }
        }
    }

    private boolean areSufficientDoors() {
        return this.village != null ? this.village.getNumVillagers() < this.village.getNumVillageDoors() : false;
    }

    private void resetMating() {
        this.villager.setMating(false);
        this.mate = null;
    }

    private void giveBirth() {
        EntityVillager baby = this.villager.createChild((EntityAgeable)this.mate);
        this.mate.setGrowingAge(6000);
        this.villager.setGrowingAge(6000);
        baby.setGrowingAge(-24000);
        baby.setLocationAndAngles(this.villager.posX, this.villager.posY, this.villager.posZ, 0.0f, 0.0f);
        this.villager.worldObj.spawnEntityInWorld((Entity)baby);
        this.villager.worldObj.setEntityState((Entity)baby, (byte)12);
    }

    public void onUpdate() {
        this.updateMating();
    }

    public void init(Entity entity, World world) {
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.setTag(SAVE_KEY, (NBTBase)this.data);
        compound.setInteger("desiredMask", this.desiredMask);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.data = compound.hasKey(SAVE_KEY) ? compound.getCompoundTag(SAVE_KEY) : new NBTTagCompound();
        this.desiredMask = compound.getInteger("desiredMask");
    }

    private static final void addTreasureTrade(ItemTreasure.Treasures treasure, TradeHandler.EnumVillager villager, ItemStack required, ItemStack output) {
        treasureVillager.put(treasure, villager != null ? Integer.valueOf(villager.ordinal()) : null);
        treasureTrades.put(treasure, new MerchantRecipe(new ItemStack(ZSSItems.treasure, 1, treasure.ordinal()), required, output));
    }

    public static void initTrades() {
        ZSSVillagerInfo.addTreasureTrade(ItemTreasure.Treasures.EVIL_CRYSTAL, TradeHandler.EnumVillager.PRIEST, new ItemStack(ZSSItems.arrowLight, 16), new ItemStack(ZSSItems.crystalSpirit));
    }
}

