/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import zeldaswordskills.entity.ai.IPowerAttacker;

public class EntityAIPowerAttack
extends EntityAIBase {
    private final EntityLiving attacker;
    private final IPowerAttacker powerAttacker;
    private EntityLivingBase target;
    private double range;
    private double rangeSq;
    private int attackTimer;
    private int chargeTimer;

    public <T extends EntityLiving> EntityAIPowerAttack(T attacker, double range) {
        this.attacker = attacker;
        this.powerAttacker = (IPowerAttacker)attacker;
        this.range = range;
        this.rangeSq = range * range;
        this.setMutexBits(0);
    }

    public boolean shouldExecute() {
        this.target = this.attacker.getAttackTarget();
        if (this.attacker.attackTime > 0) {
            return false;
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
            return false;
        }
        if (this.target == null || !this.target.isEntityAlive()) {
            return false;
        }
        if (this.attacker.getDistanceSqToEntity((Entity)this.target) > this.rangeSq * 2.25) {
            return false;
        }
        return this.attacker.onGround;
    }

    public void startExecuting() {
        this.setMutexBits(3);
        this.chargeTimer = this.powerAttacker.getChargeTime();
        this.powerAttacker.beginPowerAttack();
    }

    public boolean continueExecuting() {
        return this.target != null && this.target.isEntityAlive() && this.chargeTimer > 0 && this.attacker.onGround && this.attacker.getDistanceSqToEntity((Entity)this.target) < this.rangeSq * 2.25;
    }

    public void updateTask() {
        this.attacker.getLookHelper().setLookPositionWithEntity((Entity)this.target, 30.0f, 30.0f);
        this.attacker.getMoveHelper().setMoveTo(this.target.posX, this.target.posY, this.target.posZ, 0.3333333333333333);
        if (this.chargeTimer > 0 && --this.chargeTimer == 0) {
            double width;
            double reach;
            this.attackTimer = 20 + this.attacker.worldObj.rand.nextInt(20) + this.attacker.worldObj.rand.nextInt(20);
            double d = this.attacker.getDistanceSq(this.target.posX, this.target.boundingBox.minY, this.target.posZ);
            if (d <= (reach = (this.range + (width = (double)((this.attacker.width + this.target.width) / 2.0f))) * (this.range + width)) && this.attacker.getEntitySenses().canSee((Entity)this.target)) {
                this.powerAttacker.performPowerAttack(this.target);
            } else {
                this.powerAttacker.onAttackMissed();
            }
        }
    }

    public void resetTask() {
        this.setMutexBits(0);
        this.chargeTimer = 0;
        this.target = null;
    }
}

