/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.MathHelper;
import zeldaswordskills.entity.ai.IMagicUser;

public class EntityAIRangedMagic
extends EntityAIBase {
    private final EntityLiving entity;
    private final IMagicUser caster;
    private int castingTimer;
    private final int minCastInterval;
    private final int maxCastInterval;
    private int attackTimer;
    private final double minDistance;
    private final double minDistanceSq;
    private EntityLivingBase attackTarget;
    private int unseenTimer;
    private static final int MAX_TIME_UNSEEN = 10;

    public <T extends EntityLiving> EntityAIRangedMagic(T entity, int minCastInterval, int maxCastInterval, double distance) {
        this.entity = entity;
        this.caster = (IMagicUser)entity;
        this.minCastInterval = minCastInterval;
        this.maxCastInterval = maxCastInterval;
        this.minDistance = distance;
        this.minDistanceSq = distance * distance;
        this.setMutexBits(15);
    }

    public void interruptCasting() {
        this.resetTask();
    }

    public boolean continueExecuting() {
        if (this.attackTarget == null) {
            return false;
        }
        if (this.castingTimer < 1) {
            return false;
        }
        if (!this.entity.getEntitySenses().canSee((Entity)this.attackTarget) && ++this.unseenTimer > 10) {
            this.unseenTimer = 0;
            return false;
        }
        if (!this.caster.canContinueCasting()) {
            return false;
        }
        return this.entity.getDistanceSq(this.attackTarget.posX, this.attackTarget.boundingBox.minY, this.attackTarget.posZ) < this.minDistanceSq;
    }

    public boolean shouldExecute() {
        EntityLivingBase target = this.entity.getAttackTarget();
        if (target == null) {
            return false;
        }
        this.attackTarget = target;
        double d = this.entity.getDistanceSq(this.attackTarget.posX, this.attackTarget.boundingBox.minY, this.attackTarget.posZ);
        boolean flag = this.entity.getEntitySenses().canSee((Entity)this.attackTarget);
        if (!flag) {
            this.interruptCasting();
            return false;
        }
        if (this.castingTimer == 0) {
            this.entity.getLookHelper().setLookPositionWithEntity((Entity)this.attackTarget, 30.0f, 30.0f);
            if (--this.attackTimer == 0) {
                if (d > this.minDistanceSq || !flag) {
                    return false;
                }
                this.castingTimer = this.caster.beginSpellCasting(this.attackTarget);
                return this.castingTimer > 0;
            }
            if (this.attackTimer < 0) {
                float f = (float)((double)MathHelper.sqrt_double((double)d) / this.minDistance);
                this.attackTimer = MathHelper.floor_float((float)(f * (float)(this.maxCastInterval - this.minCastInterval) + (float)this.minCastInterval));
            }
        }
        return false;
    }

    public void startExecuting() {
        this.entity.getNavigator().clearPathEntity();
    }

    public void resetTask() {
        this.caster.stopCasting();
        this.attackTarget = null;
        this.castingTimer = 0;
        this.unseenTimer = 0;
    }

    public void updateTask() {
        if (this.castingTimer > 0) {
            --this.castingTimer;
            this.entity.getLookHelper().setLookPositionWithEntity((Entity)this.attackTarget, 30.0f, 30.0f);
            if (this.castingTimer == 0) {
                double d = this.entity.getDistanceSq(this.attackTarget.posX, this.attackTarget.boundingBox.minY, this.attackTarget.posZ);
                float f = (float)((double)MathHelper.sqrt_double((double)d) / this.minDistance);
                float f1 = MathHelper.clamp_float((float)f, (float)0.1f, (float)1.0f);
                this.caster.castRangedSpell(this.attackTarget, f1);
                this.attackTimer = MathHelper.floor_float((float)(f * (float)(this.maxCastInterval - this.minCastInterval) + (float)this.minCastInterval));
            }
        }
    }
}

