/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.ai;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import zeldaswordskills.entity.player.ZSSPlayerSkills;

public class EntityAITeleport
extends EntityAIBase {
    public final EntityCreature entity;
    public final double range;
    public final double rangeSq;
    public final int minTeleportDelay;
    protected int teleportDelay;
    protected int delayTimer;
    protected int triggerTimer;
    public final boolean isGrounded;
    public final boolean randomTele;
    public final boolean approachTele;
    public final boolean fleeTele;
    public final boolean hurtTele;
    protected AxisAlignedBB teleBounds;
    protected boolean isTeleporting;

    public EntityAITeleport(EntityCreature entity, double teleRange, int delay, boolean grounded, boolean random, boolean approach, boolean flee, boolean hurt) {
        this.entity = entity;
        this.range = teleRange;
        this.rangeSq = teleRange * teleRange;
        this.minTeleportDelay = delay;
        this.isGrounded = grounded;
        this.randomTele = random;
        this.approachTele = approach;
        this.fleeTele = flee;
        this.hurtTele = hurt;
        this.setMutexBits(8);
    }

    public AxisAlignedBB getTeleBounds() {
        return this.teleBounds;
    }

    public void setTeleBounds(AxisAlignedBB newBounds) {
        this.teleBounds = newBounds;
    }

    public void scheduleNextTeleport(int ticks) {
        this.triggerTimer = this.triggerTimer > 0 ? Math.min(this.triggerTimer, Math.max(0, ticks)) : Math.max(0, ticks);
    }

    public boolean invalidateBounds(double rangeSq) {
        double z;
        double y;
        double x;
        if (this.teleBounds != null && this.entity.getDistanceSq(x = this.teleBounds.minX + (this.teleBounds.maxX - this.teleBounds.minX) / 2.0, y = this.teleBounds.minY + (this.teleBounds.maxY - this.teleBounds.minY) / 2.0, z = this.teleBounds.minZ + (this.teleBounds.maxZ - this.teleBounds.minZ) / 2.0) > rangeSq) {
            this.setTeleBounds(null);
            return false;
        }
        return true;
    }

    public void resetTask() {
        this.delayTimer = 0;
        this.triggerTimer = 0;
        this.isTeleporting = false;
    }

    public boolean shouldExecute() {
        if (this.isTeleporting) {
            return false;
        }
        if (this.randomTele) {
            return this.entity.isEntityAlive();
        }
        return this.entity.getAttackTarget() != null;
    }

    public void updateTask() {
        boolean flag = false;
        EntityLivingBase target = this.entity.getAttackTarget();
        ++this.delayTimer;
        if (this.triggerTimer > 0 && --this.triggerTimer == 0) {
            flag = true;
        } else if (this.randomTele && this.delayTimer > this.teleportDelay) {
            flag = true;
        } else if (this.fleeTele && this.delayTimer > this.teleportDelay / 2 && target != null && this.entity.getDistanceSqToEntity((Entity)target) < this.range) {
            flag = true;
        } else if (this.hurtTele && this.entity.hurtResistantTime > 10 && this.delayTimer > this.entity.hurtResistantTime) {
            flag = true;
        } else if (this.approachTele && target != null && this.entity.getDistanceSqToEntity((Entity)target) > this.rangeSq && (this.teleBounds == null || this.teleBounds.isVecInside(Vec3.createVectorHelper((double)target.posX, (double)target.posY, (double)target.posZ))) && !this.entity.worldObj.isRemote) {
            this.isTeleporting = true;
            for (int i = 0; i < 64 && !EntityAITeleport.teleportToEntity(this.entity.worldObj, (EntityLivingBase)this.entity, (Entity)target); ++i) {
            }
        }
        if (flag && !this.entity.worldObj.isRemote) {
            this.teleportRandomly();
        }
    }

    public boolean teleportRandomly() {
        this.isTeleporting = true;
        for (int i = 0; i < 64; ++i) {
            if (!EntityAITeleport.teleportRandomly(this.entity.worldObj, (EntityLivingBase)this.entity, this.range, this.teleBounds, this.isGrounded)) continue;
            return true;
        }
        return false;
    }

    public boolean canTeleport() {
        return !this.isTeleporting && this.delayTimer > this.teleportDelay;
    }

    public boolean isTeleporting() {
        return this.isTeleporting;
    }

    public void setTeleporting() {
        this.isTeleporting = true;
    }

    public void onPostTeleport(double originX, double originY, double originZ) {
        this.teleportDelay = this.minTeleportDelay + this.entity.worldObj.rand.nextInt(this.minTeleportDelay * 2) - this.entity.worldObj.rand.nextInt(this.minTeleportDelay / 2 + 1);
        this.delayTimer = 0;
        this.triggerTimer = 0;
        this.isTeleporting = false;
    }

    public static boolean teleportRandomly(World world, EntityLivingBase entity, double range) {
        return EntityAITeleport.teleportRandomly(world, entity, range, null, true);
    }

    public static boolean teleportRandomly(World world, EntityLivingBase entity, double range, AxisAlignedBB restriction, boolean grounded) {
        int rangeY = (int)range;
        if (range < 1.0 || rangeY < 1) {
            return false;
        }
        double x = entity.posX + (world.rand.nextDouble() - 0.5) * range;
        double y = entity.posY + (double)(world.rand.nextInt(rangeY) - rangeY / 2);
        double z = entity.posZ + (world.rand.nextDouble() - 0.5) * range;
        return EntityAITeleport.teleportTo(world, entity, x, y, z, restriction, grounded, true);
    }

    public static boolean teleportToEntity(World world, EntityLivingBase entity, Entity target) {
        return EntityAITeleport.teleportToEntity(world, entity, target, null, true);
    }

    public static boolean teleportToEntity(World world, EntityLivingBase entity, Entity target, AxisAlignedBB restriction, boolean grounded) {
        Vec3 vec3 = Vec3.createVectorHelper((double)(entity.posX - target.posX), (double)(entity.boundingBox.minY + (double)(entity.height / 2.0f) - target.posY + (double)target.getEyeHeight()), (double)(entity.posZ - target.posZ));
        vec3 = vec3.normalize();
        double d0 = 16.0;
        double x = entity.posX + (world.rand.nextDouble() - 0.5) * 8.0 - vec3.xCoord * d0;
        double y = entity.posY + (double)(world.rand.nextInt(16) - 8) - vec3.yCoord * d0;
        double z = entity.posZ + (world.rand.nextDouble() - 0.5) * 8.0 - vec3.zCoord * d0;
        return EntityAITeleport.teleportTo(world, entity, x, y, z, restriction, grounded, true);
    }

    public static boolean teleportTo(World world, EntityLivingBase entity, double x, double y, double z) {
        return EntityAITeleport.teleportTo(world, entity, x, y, z, null, true, true);
    }

    public static boolean teleportTo(World world, EntityLivingBase entity, double x, double y, double z, AxisAlignedBB restriction, boolean grounded, boolean noLiquid) {
        int k;
        int j;
        EnderTeleportEvent event = new EnderTeleportEvent(entity, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = entity.posX;
        double d4 = entity.posY;
        double d5 = entity.posZ;
        entity.posX = event.targetX;
        entity.posY = event.targetY;
        entity.posZ = event.targetZ;
        boolean flag = false;
        int i = MathHelper.floor_double((double)entity.posX);
        if (entity.worldObj.blockExists(i, j = MathHelper.floor_double((double)entity.posY), k = MathHelper.floor_double((double)entity.posZ))) {
            boolean foundSolidBlock;
            boolean bl = foundSolidBlock = !grounded;
            if (grounded) {
                while (!foundSolidBlock && j > 0) {
                    Block block = entity.worldObj.getBlock(i, j - 1, k);
                    if (block.getMaterial().blocksMovement()) {
                        foundSolidBlock = true;
                        continue;
                    }
                    entity.posY -= 1.0;
                    --j;
                }
            }
            if (foundSolidBlock) {
                entity.setPosition(entity.posX, entity.posY, entity.posZ);
                if (restriction != null && !restriction.isVecInside(Vec3.createVectorHelper((double)entity.posX, (double)entity.posY, (double)entity.posZ))) {
                    flag = false;
                } else if (!(!world.getCollidingBoundingBoxes((Entity)entity, entity.boundingBox).isEmpty() || noLiquid && world.isAnyLiquid(entity.boundingBox))) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.setPosition(d3, d4, d5);
            return false;
        }
        if (entity instanceof EntityPlayer) {
            entity.setPositionAndUpdate(entity.posX, entity.posY, entity.posZ);
        }
        for (int l = 0; l < 128; ++l) {
            double d6 = (double)l / 127.0;
            float f = (world.rand.nextFloat() - 0.5f) * 0.2f;
            float f1 = (world.rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (world.rand.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (entity.posX - d3) * d6 + (world.rand.nextDouble() - 0.5) * (double)entity.width * 2.0;
            double d8 = d4 + (entity.posY - d4) * d6 + world.rand.nextDouble() * (double)entity.height;
            double d9 = d5 + (entity.posZ - d5) * d6 + (world.rand.nextDouble() - 0.5) * (double)entity.width * 2.0;
            entity.worldObj.spawnParticle("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        entity.worldObj.playSoundEffect(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        entity.playSound("mob.endermen.portal", 1.0f, 1.0f);
        MinecraftForge.EVENT_BUS.post((Event)new PostEnderTeleport(entity, d3, d4, d5, 0.0f));
        return true;
    }

    public static void disruptTargeting(EntityLivingBase entity) {
        if (entity.worldObj instanceof WorldServer) {
            Set players = ((WorldServer)entity.worldObj).getEntityTracker().getTrackingPlayers((Entity)entity);
            for (EntityPlayer player : players) {
                ZSSPlayerSkills skills = ZSSPlayerSkills.get(player);
                if (skills.getTargetingSkill() == null || skills.getTargetingSkill().getCurrentTarget() != entity) continue;
                skills.getTargetingSkill().setCurrentTarget(player, null);
            }
        }
    }

    public static class PostEnderTeleport
    extends EnderTeleportEvent {
        public PostEnderTeleport(EntityLivingBase entity, double originX, double originY, double originZ, float damage) {
            super(entity, originX, originY, originZ, damage);
        }
    }
}

