/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.mobs.EntityDarknut;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.skills.SkillBase;

public class EntityBlackKnight
extends EntityDarknut
implements IBossDisplayData {
    public EntityBlackKnight(World world) {
        super(world);
        this.setSize(1.2f, 3.6f);
        this.experienceValue = 50;
        this.func_110163_bv();
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.setArmorDamage(60.0f);
        ZSSEntityInfo.get((EntityLivingBase)this).applyBuff(Buff.RESIST_STUN, Integer.MAX_VALUE, 100);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(300.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(9.0);
        this.setWearingCape((byte)120);
    }

    protected boolean canDespawn() {
        return false;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public EntityBlackKnight setType(int type) {
        return this;
    }

    @Override
    public void addRandomArmor() {
        super.addRandomArmor();
        this.setCurrentItemOrArmor(4, new ItemStack((Item)Items.chainmail_helmet));
        this.setCurrentItemOrArmor(2, new ItemStack((Item)Items.chainmail_leggings));
        this.setCurrentItemOrArmor(1, new ItemStack((Item)Items.chainmail_boots));
        ItemStack sword = this.getHeldItem();
        if (sword != null) {
            switch (this.worldObj.difficultySetting) {
                case NORMAL: {
                    sword.addEnchantment(Enchantment.sharpness, 2);
                    break;
                }
                case HARD: {
                    sword.addEnchantment(Enchantment.sharpness, 4);
                    sword.addEnchantment(Enchantment.fireAspect, 1);
                }
            }
        }
    }

    @Override
    protected void dropFewItems(boolean recentlyHit, int lootingLevel) {
        super.dropFewItems(recentlyHit, lootingLevel);
        this.entityDropItem(new ItemStack(ZSSItems.skillOrb, 1, (int)SkillBase.bonusHeart.getId()), 0.0f);
    }

    @Override
    public boolean isLightArrowFatal() {
        return false;
    }

    @Override
    public float getLightArrowDamage(float amount) {
        return amount * 4.0f;
    }

    @Override
    public float getOffensiveModifier(EntityLivingBase entity, ItemStack stack) {
        return super.getOffensiveModifier(entity, stack) - 0.2f;
    }

    @Override
    public float getDefensiveModifier(EntityLivingBase entity, ItemStack stack) {
        return super.getDefensiveModifier(entity, stack) + 0.2f;
    }

    @Override
    protected float getDamageArmorAmount() {
        return this.damageDarknutArmor(Math.min(this.getArmorDamage(), 20.0f));
    }
}

