/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.particle.EntityBreakingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.damage.IDamageSourceStun;
import zeldaswordskills.api.entity.IEntityBombEater;
import zeldaswordskills.api.entity.IEntityBombIngestible;
import zeldaswordskills.api.entity.IEntityLootable;
import zeldaswordskills.entity.IEntityVariant;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.BiomeType;
import zeldaswordskills.util.WorldUtils;

public class EntityChu
extends EntityLiving
implements IMob,
IEntityBombEater,
IEntityLootable,
IEntityVariant {
    private static final int CHU_SIZE_INDEX = 16;
    private static final int CHU_TYPE_INDEX = 17;
    private static final int SHOCK_INDEX = 18;
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private int slimeJumpDelay;
    private int timesMerged;

    public static String[] getDefaultBiomes() {
        ArrayList biomes = Lists.newArrayList((Object[])new BiomeType[]{BiomeType.BEACH, BiomeType.MOUNTAIN});
        for (ChuType type : ChuType.values()) {
            biomes.add(type.favoredBiome);
            biomes.add(type.secondBiome);
        }
        return BiomeType.getBiomeArray(null, biomes.toArray(new BiomeType[biomes.size()]));
    }

    public EntityChu(World world) {
        super(world);
        this.yOffset = 0.0f;
        this.slimeJumpDelay = this.rand.nextInt(20) + 10;
        this.setType(ChuType.RED);
        this.setSize(1 << this.rand.nextInt(3));
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)1);
        this.dataWatcher.addObject(17, (Object)((byte)ChuType.RED.ordinal()));
        this.dataWatcher.addObject(18, (Object)0);
    }

    protected EntityChu createInstance() {
        return new EntityChu(this.worldObj);
    }

    public ChuType getType() {
        return ChuType.values()[this.dataWatcher.getWatchableObjectByte(17)];
    }

    public void setType(ChuType type) {
        this.dataWatcher.updateObject(17, (Object)((byte)type.ordinal()));
        this.applyTypeTraits();
    }

    @Override
    public EntityChu setType(int type) {
        this.setType(ChuType.values()[type % ChuType.values().length]);
        return this;
    }

    private void setTypeOnSpawn() {
        if (Config.areMobVariantsAllowed() && this.rand.nextFloat() < Config.getMobVariantChance()) {
            this.setType(this.rand.nextInt(ChuType.values().length));
        } else {
            BiomeGenBase biome = this.worldObj.getBiomeGenForCoords(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posZ));
            BiomeType biomeType = BiomeType.getBiomeTypeFor(biome);
            for (ChuType t : ChuType.values()) {
                if (t.favoredBiome != biomeType && t.secondBiome != biomeType) continue;
                this.setType(t);
                return;
            }
        }
    }

    private void applyTypeTraits() {
        ZSSEntityInfo info = ZSSEntityInfo.get((EntityLivingBase)this);
        info.removeAllBuffs();
        switch (this.getType()) {
            case RED: {
                info.applyBuff(Buff.RESIST_FIRE, Integer.MAX_VALUE, 75);
                break;
            }
            case BLUE: {
                info.applyBuff(Buff.RESIST_MAGIC, Integer.MAX_VALUE, 75);
                info.applyBuff(Buff.RESIST_COLD, Integer.MAX_VALUE, 100);
                info.applyBuff(Buff.RESIST_SHOCK, Integer.MAX_VALUE, 50);
                break;
            }
            case YELLOW: {
                info.applyBuff(Buff.RESIST_SHOCK, Integer.MAX_VALUE, 100);
                break;
            }
        }
    }

    protected boolean canChuTypeShock() {
        return this.getType() == ChuType.YELLOW || this.getType() == ChuType.BLUE && this.rand.nextInt(80) == 0;
    }

    public int getShockTime() {
        return this.dataWatcher.getWatchableObjectInt(18);
    }

    public void setShockTime(int time) {
        this.dataWatcher.updateObject(18, (Object)time);
    }

    protected int getMaxStunTime() {
        return this.getSize() * this.worldObj.difficultySetting.getDifficultyId() * 10;
    }

    protected int getShockInterval() {
        return this.getType() == ChuType.YELLOW ? 160 : 320;
    }

    public int getSize() {
        return this.dataWatcher.getWatchableObjectByte(16);
    }

    protected void setSize(int size) {
        this.dataWatcher.updateObject(16, (Object)((byte)size));
        this.setSize(0.6f * (float)size, 0.6f * (float)size);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)((size + 1) * (size + 1)));
        this.setHealth(this.getMaxHealth());
        this.experienceValue = size + (this.getType().ordinal() + 1);
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    protected void fall(float f) {
    }

    public int getTotalArmorValue() {
        return this.getSize() + this.getType().ordinal() * 2;
    }

    protected void dropFewItems(boolean recentlyHit, int looting) {
        if (this.getSize() > 1) {
            int k = this.rand.nextInt(4) - 2;
            if (looting > 0) {
                k += this.rand.nextInt(looting + 1);
            }
            for (int l = 0; l < k; ++l) {
                this.entityDropItem(new ItemStack(ZSSItems.jellyChu, 1, this.getType().ordinal()), 0.0f);
            }
        }
    }

    protected void dropRareDrop(int rarity) {
        switch (rarity) {
            case 1: {
                this.entityDropItem(new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.JELLY_BLOB.ordinal()), 0.0f);
                break;
            }
            default: {
                this.entityDropItem(new ItemStack(this.rand.nextInt(3) == 1 ? Items.emerald : ZSSItems.smallHeart), 0.0f);
            }
        }
    }

    @Override
    public float getLootableChance(EntityPlayer player, IWhipBlock.WhipType whip) {
        return 0.2f;
    }

    @Override
    public ItemStack getEntityLoot(EntityPlayer player, IWhipBlock.WhipType whip) {
        if (this.rand.nextFloat() < 0.1f * (float)(1 + whip.ordinal())) {
            return new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.JELLY_BLOB.ordinal());
        }
        return new ItemStack(ZSSItems.jellyChu, 1, this.getType().ordinal());
    }

    @Override
    public boolean onLootStolen(EntityPlayer player, boolean wasItemStolen) {
        return true;
    }

    @Override
    public boolean isHurtOnTheft(EntityPlayer player, IWhipBlock.WhipType whip) {
        return Config.getHurtOnSteal();
    }

    protected String getHurtSound() {
        return "mob.slime." + (this.getSize() > 1 ? "big" : "small");
    }

    protected String getDeathSound() {
        return "mob.slime." + (this.getSize() > 1 ? "big" : "small");
    }

    protected float getSoundVolume() {
        return 0.4f * (float)this.getSize();
    }

    public int getVerticalFaceSpeed() {
        return 0;
    }

    protected boolean makesSoundOnJump() {
        return this.getSize() > 0;
    }

    protected String getJumpSound() {
        return "mob.slime." + (this.getSize() > 1 ? "big" : "small");
    }

    protected boolean makesSoundOnLand() {
        return this.getSize() > 1;
    }

    public boolean getCanSpawnHere() {
        if (this.worldObj.getWorldInfo().getTerrainType().handleSlimeSpawnReduction(this.rand, this.worldObj)) {
            return false;
        }
        if (this.worldObj.difficultySetting != EnumDifficulty.PEACEFUL) {
            if (this.posY > 50.0 && this.rand.nextFloat() < 0.5f && this.rand.nextFloat() < this.worldObj.getCurrentMoonPhaseFactor() && this.worldObj.getBlockLightValue(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ)) <= this.rand.nextInt(8)) {
                return super.getCanSpawnHere();
            }
            Chunk chunk = this.worldObj.getChunkFromBlockCoords(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posZ));
            if (this.rand.nextInt(10) == 0 && chunk.getRandomWithSeed(432191789L).nextInt(10) == 0 && this.posY < 50.0) {
                return super.getCanSpawnHere();
            }
        }
        return false;
    }

    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (source == DamageSource.inWall) {
            return false;
        }
        if (this.getShockTime() > 0) {
            if (source instanceof EntityDamageSourceIndirect) {
                if (source.isMagicDamage()) {
                    return super.attackEntityFrom(source, amount);
                }
                if (source.isExplosion()) {
                    ZSSEntityInfo.get((EntityLivingBase)this).stun(20 + this.rand.nextInt((int)(amount * 5.0f) + 1));
                    this.setShockTime(0);
                } else if (source instanceof IDamageSourceStun) {
                    this.setShockTime(0);
                }
            } else if (source instanceof EntityDamageSource && source.getEntity() instanceof EntityPlayer && !source.damageType.equals("thorns")) {
                source.getEntity().attackEntityFrom(this.getDamageSource(), this.getDamage());
                this.worldObj.playSoundAtEntity((Entity)this, "zeldaswordskills:shock", 1.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 1.0f));
            }
            return false;
        }
        return super.attackEntityFrom(source, amount);
    }

    protected float getDamage() {
        return this.getSize() + this.getType().ordinal();
    }

    private DamageSource getDamageSource() {
        if (this.getShockTime() > 0) {
            return new DamageUtils.DamageSourceShock("shock", (Entity)this, this.getMaxStunTime(), this.getDamage());
        }
        switch (this.getType()) {
            case BLUE: {
                return new DamageUtils.DamageSourceIce("mob", (Entity)this, 50, this.getSize() > 2 ? 1 : 0);
            }
        }
        return new EntityDamageSource("mob", (Entity)this);
    }

    public void onCollideWithPlayer(EntityPlayer player) {
        if (this.attackTime > 0) {
            return;
        }
        double d = 0.36 * (double)(this.getSize() * this.getSize());
        if (this.canEntityBeSeen((Entity)player) && this.getDistanceSqToEntity((Entity)player) < d && player.attackEntityFrom(this.getDamageSource(), this.getDamage())) {
            int t;
            this.attackTime = 20;
            this.playSound("mob.slime.attack", 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            if (this.rand.nextFloat() < 0.25f * (float)this.getSize()) {
                this.applySecondaryEffects(player);
            }
            if ((t = this.getShockTime()) > 0) {
                this.setShockTime(Math.max(0, t - this.rand.nextInt(100) - 50));
            }
        }
    }

    private void applySecondaryEffects(EntityPlayer player) {
        switch (this.getType()) {
            case GREEN: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.ATTACK_DOWN, 200, 50);
                break;
            }
            case BLUE: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.WEAKNESS_COLD, 200, 50);
                break;
            }
        }
    }

    public void onUpdate() {
        int time;
        if (!this.worldObj.isRemote && this.worldObj.difficultySetting == EnumDifficulty.PEACEFUL && this.getSize() > 0) {
            this.isDead = true;
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        boolean flag = this.onGround;
        super.onUpdate();
        if (this.onGround && !flag) {
            if (this.worldObj.isRemote) {
                this.spawnParticlesOnLanding();
                if (this.makesSoundOnLand()) {
                    this.playSound(this.getJumpSound(), this.getSoundVolume(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) / 0.8f);
                }
            }
            this.squishAmount = -0.5f;
        } else if (!this.onGround && flag) {
            this.squishAmount = 1.0f;
        }
        this.alterSquishAmount();
        if (this.worldObj.isRemote) {
            int i = this.getSize();
            this.setSize(0.6f * (float)i, 0.6f * (float)i);
        }
        if ((time = this.getShockTime()) > 0) {
            this.setShockTime(time - 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticlesOnLanding() {
        int i = this.getSize();
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        switch (this.getType()) {
            case RED: {
                r = 0.65f;
                g = 0.25f;
                b = 0.3f;
                break;
            }
            case BLUE: {
                r = 0.25f;
                g = 0.4f;
                b = 0.75f;
                break;
            }
            case YELLOW: {
                g = 0.65f;
                b = 0.0f;
                break;
            }
        }
        for (int j = 0; j < i * 8; ++j) {
            float f3;
            float f = this.rand.nextFloat() * (float)Math.PI * 2.0f;
            float f1 = this.rand.nextFloat() * 0.5f + 0.5f;
            float f2 = MathHelper.sin((float)f) * (float)i * 0.5f * f1;
            EntityBreakingFX particle = new EntityBreakingFX(this.worldObj, this.posX + (double)f2, this.boundingBox.minY, this.posZ + (double)(f3 = MathHelper.cos((float)f) * (float)i * 0.5f * f1), Items.slime_ball);
            if (particle == null) continue;
            particle.setRBGColorF(r, g, b);
            WorldUtils.spawnWorldParticles(this.worldObj, (EntityFX)particle);
        }
    }

    protected void updateEntityActionState() {
        this.despawnEntity();
        EntityPlayer player = this.worldObj.getClosestVulnerablePlayerToEntity((Entity)this, 16.0);
        if (player != null) {
            this.faceEntity((Entity)player, 10.0f, 20.0f);
        }
        if (this.onGround && this.slimeJumpDelay-- <= 0) {
            this.slimeJumpDelay = this.getJumpDelay();
            if (player != null) {
                this.slimeJumpDelay /= 3;
            }
            this.isJumping = true;
            if (this.makesSoundOnJump()) {
                this.playSound(this.getJumpSound(), this.getSoundVolume(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.moveStrafing = 1.0f - this.rand.nextFloat() * 2.0f;
            this.moveForward = 1 * this.getSize();
        } else {
            this.isJumping = false;
            if (this.onGround) {
                this.moveForward = 0.0f;
                this.moveStrafing = 0.0f;
            }
        }
        if (this.canChuTypeShock() && this.getShockTime() == 0 && !ZSSEntityInfo.get((EntityLivingBase)this).isBuffActive(Buff.STUN) && player != null && (this.recentlyHit > 0 || this.rand.nextInt(this.getShockInterval()) == 0)) {
            this.setShockTime(this.rand.nextInt(this.getSize() * 50) + this.worldObj.difficultySetting.getDifficultyId() * (this.rand.nextInt(20) + 10));
        }
        if (this.getShockTime() % 8 > 5 && this.rand.nextInt(4) == 0) {
            this.worldObj.playSoundAtEntity((Entity)this, "zeldaswordskills:shock", this.getSoundVolume(), 1.0f / (this.rand.nextFloat() * 0.4f + 1.0f));
        }
        if (this.onGround && this.timesMerged < 4) {
            this.attemptMerge();
        }
    }

    public void setDead() {
        int i = this.getSize();
        if (!this.worldObj.isRemote && i > 1 && this.getHealth() <= 0.0f) {
            int j = 2 + this.rand.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                EntityChu chu = this.createInstance();
                chu.setSize(i / 2);
                chu.setType(this.getType());
                chu.setLocationAndAngles(this.posX + (double)f, this.posY + 0.5, this.posZ + (double)f1, this.rand.nextFloat() * 360.0f, 0.0f);
                chu.timesMerged = this.timesMerged;
                this.worldObj.spawnEntityInWorld((Entity)chu);
            }
        }
        super.setDead();
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.rand.nextInt(20) + 10;
    }

    private void attemptMerge() {
        int i = this.getSize();
        if (!this.worldObj.isRemote && i < 3 && this.getHealth() < this.getMaxHealth() / 2.0f && this.rand.nextInt(16) == 0) {
            List list = this.worldObj.getEntitiesWithinAABB(EntityChu.class, this.boundingBox.expand(2.0, 1.0, 2.0));
            for (EntityChu chu : list) {
                if (chu == this || chu.getSize() != this.getSize() || !(chu.getHealth() < chu.getMaxHealth() / 2.0f)) continue;
                this.worldObj.playSoundAtEntity((Entity)this, "zeldaswordskills:chu_merge", 1.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 1.0f));
                EntityChu newChu = this.createInstance();
                newChu.setSize(i * 2);
                newChu.setType(this.getType().ordinal() < chu.getType().ordinal() ? chu.getType() : this.getType());
                newChu.setLocationAndAngles((this.posX + chu.posX) / 2.0, this.posY + 0.5, (this.posZ + chu.posZ) / 2.0, this.rand.nextFloat() * 360.0f, 0.0f);
                newChu.timesMerged = this.rand.nextInt(4) + 1 + this.timesMerged;
                this.worldObj.spawnEntityInWorld((Entity)newChu);
                chu.isDead = true;
                this.isDead = true;
                break;
            }
        }
    }

    @Override
    public Event.Result ingestBomb(IEntityBombIngestible bomb) {
        this.worldObj.playSoundAtEntity((Entity)this, "zeldaswordskills:chu_merge", 1.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 1.0f));
        return Event.Result.DEFAULT;
    }

    @Override
    public boolean onBombIndigestion(IEntityBombIngestible bomb) {
        return true;
    }

    @Override
    public boolean doesIngestedBombExplode(IEntityBombIngestible bomb) {
        return true;
    }

    @Override
    public boolean isIngestedBombFatal(IEntityBombIngestible bomb) {
        return this.getSize() < 4;
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData data) {
        data = super.onSpawnWithEgg(data);
        this.setTypeOnSpawn();
        return data;
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setInteger("Size", this.getSize() - 1);
        compound.setInteger("ChuType", this.getType().ordinal());
        compound.setInteger("timesMerged", this.timesMerged);
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.setSize(compound.getInteger("Size") + 1);
        this.dataWatcher.updateObject(17, (Object)((byte)compound.getInteger("ChuType")));
        this.timesMerged = compound.getInteger("timesMerged");
    }

    public static enum ChuType {
        RED(BiomeType.RIVER, BiomeType.FIERY),
        GREEN(BiomeType.PLAINS, BiomeType.FOREST),
        BLUE(BiomeType.TAIGA, BiomeType.COLD),
        YELLOW(BiomeType.ARID, BiomeType.JUNGLE);

        public final BiomeType favoredBiome;
        public final BiomeType secondBiome;

        private ChuType(BiomeType favoredBiome, BiomeType secondBiome) {
            this.favoredBiome = favoredBiome;
            this.secondBiome = secondBiome;
        }
    }
}

