/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.ai.EntityAIDynamicRangedAction;
import zeldaswordskills.api.entity.ai.EntityAction;
import zeldaswordskills.api.entity.ai.IEntityDynamicAI;
import zeldaswordskills.entity.mobs.EntityDekuBaba;
import zeldaswordskills.entity.mobs.EntityDekuBase;
import zeldaswordskills.entity.projectile.EntityMagicSpell;
import zeldaswordskills.util.BiomeType;
import zeldaswordskills.util.WorldUtils;

public class EntityDekuFire
extends EntityDekuBaba
implements IEntityAdditionalSpawnData,
IRangedAttackMob {
    public static final EntityAction ACTION_SPIT;
    public static final int GLAND_DURATION = 20;
    protected static final byte GLAND_FLAG;
    private boolean has_gland = true;
    public int gland_timer;

    public static String[] getDefaultBiomes() {
        return BiomeType.getBiomeArray(new String[]{"hell"}, BiomeType.FIERY, BiomeType.JUNGLE, BiomeType.PLAINS);
    }

    public EntityDekuFire(World world) {
        super(world);
        this.isImmuneToFire = true;
    }

    public boolean hasGland() {
        return this.has_gland;
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(40.0);
    }

    @Override
    protected void addAITasks() {
        super.addAITasks();
        this.tasks.addTask(2, (EntityAIBase)new EntityAIDynamicRangedAction(this, ACTION_SPIT, 4.0f, 40.0f, 20, 60, 0.0f, true).setDifficultyScaled());
    }

    @Override
    public float getActionSpeed(int action_id) {
        int i = this.getDifficultyModifier() - 2;
        if (action_id == EntityDekuFire.ACTION_SPIT.id) {
            return 0.6f + (float)i * 0.1f;
        }
        return super.getActionSpeed(action_id);
    }

    @Override
    public boolean canExecute(int action_id, IEntityDynamicAI ai) {
        if (action_id == EntityDekuFire.ACTION_SPIT.id && !this.hasGland()) {
            return false;
        }
        return super.canExecute(action_id, ai);
    }

    @Override
    public void performAction(int action_id, IEntityDynamicAI ai) {
        Entity target = this.getCurrentTarget();
        if (!this.isConfused()) {
            if (action_id == EntityDekuFire.ACTION_SPIT.id) {
                if (target instanceof EntityLivingBase) {
                    this.attackEntityWithRangedAttack((EntityLivingBase)target, 1.0f);
                }
            } else {
                super.performAction(action_id, ai);
            }
        }
    }

    public void attackEntityWithRangedAttack(EntityLivingBase target, float rangeRatio) {
        int difficulty = this.worldObj.difficultySetting.getDifficultyId();
        EntityMagicSpell spell = new EntityMagicSpell(this.worldObj, (EntityLivingBase)this, target, 0.375f + 0.125f * (float)difficulty, 14 - difficulty * 4);
        spell.setGravityVelocity(0.01f);
        float d = 1.5f;
        Vec3 vec3 = this.getLook(1.0f);
        spell.posX = this.posX + vec3.xCoord * (double)d;
        spell.posY = this.posY + (double)(this.height / 2.0f) + 0.5;
        spell.posZ = this.posZ + vec3.zCoord * (double)d;
        spell.setArea(0.4f + 0.2f * (float)difficulty);
        float damage = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
        spell.setDamage(damage);
        spell.setReflectChance(1.0f);
        spell.disableGriefing();
        spell.disableTrailingParticles();
        if (!this.worldObj.isRemote) {
            WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:spit", 0.4f, 0.7f);
            this.worldObj.spawnEntityInWorld((Entity)spell);
        }
    }

    @Override
    public boolean isAttack(int action_id) {
        return action_id == EntityDekuFire.ACTION_SPIT.id || super.isAttack(action_id);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.gland_timer != 0) {
            this.gland_timer += this.gland_timer < 0 ? 1 : -1;
            if (this.gland_timer == 0) {
                this.has_gland = false;
            }
        }
    }

    @Override
    protected float getSlashDamage(DamageSource source, float amount) {
        float damage = super.getSlashDamage(source, amount);
        if (this.has_gland && this.isSlashing(source)) {
            damage *= 0.25f;
        }
        return damage;
    }

    @Override
    protected void onProneAttack(DamageSource source, float amount) {
        if (!this.worldObj.isRemote && this.isSlashing(source)) {
            this.has_gland = false;
            this.worldObj.setEntityState((Entity)this, GLAND_FLAG);
        }
        super.onProneAttack(source, amount);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte flag) {
        if (flag == GLAND_FLAG) {
            this.gland_timer = this.rand.nextFloat() < 0.5f ? 20 : -20;
        } else {
            super.handleHealthUpdate(flag);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setBoolean("has_gland", this.has_gland);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.has_gland = compound.getBoolean("has_gland");
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.has_gland);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.has_gland = buffer.readBoolean();
    }

    static {
        byte by = EntityDekuBase.flag_index;
        EntityDekuBase.flag_index = (byte)(by + 1);
        ACTION_SPIT = new EntityAction(by, 16, 7);
        EntityDekuBaba.registerAction(ACTION_SPIT);
        byte by2 = EntityDekuBase.flag_index;
        EntityDekuBase.flag_index = (byte)(by2 + 1);
        GLAND_FLAG = by2;
    }
}

