/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import zeldaswordskills.entity.mobs.EntityDekuBase;
import zeldaswordskills.util.BiomeType;

public class EntityDekuWithered
extends EntityDekuBase {
    public static String[] getDefaultBiomes() {
        return BiomeType.getBiomeArray(new String[]{"hell"}, BiomeType.FIERY, BiomeType.ARID, BiomeType.PLAINS);
    }

    public EntityDekuWithered(World world) {
        super(world);
        this.experienceValue = 2;
    }

    protected boolean isAIEnabled() {
        return false;
    }

    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (this.isSourceFatal(source)) {
            return super.attackEntityFrom(source, this.getMaxHealth());
        }
        return super.attackEntityFrom(source, amount);
    }

    @Override
    protected boolean isSourceFatal(DamageSource source) {
        return this.isSlashing(source);
    }

    protected void updateEntityActionState() {
        this.setRotation(this.getTicksExistedOffset(-1), this.rotationPitch);
        double widthSq = this.width * 2.0f * this.width * 2.0f;
        float mod = 1.0f * (float)this.worldObj.difficultySetting.getDifficultyId();
        List entities = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, this.boundingBox.expand((double)(3.0f + mod), 0.0, (double)(3.0f + mod)));
        for (EntityLivingBase entity : entities) {
            double d1;
            double d0;
            if (entity instanceof EntityDekuBase || !entity.isEntityAlive() || !this.canEntityBeSeen((Entity)entity) || !((d0 = this.getDistanceSq(entity.posX, entity.boundingBox.minY, entity.posZ)) <= (d1 = widthSq + (double)entity.width + (double)mod))) continue;
            this.attackEntityAsMob((Entity)entity);
        }
    }
}

