/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.IEntityLootable;
import zeldaswordskills.entity.IEntityVariant;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.entity.projectile.EntityMobThrowable;
import zeldaswordskills.entity.projectile.EntityThrowingRock;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.TargetUtils;

public class EntityOctorok
extends EntityWaterMob
implements IMob,
IEntityLootable,
IEntityVariant {
    private static final int OCTOROK_TYPE_INDEX = 13;
    public float squidPitch;
    public float prevSquidPitch;
    public float squidYaw;
    public float prevSquidYaw;
    public float squidRotation;
    public float prevSquidRotation;
    public float tentacleAngle;
    public float prevTentacleAngle;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float field_70871_bB;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;

    public EntityOctorok(World world) {
        super(world);
        this.experienceValue = 5;
        this.setSize(0.95f, 0.95f);
        this.rotationVelocity = 1.0f / (this.rand.nextFloat() + 1.0f) * 0.2f;
    }

    public void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(13, (Object)((byte)(this.rand.nextInt(5) == 0 ? 1 : 0)));
    }

    public int getType() {
        return this.dataWatcher.getWatchableObjectByte(13);
    }

    @Override
    public EntityOctorok setType(int type) {
        this.dataWatcher.updateObject(13, (Object)((byte)(type % 2)));
        return this;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    public boolean canAttackClass(Class clazz) {
        return super.canAttackClass(clazz) && clazz != EntityOctorok.class;
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.isRemote && this.worldObj.difficultySetting == EnumDifficulty.PEACEFUL) {
            this.setDead();
        }
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        this.prevSquidPitch = this.squidPitch;
        this.prevSquidYaw = this.squidYaw;
        this.prevSquidRotation = this.squidRotation;
        this.prevTentacleAngle = this.tentacleAngle;
        this.squidRotation += this.rotationVelocity;
        if (this.squidRotation > (float)Math.PI * 2) {
            this.squidRotation -= (float)Math.PI * 2;
            if (this.rand.nextInt(10) == 0) {
                this.rotationVelocity = 1.0f / (this.rand.nextFloat() + 1.0f) * 0.2f;
            }
        }
        if (this.isInWater()) {
            float f;
            if (this.squidRotation < (float)Math.PI) {
                f = this.squidRotation / (float)Math.PI;
                this.tentacleAngle = MathHelper.sin((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.field_70871_bB = 1.0f;
                } else {
                    this.field_70871_bB *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.field_70871_bB *= 0.99f;
            }
            if (!this.worldObj.isRemote) {
                if (this.entityToAttack != null) {
                    TargetUtils.setEntityHeading((Entity)this, this.randomMotionVecX, this.randomMotionVecY, this.randomMotionVecZ, 0.25f, 1.0f, false);
                    this.faceEntity(this.entityToAttack, 30.0f, 120.0f);
                } else {
                    this.motionX = this.randomMotionVecX * this.randomMotionSpeed;
                    this.motionY = this.randomMotionVecY * this.randomMotionSpeed;
                    this.motionZ = this.randomMotionVecZ * this.randomMotionSpeed;
                }
            }
            this.renderYawOffset += (-((float)Math.atan2(this.motionX, this.motionZ)) * 180.0f / (float)Math.PI - this.renderYawOffset) * 0.1f;
            this.rotationYaw = this.renderYawOffset;
            this.squidYaw += (float)Math.PI * this.field_70871_bB * 1.5f;
            f = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.squidPitch += (-((float)Math.atan2(f, this.motionY)) * 180.0f / (float)Math.PI - this.squidPitch) * 0.1f;
        } else {
            this.tentacleAngle = MathHelper.abs((float)MathHelper.sin((float)this.squidRotation)) * (float)Math.PI * 0.25f;
            this.squidPitch = (float)((double)this.squidPitch + (double)(-90.0f - this.squidPitch) * 0.02);
            if (!this.worldObj.isRemote) {
                this.motionX = 0.0;
                this.motionY -= 0.08;
                this.motionY *= (double)0.98f;
                this.motionZ = 0.0;
            }
        }
    }

    public void moveEntityWithHeading(float dx, float dz) {
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
    }

    protected void updateEntityActionState() {
        float distance = 0.0f;
        ++this.entityAge;
        if (this.entityToAttack == null) {
            this.entityToAttack = this.findPlayerToAttack();
        } else if (this.entityToAttack.isEntityAlive() && this.canAttackClass(this.entityToAttack.getClass())) {
            distance = this.entityToAttack.getDistanceToEntity((Entity)this);
            if (distance > 16.0f) {
                this.entityToAttack = null;
            } else if (this.canEntityBeSeen(this.entityToAttack)) {
                this.attackEntity(this.entityToAttack, distance);
            }
        } else {
            this.entityToAttack = null;
        }
        if (this.entityAge > 100) {
            this.randomMotionVecZ = 0.0f;
            this.randomMotionVecY = 0.0f;
            this.randomMotionVecX = 0.0f;
        } else if (this.rand.nextInt(this.entityToAttack != null ? 25 : 50) == 0 || !this.inWater || this.randomMotionVecX == 0.0f && this.randomMotionVecY == 0.0f && this.randomMotionVecZ == 0.0f) {
            if (this.entityToAttack != null && distance > 5.0f) {
                this.randomMotionVecX = (float)(this.entityToAttack.posX - this.posX) * 0.015f;
                this.randomMotionVecY = (float)(1.0 + this.entityToAttack.posY - this.posY) * 0.015f;
                this.randomMotionVecZ = (float)(this.entityToAttack.posZ - this.posZ) * 0.015f;
            } else {
                float f = this.rand.nextFloat() * (float)Math.PI * 2.0f;
                this.randomMotionVecX = MathHelper.cos((float)f) * 0.2f;
                this.randomMotionVecY = -0.1f + this.rand.nextFloat() * 0.3f;
                this.randomMotionVecZ = MathHelper.sin((float)f) * 0.2f;
            }
        }
        this.despawnEntity();
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(12.0);
        this.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(0.75);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(2.0);
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean isInWater() {
        return this.worldObj.handleMaterialAcceleration(this.boundingBox.expand(0.0, (double)-0.6f, 0.0), Material.water, (Entity)this);
    }

    public boolean getCanSpawnHere() {
        return this.posY > 45.0 && this.posY < 63.0 && this.worldObj.difficultySetting != EnumDifficulty.PEACEFUL && super.getCanSpawnHere();
    }

    public int getTotalArmorValue() {
        return Math.min(super.getTotalArmorValue() + 2, 20);
    }

    protected Entity findPlayerToAttack() {
        EntityPlayer entityplayer = this.worldObj.getClosestVulnerablePlayerToEntity((Entity)this, 16.0);
        return entityplayer != null && this.canEntityBeSeen((Entity)entityplayer) ? entityplayer : null;
    }

    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (this.isEntityInvulnerable() || source.isExplosion()) {
            return false;
        }
        if (super.attackEntityFrom(source, amount)) {
            Entity entity = source.getEntity();
            if (this.riddenByEntity != entity && this.ridingEntity != entity) {
                if (entity != this) {
                    this.entityToAttack = entity;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean attackEntityAsMob(Entity entity) {
        boolean flag;
        this.attackTime = 20;
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
        int i = 0;
        if (entity instanceof EntityLivingBase) {
            f += EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
        }
        if (flag = entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                entity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                entity.setFire(j * 4);
            }
            if (entity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)this);
            }
        }
        return flag;
    }

    protected void attackEntity(Entity entity, float distance) {
        if (this.attackTime <= 0) {
            if (distance < 2.0f && entity.boundingBox.maxY > this.boundingBox.minY && entity.boundingBox.minY < this.boundingBox.maxY) {
                this.attackEntityAsMob(entity);
            } else if (this.rand.nextInt(60) == 0 && entity instanceof EntityLivingBase) {
                this.attackTime = this.rand.nextInt(20) + this.rand.nextInt(20) + 20;
                float f = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
                int difficulty = this.worldObj.difficultySetting.getDifficultyId();
                EntityMobThrowable projectile = this.getType() == 1 ? new EntityBomb(this.worldObj, (EntityLivingBase)this, (EntityLivingBase)entity, 1.0f, 14 - difficulty * 4).setType(BombType.BOMB_WATER).setFuseTime(12 - difficulty * 2).setNoGrief().setMotionFactor(0.25f).setDamage(f * 2.0f * (float)difficulty) : new EntityThrowingRock(this.worldObj, (EntityLivingBase)this, (EntityLivingBase)entity, 1.0f, 14 - difficulty * 4).setIgnoreWater().setDamage(f * (float)difficulty);
                if (!this.worldObj.isRemote) {
                    this.worldObj.spawnEntityInWorld((Entity)projectile);
                }
            }
        }
    }

    protected Item getDropItem() {
        return this.getType() > 0 || this.rand.nextFloat() < 0.5f ? Items.dye : ZSSItems.throwingRock;
    }

    protected void dropFewItems(boolean recentlyHit, int lootingLevel) {
        int j = this.rand.nextInt(2 + lootingLevel) + 1;
        for (int k = 0; k < j; ++k) {
            this.entityDropItem(new ItemStack(this.getDropItem(), 1, 0), 0.0f);
        }
    }

    protected void dropRareDrop(int rarity) {
        switch (rarity) {
            case 1: {
                this.entityDropItem(new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.TENTACLE.ordinal()), 0.0f);
                break;
            }
            default: {
                if (this.getType() == 1) {
                    this.entityDropItem(new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_WATER.ordinal()), 0.0f);
                    break;
                }
                this.entityDropItem(new ItemStack(this.rand.nextInt(3) == 0 ? Items.emerald : ZSSItems.smallHeart), 0.0f);
            }
        }
    }

    @Override
    public float getLootableChance(EntityPlayer player, IWhipBlock.WhipType whip) {
        return 0.2f;
    }

    @Override
    public ItemStack getEntityLoot(EntityPlayer player, IWhipBlock.WhipType whip) {
        if (this.rand.nextFloat() < 0.1f * (float)(1 + whip.ordinal())) {
            return new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.TENTACLE.ordinal());
        }
        if (this.getType() == 1 && this.rand.nextFloat() < 0.1f * (float)(1 + whip.ordinal())) {
            return new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_WATER.ordinal());
        }
        return new ItemStack(this.getDropItem(), 1, 0);
    }

    @Override
    public boolean onLootStolen(EntityPlayer player, boolean wasItemStolen) {
        return true;
    }

    @Override
    public boolean isHurtOnTheft(EntityPlayer player, IWhipBlock.WhipType whip) {
        return Config.getHurtOnSteal();
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setByte("octorokType", (byte)this.getType());
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        if (compound.hasKey("octorokType")) {
            this.setType(compound.getByte("octorokType"));
        }
    }
}

