/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.npc;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.INpcVillager;
import zeldaswordskills.api.entity.ISongTeacher;
import zeldaswordskills.entity.npc.EntityNpcMerchantBase;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.entity.player.quests.IQuest;
import zeldaswordskills.entity.player.quests.IQuestHandler;
import zeldaswordskills.entity.player.quests.QuestBase;
import zeldaswordskills.entity.player.quests.QuestLightArrows;
import zeldaswordskills.entity.player.quests.QuestMasterSword;
import zeldaswordskills.entity.player.quests.QuestPendants;
import zeldaswordskills.entity.player.quests.QuestZeldaTalk;
import zeldaswordskills.entity.player.quests.QuestZeldasLetter;
import zeldaswordskills.entity.player.quests.ZSSQuests;
import zeldaswordskills.item.ItemInstrument;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.PlayRecordPacket;
import zeldaswordskills.network.client.SyncQuestPacket;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class EntityNpcZelda
extends EntityNpcMerchantBase
implements INpcVillager,
IQuestHandler,
ISongTeacher {
    private static final ImmutableSet<Class<? extends IQuest>> QUEST_LIST = new ImmutableSet.Builder().add(QuestZeldaTalk.class).add(QuestPendants.class).add(QuestZeldasLetter.class).add(QuestMasterSword.class).add(QuestLightArrows.class).build();
    private static final MerchantRecipe lightArrows = new MerchantRecipe(new ItemStack(Items.emerald, 8), null, new ItemStack(ZSSItems.arrowLight));
    private int conversionTime;
    private UUID ocarinaOwnerId;
    private int[] songPos;

    public EntityNpcZelda(World world) {
        super(world);
    }

    @Override
    protected String getNameTagOnSpawn() {
        return "Princess Zelda";
    }

    protected String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return null;
    }

    protected String getDeathSound() {
        return null;
    }

    @Override
    public MerchantRecipeList getRecipes(EntityPlayer player) {
        MerchantRecipeList list = super.getRecipes(player);
        if (list != null) {
            MerchantRecipeHelper.removeTrade(list, lightArrows, false, true);
            if (ZSSQuests.get(player).hasCompleted(QuestLightArrows.class)) {
                list.add(0, (Object)new MerchantRecipe(lightArrows.getItemToBuy(), lightArrows.getSecondItemToBuy(), lightArrows.getItemToSell()));
            }
        }
        return list;
    }

    @Override
    protected void populateTradingList() {
        if (this.trades == null) {
            this.trades = new MerchantRecipeList();
        }
        this.updateTradingList();
    }

    @Override
    protected void updateTradingList() {
        if (this.trades != null && this.trades.isEmpty()) {
            this.trades.add((Object)new MerchantRecipe(new ItemStack(Items.emerald, 2), new ItemStack(Items.potato, 3)));
        }
    }

    @Override
    public void onQuestBegun(IQuest quest, EntityPlayer player) {
        if (quest instanceof QuestZeldaTalk) {
            this.onConverted(player);
        }
    }

    @Override
    public void onQuestChanged(IQuest quest, EntityPlayer player) {
    }

    @Override
    public void onQuestCompleted(IQuest quest, EntityPlayer player) {
    }

    @Override
    public boolean interact(EntityPlayer player) {
        if (!this.isEntityAlive() || player.isSneaking()) {
            return false;
        }
        if (this.getCustomer() != null) {
            if (!this.worldObj.isRemote) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.merchant.busy", new Object[0]);
            }
            return true;
        }
        if (this.conversionTime > 0) {
            return true;
        }
        ZSSQuests quests = ZSSQuests.get(player);
        ItemStack stack = player.getHeldItem();
        if (stack != null && stack.getItem() instanceof ItemInstrument && (this.worldObj.isRemote || quests.hasBegun(QuestZeldaTalk.class))) {
            return true;
        }
        if (this.worldObj.isRemote) {
            return false;
        }
        if (quests.get(QuestZeldaTalk.class) == null) {
            quests.add(new QuestZeldaTalk());
        }
        for (Class clazz : QUEST_LIST) {
            IQuest quest = quests.get(clazz);
            if (quest == null || !QuestBase.checkQuestProgress(player, quest, this, new Object[0])) continue;
            return true;
        }
        this.updateTradingList();
        this.displayTradingGuiFor(player);
        return true;
    }

    @Override
    public Event.Result canInteractConvert(EntityPlayer player, EntityVillager villager) {
        IChatComponent hint;
        ItemStack stack;
        if (villager.getClass() != EntityVillager.class || villager.isChild()) {
            return Event.Result.DEFAULT;
        }
        ZSSQuests quests = ZSSQuests.get(player);
        QuestZeldaTalk quest = (QuestZeldaTalk)quests.get(QuestZeldaTalk.class);
        if (quest == null) {
            quest = new QuestZeldaTalk();
            quests.add(quest);
        }
        if ((stack = player.getHeldItem()) != null && stack.getItem() instanceof ItemInstrument && ((ItemInstrument)stack.getItem()).getInstrument(stack) == ItemInstrument.Instrument.OCARINA_FAIRY) {
            if (player.worldObj.isRemote) {
                ZSSPlayerSongs.get((EntityPlayer)player).preventSongGui = true;
                return Event.Result.DENY;
            }
            if (quest.hasBegun(player)) {
                this.conversionTime = -1;
                return Event.Result.ALLOW;
            }
            if (quest.begin(player, new Object[0])) {
                return Event.Result.ALLOW;
            }
        }
        if (!quest.isComplete(player) && (hint = quest.getHint(player, new Object[0])) != null) {
            player.addChatMessage(hint);
            return Event.Result.DENY;
        }
        return Event.Result.DEFAULT;
    }

    @Override
    public Event.Result canLeftClickConvert(EntityPlayer player, EntityVillager villager) {
        return Event.Result.DEFAULT;
    }

    @Override
    public void onConverted(EntityPlayer player) {
        if (this.conversionTime < 0) {
            this.conversionTime = 0;
        } else {
            this.setCustomer(player);
            this.ocarinaOwnerId = player.getUniqueID();
            this.conversionTime = ZeldaSongs.songTime.getMinDuration() / 2;
            this.songPos = new int[]{MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ)};
            PacketDispatcher.sendToAllAround(new PlayRecordPacket(ZeldaSongs.songTime.getSoundString(), this.songPos[0], this.songPos[1], this.songPos[2]), (Entity)this, 64.0);
        }
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.conversionTime > 0) {
            --this.conversionTime;
            if (this.conversionTime == 0) {
                EntityPlayer player;
                if (this.songPos != null) {
                    PacketDispatcher.sendToAllAround(new PlayRecordPacket(null, this.songPos[0], this.songPos[1], this.songPos[2]), (Entity)this, 64.0);
                    this.songPos = null;
                }
                if ((player = this.getCustomer()) == null) {
                    player = this.worldObj.getClosestPlayerToEntity((Entity)this, 16.0);
                }
                if (!this.worldObj.isRemote && player != null) {
                    boolean isOwner;
                    boolean bl = isOwner = this.ocarinaOwnerId != null && player.getUniqueID().compareTo(this.ocarinaOwnerId) == 0;
                    if (player.getDistanceSqToEntity((Entity)this) < 64.0) {
                        if (isOwner) {
                            IQuest quest = ZSSQuests.get(player).get(QuestZeldaTalk.class);
                            if (quest != null && quest.canComplete(player)) {
                                quest.complete(player, true);
                                PacketDispatcher.sendTo(new SyncQuestPacket(quest), (EntityPlayerMP)player);
                                this.ocarinaOwnerId = null;
                            }
                        } else {
                            PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.zelda.ocarina.wrong_player", new Object[0]);
                        }
                    } else if (isOwner) {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.zelda.ocarina.too_far", new Object[0]);
                    }
                }
                this.setCustomer(null);
            }
        }
    }

    @Override
    public ISongTeacher.TeachingResult getTeachingResult(ItemStack stack, EntityPlayer player) {
        if (!this.isEntityAlive() || player.isSneaking()) {
            return null;
        }
        String deny = null;
        ZSSQuests quests = ZSSQuests.get(player);
        if (!quests.hasCompleted(QuestZeldaTalk.class)) {
            return null;
        }
        if (!quests.hasBegun(QuestMasterSword.class)) {
            deny = "chat.zss.npc.zelda.song.not_ready";
        } else if (!quests.hasCompleted(QuestMasterSword.class)) {
            deny = "chat.zss.npc.zelda.master_sword.hint." + this.rand.nextInt(3);
        } else if (((ItemInstrument)stack.getItem()).getInstrument(stack).getPower() < 5) {
            deny = "chat.zss.npc.zelda.song.weak";
        }
        if (deny != null) {
            if (!player.worldObj.isRemote) {
                PlayerUtils.sendTranslatedChat(player, deny, new Object[0]);
            }
            return null;
        }
        return new ISongTeacher.TeachingResult(ZeldaSongs.songTime, true, true);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setInteger("conversionTime", this.conversionTime);
        if (this.ocarinaOwnerId != null) {
            compound.setString("OcarinaOwnerId", this.ocarinaOwnerId.toString());
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.conversionTime = compound.getInteger("conversionTime");
        if (compound.hasKey("OcarinaOwnerId", 8)) {
            this.ocarinaOwnerId = UUID.fromString(compound.getString("OcarinaOwnerId"));
        }
    }
}

