/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.player;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import org.apache.commons.lang3.ArrayUtils;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.entity.player.quests.ZSSQuests;
import zeldaswordskills.handler.ZSSCombatEvents;
import zeldaswordskills.item.ItemArmorBoots;
import zeldaswordskills.item.ItemHeroBow;
import zeldaswordskills.item.ItemMask;
import zeldaswordskills.item.ItemZeldaShield;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.AttackBlockedPacket;
import zeldaswordskills.network.client.SetNockedArrowPacket;
import zeldaswordskills.network.client.SpawnNayruParticlesPacket;
import zeldaswordskills.network.client.SyncCurrentMagicPacket;
import zeldaswordskills.network.client.SyncPlayerInfoPacket;
import zeldaswordskills.network.client.SyncQuestsPacket;
import zeldaswordskills.network.server.RequestCurrentMagicPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.PlayerUtils;

public class ZSSPlayerInfo
implements IExtendedEntityProperties {
    private static final String EXT_PROP_NAME = "ZSSPlayerInfo";
    private final EntityPlayer player;
    private final ZSSPlayerSkills playerSkills;
    private final ZSSPlayerSongs playerSongs;
    private float mp;
    private float lastMp;
    public static final IAttribute maxMagic = new RangedAttribute("zss.max_magic", 50.0, 0.0, Double.MAX_VALUE).setDescription("Max Magic").setShouldWatch(true);
    private Entity lastRidden;
    private int blockTime = 0;
    private final Map<Stats, Integer> playerStats = new EnumMap<Stats, Integer>(Stats.class);
    private byte receivedGear = 0;
    private byte flags = 0;
    public static final byte IS_WEARING_BOOTS = 1;
    public static final byte IS_WEARING_HELM = 2;
    public static final byte IS_NAYRU_ACTIVE = 4;
    public static final byte MOBILITY = 8;
    private ItemStack lastBootsWorn;
    private ItemStack lastHelmWorn;
    public int hoverTime = 0;
    @Deprecated
    private Item borrowedMask = null;
    @Deprecated
    private int maskStage = 0;
    public static final int MAX_SKULLTULA_TOKENS = 100;
    private int skulltulaTokens = 0;
    private ItemStack arrowStack = null;
    public boolean hasAutoBombArrow = false;
    public int slingshotMode = 0;
    public float reduceFallAmount = 0.0f;

    public ZSSPlayerInfo(EntityPlayer player) {
        this.player = player;
        this.playerSkills = new ZSSPlayerSkills(player);
        this.playerSongs = new ZSSPlayerSongs(player);
        player.getAttributeMap().registerAttribute(maxMagic).setBaseValue(50.0);
        this.mp = this.getMaxMagic();
        this.initStats();
    }

    public void init(Entity entity, World world) {
    }

    private void initStats() {
        for (Stats stat : Stats.values()) {
            this.playerStats.put(stat, 0);
        }
    }

    public float getCurrentMagic() {
        if (this.mp > this.getMaxMagic()) {
            this.setCurrentMagic(this.getMaxMagic());
        }
        return this.mp;
    }

    public void restoreMagic(float amount) {
        this.setCurrentMagic(this.getCurrentMagic() + amount);
    }

    public void setCurrentMagic(float value) {
        this.mp = MathHelper.clamp_float((float)value, (float)0.0f, (float)this.getMaxMagic());
    }

    public void setInitialMagic(float value) {
        this.mp = Math.max(0.0f, value);
    }

    public float getMaxMagic() {
        return (float)this.player.getAttributeMap().getAttributeInstance(maxMagic).getAttributeValue();
    }

    public void setMaxMagic(float value) {
        value = MathHelper.clamp_float((float)value, (float)0.0f, (float)Config.getMaxMagicPoints());
        this.player.getAttributeMap().getAttributeInstance(maxMagic).setBaseValue((double)value);
        if (this.getCurrentMagic() > this.getMaxMagic()) {
            this.setCurrentMagic(this.getMaxMagic());
        }
    }

    public boolean consumeMagic(float amount) {
        return this.canUseMagic() ? this.useMagic(amount, true) : false;
    }

    public boolean useMagic(float amount) {
        return this.canUseMagic() ? this.useMagic(amount, false) : false;
    }

    private boolean useMagic(float amount, boolean consume) {
        boolean sufficient;
        if (this.player.capabilities.isCreativeMode || ZSSEntityInfo.get((EntityLivingBase)this.player).isBuffActive(Buff.UNLIMITED_MAGIC)) {
            return true;
        }
        boolean bl = sufficient = amount <= this.getCurrentMagic();
        if (sufficient || consume) {
            this.setCurrentMagic(this.getCurrentMagic() - amount);
        }
        return sufficient;
    }

    public boolean canUseMagic() {
        return this.player.capabilities.isCreativeMode || this.getMaxMagic() > 0.0f && !this.isNayruActive();
    }

    public int getStat(Stats stat) {
        return this.playerStats.get((Object)stat);
    }

    public void addStat(Stats stat, int value) {
        int i = this.playerStats.remove((Object)stat);
        switch (stat) {
            case STAT_BOSS_ROOMS: {
                this.playerStats.put(stat, i | value);
                break;
            }
            default: {
                this.playerStats.put(stat, i + value);
            }
        }
    }

    public ZSSPlayerSkills getPlayerSkills() {
        return this.playerSkills;
    }

    public ZSSPlayerSongs getPlayerSongs() {
        return this.playerSongs;
    }

    public boolean canBlock() {
        return this.blockTime == 0;
    }

    public void onAttackBlocked(ItemStack shield, float damage) {
        ZSSCombatEvents.setPlayerAttackTime(this.player);
        this.blockTime = shield.getItem() instanceof ItemZeldaShield ? ((ItemZeldaShield)shield.getItem()).getRecoveryTime() : 20;
        this.player.clearItemInUse();
        if (this.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new AttackBlockedPacket(shield), (EntityPlayerMP)this.player);
            this.player.addExhaustion(0.3f * damage);
        }
    }

    public void verifyStartingGear() {
        if ((this.receivedGear & 1) == 0 && ZSSItems.grantBonusGear(this.player)) {
            this.receivedGear = (byte)(this.receivedGear | 1);
        }
    }

    public void setFlag(byte flag, boolean value) {
        this.flags = value ? (byte)(this.flags | flag) : (byte)(this.flags & ~flag);
    }

    public boolean getFlag(byte flag) {
        return (this.flags & flag) == flag;
    }

    public void activateNayru() {
        if (Config.allowUnlimitedNayru() || !ZSSEntityInfo.get((EntityLivingBase)this.player).isBuffActive(Buff.UNLIMITED_MAGIC)) {
            this.setFlag((byte)4, true);
        }
    }

    public boolean isNayruActive() {
        return this.getFlag((byte)4);
    }

    public void setWearingBoots(ItemStack boots) {
        ItemStack helm;
        if (this.lastBootsWorn != null && this.lastBootsWorn.getItem() instanceof ItemArmorBoots) {
            ((ItemArmorBoots)this.lastBootsWorn.getItem()).removeModifiers(this.lastBootsWorn, this.player);
        }
        this.lastBootsWorn = boots;
        this.setFlag((byte)1, boots != null && boots.getItem() instanceof ItemArmorBoots);
        if (this.getFlag((byte)1)) {
            ((ItemArmorBoots)boots.getItem()).applyModifiers(boots, this.player);
        }
        if (this.getFlag((byte)2) && (helm = this.player.getCurrentArmor(3)) != null && helm.getItem() instanceof ItemMask) {
            ((ItemMask)helm.getItem()).applyModifiers(helm, this.player);
        }
    }

    public void setWearingHelm(ItemStack helm) {
        ItemStack boots;
        if (this.lastHelmWorn != null && this.lastHelmWorn.getItem() instanceof ItemMask) {
            ((ItemMask)this.lastHelmWorn.getItem()).removeModifiers(this.lastHelmWorn, this.player);
        }
        this.lastHelmWorn = helm;
        this.setFlag((byte)2, helm != null && helm.getItem() instanceof ItemMask);
        if (this.getFlag((byte)2)) {
            ((ItemMask)helm.getItem()).applyModifiers(helm, this.player);
        }
        if (this.getFlag((byte)1) && (boots = this.player.getCurrentArmor(0)) != null && boots.getItem() instanceof ItemArmorBoots) {
            ((ItemArmorBoots)boots.getItem()).applyModifiers(boots, this.player);
        }
    }

    @Deprecated
    public Item getBorrowedMask() {
        return this.borrowedMask;
    }

    @Deprecated
    public void setBorrowedMask(Item item) {
        this.borrowedMask = item;
    }

    @Deprecated
    public int getCurrentMaskStage() {
        return this.maskStage;
    }

    public boolean canIncrementSkulltulaTokens() {
        return this.skulltulaTokens < 100;
    }

    public int getSkulltulaTokens() {
        return this.skulltulaTokens;
    }

    public boolean incrementSkulltulaTokens() {
        if (this.canIncrementSkulltulaTokens() && PlayerUtils.consumeHeldItem(this.player, ZSSItems.skulltulaToken, 1)) {
            ++this.skulltulaTokens;
            return true;
        }
        return false;
    }

    public ItemStack getNockedArrow() {
        return this.arrowStack;
    }

    public void setNockedArrow(ItemStack stack) {
        this.arrowStack = stack;
        if (this.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SetNockedArrowPacket(stack), (EntityPlayerMP)this.player);
        }
    }

    public void onUpdate() {
        ItemStack helm;
        ItemStack boots;
        this.playerSkills.onUpdate();
        if (!this.player.worldObj.isRemote && this.lastMp != this.mp) {
            this.lastMp = this.mp;
            if (this.player instanceof EntityPlayerMP) {
                PacketDispatcher.sendTo(new SyncCurrentMagicPacket(this.player), (EntityPlayerMP)this.player);
            }
        }
        if (this.blockTime > 0) {
            --this.blockTime;
        }
        if (this.getFlag((byte)4)) {
            this.updateNayru();
        }
        if (this.getFlag((byte)1) && ((boots = this.player.getCurrentArmor(0)) == null || this.lastBootsWorn != null && boots.getItem() != this.lastBootsWorn.getItem())) {
            this.setWearingBoots(boots);
        }
        if (this.getFlag((byte)2) && ((helm = this.player.getCurrentArmor(3)) == null || this.lastHelmWorn != null && helm.getItem() != this.lastHelmWorn.getItem())) {
            this.setWearingHelm(helm);
        }
        if (this.getFlag((byte)8) && !this.player.onGround && Math.abs(this.player.motionY) > 0.05 && !this.player.capabilities.isFlying && this.player.worldObj.getTotalWorldTime() % 2L == 0L) {
            this.player.motionX *= 1.15;
            this.player.motionZ *= 1.15;
        }
        if (this.hasAutoBombArrow && (this.player.getHeldItem() == null || !(this.player.getHeldItem().getItem() instanceof ItemHeroBow))) {
            this.hasAutoBombArrow = false;
        }
        if (this.lastRidden == null && this.player.ridingEntity != null) {
            this.lastRidden = this.player.ridingEntity;
            if (this.lastRidden instanceof EntityHorse) {
                this.playerSongs.setHorseRidden((EntityHorse)this.lastRidden);
            }
        } else if (this.player.ridingEntity == null && this.lastRidden instanceof EntityHorse) {
            this.playerSongs.setHorseRidden((EntityHorse)this.lastRidden);
            this.lastRidden = null;
        }
    }

    private void updateNayru() {
        this.player.hurtResistantTime = this.player.maxHurtResistantTime;
        if (this.player.ticksExisted % 4 == 0) {
            if (!this.useMagic(0.5f, true)) {
                this.setFlag((byte)4, false);
            } else if (this.player instanceof EntityPlayerMP) {
                PacketDispatcher.sendToAllAround(new SpawnNayruParticlesPacket(this.player), (Entity)this.player, 64.0);
            }
        }
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new ZSSPlayerInfo(player));
        ZSSQuests.register(player);
    }

    public static final ZSSPlayerInfo get(EntityPlayer player) {
        return (ZSSPlayerInfo)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void onPlayerLoggedIn() {
        if (this.player instanceof EntityPlayerMP) {
            this.verifyStartingGear();
        }
    }

    public void onJoinWorld() {
        if (this.player instanceof EntityPlayerMP) {
            this.playerSkills.validateSkills();
            this.playerSkills.verifyMaxHealth();
            PacketDispatcher.sendTo(new SyncPlayerInfoPacket(this), (EntityPlayerMP)this.player);
            PacketDispatcher.sendTo(new SyncQuestsPacket(ZSSQuests.get(this.player)), (EntityPlayerMP)this.player);
        } else {
            PacketDispatcher.sendToServer(new RequestCurrentMagicPacket());
        }
    }

    public void copy(ZSSPlayerInfo info) {
        NBTTagCompound compound = new NBTTagCompound();
        info.saveNBTData(compound);
        this.loadNBTData(compound);
        ZSSQuests.get(this.player).copy(ZSSQuests.get(info.player));
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound tag;
        this.playerSkills.saveNBTData(compound);
        this.playerSongs.saveNBTData(compound);
        compound.setFloat("zssCurrentMagic", this.mp);
        compound.setIntArray("zssStats", ArrayUtils.toPrimitive((Integer[])this.playerStats.values().toArray(new Integer[this.playerStats.size()])));
        compound.setByte("ZSSGearReceived", this.receivedGear);
        if (this.lastBootsWorn != null) {
            tag = new NBTTagCompound();
            compound.setTag("lastBootsWorn", (NBTBase)this.lastBootsWorn.writeToNBT(tag));
        }
        if (this.lastHelmWorn != null) {
            tag = new NBTTagCompound();
            compound.setTag("lastHelmWorn", (NBTBase)this.lastHelmWorn.writeToNBT(tag));
        }
        compound.setInteger("slingshotMode", this.slingshotMode);
        compound.setInteger("skulltulaTokens", this.skulltulaTokens);
    }

    public void loadNBTData(NBTTagCompound compound) {
        int maskID;
        Item helm;
        Item boots;
        this.playerSkills.loadNBTData(compound);
        this.playerSongs.loadNBTData(compound);
        this.mp = compound.getFloat("zssCurrentMagic");
        int[] stats = compound.getIntArray("zssStats");
        for (int i = 0; i < stats.length; ++i) {
            this.playerStats.put(Stats.values()[i], stats[i]);
        }
        this.receivedGear = compound.getByte("ZSSGearReceived");
        if (compound.hasKey("lastBootsWorn", 10)) {
            this.lastBootsWorn = ItemStack.loadItemStackFromNBT((NBTTagCompound)compound.getCompoundTag("lastBootsWorn"));
        }
        if (compound.hasKey("lastHelmWorn", 10)) {
            this.lastHelmWorn = ItemStack.loadItemStackFromNBT((NBTTagCompound)compound.getCompoundTag("lastHelmWorn"));
        }
        if ((boots = Item.getItemById((int)compound.getInteger("lastBoots"))) != null) {
            this.lastBootsWorn = new ItemStack(boots);
        }
        if ((helm = Item.getItemById((int)compound.getInteger("lastHelm"))) != null) {
            this.lastHelmWorn = new ItemStack(helm);
        }
        this.borrowedMask = (maskID = compound.getInteger("borrowedMask")) > -1 ? Item.getItemById((int)maskID) : null;
        this.maskStage = compound.getInteger("maskStage");
        this.slingshotMode = compound.getInteger("slingshotMode");
        this.skulltulaTokens = compound.getInteger("skulltulaTokens");
    }

    public static enum Stats {
        STAT_SECRET_ROOMS,
        STAT_BOSS_ROOMS;

    }
}

