/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.player;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.SyncPlayerInfoPacket;
import zeldaswordskills.network.client.SyncSkillPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.ICombo;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TimedAddItem;
import zeldaswordskills.util.TimedChatDialogue;

public class ZSSPlayerSkills {
    private static final UUID hardcoreHeartUUID = UUID.fromString("83E54288-6BE2-4398-A880-957654F515AB");
    private static final AttributeModifier hardcoreHeartModifier = new AttributeModifier(hardcoreHeartUUID, "Hardcore Zelda Hearts", -14.0, 0).setSaved(true);
    private final EntityPlayer player;
    private final Map<Byte, SkillBase> skills;
    private final List<SkillActive> activeSkills = new LinkedList<SkillActive>();
    @SideOnly(value=Side.CLIENT)
    private SkillActive animatingSkill;
    private int crestsGiven = 0;

    public ZSSPlayerSkills(EntityPlayer player) {
        this.player = player;
        this.skills = new HashMap<Byte, SkillBase>(SkillBase.getNumSkills());
    }

    public static ZSSPlayerSkills get(EntityPlayer player) {
        return ZSSPlayerInfo.get(player).getPlayerSkills();
    }

    public boolean removeSkill(String name) {
        if ("all".equals(name)) {
            this.resetSkills();
            return true;
        }
        SkillBase dummy = null;
        for (SkillBase skill : this.skills.values()) {
            if (!skill.getUnlocalizedName().equals(name)) continue;
            dummy = skill;
            break;
        }
        if (dummy != null) {
            this.removeSkill(dummy);
            return true;
        }
        return false;
    }

    private void removeSkill(SkillBase skill) {
        SkillBase dummy = skill.newInstance();
        this.skills.put(dummy.getId(), dummy);
        this.validateSkills();
        this.skills.remove(dummy.getId());
        if (this.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SyncSkillPacket(dummy), (EntityPlayerMP)this.player);
        }
    }

    public void resetSkills() {
        for (SkillBase skill : SkillBase.getSkills()) {
            this.skills.put(skill.getId(), skill.newInstance());
        }
        this.validateSkills();
        this.skills.clear();
        this.crestsGiven = 0;
        if (this.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SyncPlayerInfoPacket(ZSSPlayerInfo.get(this.player)), (EntityPlayerMP)this.player);
        }
    }

    public final void validateSkills() {
        for (SkillBase skill : this.skills.values()) {
            skill.validateSkill(this.player);
        }
    }

    public void verifyMaxHealth() {
        IAttributeInstance attributeinstance = this.player.getEntityAttribute(SharedMonsterAttributes.maxHealth);
        if (attributeinstance.getModifier(hardcoreHeartUUID) != null) {
            attributeinstance.removeModifier(hardcoreHeartModifier);
        }
        if (Config.isHardcoreZeldaFan()) {
            attributeinstance.applyModifier(hardcoreHeartModifier);
        }
        if (this.player.getHealth() > this.player.getMaxHealth()) {
            this.player.setHealth(this.player.getMaxHealth());
        }
    }

    public boolean hasSkill(SkillBase skill) {
        return this.hasSkill(skill.getId());
    }

    private boolean hasSkill(byte id) {
        return this.getSkillLevel(id) > 0;
    }

    public byte getSkillLevel(SkillBase skill) {
        return this.getSkillLevel(skill.getId());
    }

    public byte getSkillLevel(byte id) {
        return this.skills.containsKey(id) ? this.skills.get(id).getLevel() : (byte)0;
    }

    public boolean isSkillActive(SkillBase skill) {
        SkillBase active = this.getPlayerSkill(skill);
        return active instanceof SkillActive && ((SkillActive)active).isActive();
    }

    @SideOnly(value=Side.CLIENT)
    public SkillActive getCurrentlyAnimatingSkill() {
        return this.animatingSkill;
    }

    @SideOnly(value=Side.CLIENT)
    public void setCurrentlyAnimatingSkill(SkillActive skill) {
        this.animatingSkill = skill == null || skill.hasAnimation() ? skill : this.animatingSkill;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canInteract() {
        if (this.animatingSkill != null && !this.animatingSkill.isActive() && !this.animatingSkill.isAnimating()) {
            this.animatingSkill = null;
        }
        return this.animatingSkill == null || !this.animatingSkill.isAnimating();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onKeyPressed(Minecraft mc, KeyBinding key) {
        for (SkillBase skill : this.skills.values()) {
            if (!(skill instanceof SkillActive) || !((SkillActive)skill).isKeyListener(mc, key) || !((SkillActive)skill).keyPressed(mc, key, this.player)) continue;
            return true;
        }
        return false;
    }

    public void onBeingAttacked(LivingAttackEvent event) {
        for (SkillActive skill : this.activeSkills) {
            if (!skill.isActive() || !skill.onBeingAttacked(this.player, event.source)) continue;
            event.setCanceled(true);
            return;
        }
    }

    public void onPostImpact(LivingHurtEvent event) {
        for (SkillActive skill : this.activeSkills) {
            if (!skill.isActive()) continue;
            event.ammount = skill.postImpact(this.player, event.entityLiving, event.ammount);
        }
        if (this.getComboSkill() != null) {
            this.getComboSkill().onHurtTarget(this.player, event);
        }
    }

    public SkillActive getActiveSkill(SkillBase skill) {
        SkillBase active = this.getPlayerSkill(skill.getId());
        return active instanceof SkillActive ? (SkillActive)active : null;
    }

    public SkillBase getPlayerSkill(SkillBase skill) {
        return this.getPlayerSkill(skill.getId());
    }

    public SkillBase getPlayerSkill(byte id) {
        return this.skills.containsKey(id) ? this.skills.get(id) : null;
    }

    public ICombo getComboSkill() {
        SkillBase skill = this.getPlayerSkill(SkillBase.swordBasic);
        if (skill != null && (((ICombo)((Object)skill)).getCombo() != null || ((SkillActive)skill).isActive())) {
            return (ICombo)((Object)skill);
        }
        return null;
    }

    public ILockOnTarget getTargetingSkill() {
        return (ILockOnTarget)((Object)this.getPlayerSkill(SkillBase.swordBasic));
    }

    public boolean grantSkill(SkillBase skill) {
        return this.grantSkill(skill.getId(), (byte)(this.getSkillLevel(skill) + 1));
    }

    public boolean grantSkill(byte id, byte targetLevel) {
        SkillBase skill;
        SkillBase skillBase = skill = this.skills.containsKey(id) ? this.skills.get(id) : SkillBase.getNewSkillInstance(id);
        if (skill.grantSkill(this.player, targetLevel)) {
            this.skills.put(id, skill);
            return true;
        }
        return false;
    }

    private void onSkillActivated(World world, SkillActive skill) {
        if (skill.isActive()) {
            this.activeSkills.add(skill);
            if (world.isRemote) {
                this.setCurrentlyAnimatingSkill(skill);
            }
        }
    }

    public boolean activateSkill(World world, SkillBase skill) {
        return this.activateSkill(world, skill.getId());
    }

    public boolean activateSkill(World world, byte id) {
        SkillBase skill = this.skills.get(id);
        if (skill instanceof SkillActive && ((SkillActive)skill).activate(world, this.player)) {
            this.onSkillActivated(world, (SkillActive)skill);
            return true;
        }
        return false;
    }

    public boolean triggerSkill(World world, SkillBase skill) {
        return this.triggerSkill(world, skill.getId());
    }

    public boolean triggerSkill(World world, byte id) {
        SkillBase skill = this.skills.get(id);
        if (skill instanceof SkillActive && ((SkillActive)skill).trigger(world, this.player, true)) {
            this.onSkillActivated(world, (SkillActive)skill);
            return true;
        }
        return false;
    }

    public boolean completedCrests() {
        return this.crestsGiven >= 100;
    }

    public void giveCrest() {
        if (this.getSkillLevel(SkillBase.spinAttack) < 1) {
            PlayerUtils.sendTranslatedChat(this.player, "chat.zss.npc.orca.unfit." + this.player.worldObj.rand.nextInt(4), new Object[0]);
        } else if (this.getSkillLevel(SkillBase.superSpinAttack) < Math.min(this.crestsGiven / 20, SkillBase.superSpinAttack.getMaxLevel())) {
            PlayerUtils.sendTranslatedChat(this.player, "chat.zss.npc.orca.unfit." + this.player.worldObj.rand.nextInt(4), new Object[0]);
        } else if (this.getSkillLevel(SkillBase.backSlice) < Math.min((this.crestsGiven + 10) / 20, SkillBase.backSlice.getMaxLevel())) {
            PlayerUtils.sendTranslatedChat(this.player, "chat.zss.npc.orca.unfit." + this.player.worldObj.rand.nextInt(4), new Object[0]);
        } else if (this.crestsGiven >= 100) {
            PlayerUtils.sendTranslatedChat(this.player, "chat.zss.npc.orca.master." + this.player.worldObj.rand.nextInt(4), new Object[0]);
        } else if (PlayerUtils.consumeInventoryItem(this.player, ZSSItems.treasure, ItemTreasure.Treasures.KNIGHTS_CREST.ordinal(), 1)) {
            ++this.crestsGiven;
            ArrayList<ChatComponentTranslation> chat = new ArrayList<ChatComponentTranslation>();
            chat.add(new ChatComponentTranslation("chat.zss.npc.orca.redeem." + this.player.worldObj.rand.nextInt(4), new Object[0]));
            if (this.crestsGiven == 1) {
                new TimedChatDialogue(this.player, new IChatComponent[]{new ChatComponentTranslation("chat.zss.npc.orca.begin.0", new Object[0]), new ChatComponentTranslation("chat.zss.npc.orca.begin.1", new Object[0]), new ChatComponentTranslation("chat.zss.npc.orca.begin.2", new Object[0])});
                this.player.triggerAchievement((StatBase)ZSSAchievements.orcaRequest);
                return;
            }
            if (this.crestsGiven > 19 && this.crestsGiven % 20 == 0) {
                boolean flag = true;
                if (this.crestsGiven == 100) {
                    this.player.triggerAchievement((StatBase)ZSSAchievements.orcaMaster);
                    chat.add(new ChatComponentTranslation("chat.zss.npc.orca.hurricane.final.0", new Object[0]));
                    chat.add(new ChatComponentTranslation("chat.zss.npc.orca.hurricane.final.1", new Object[0]));
                } else if (this.crestsGiven == 20) {
                    this.player.triggerAchievement((StatBase)ZSSAchievements.orcaSecondLesson);
                    chat.add(new ChatComponentTranslation("chat.zss.npc.orca.hurricane.first.0", new Object[0]));
                    chat.add(new ChatComponentTranslation("chat.zss.npc.orca.hurricane.first.1", new Object[0]));
                    chat.add(new ChatComponentTranslation("chat.zss.npc.orca.hurricane.first.2", new Object[0]));
                } else {
                    chat.add(new ChatComponentTranslation("chat.zss.npc.orca.hurricane.train", new Object[0]));
                    flag = false;
                }
                new TimedAddItem(this.player, new ItemStack(ZSSItems.skillOrb, 1, (int)SkillBase.superSpinAttack.getId()), flag ? 4000 : 3000, "zeldaswordskills:success");
            } else if (this.crestsGiven > 9 && this.crestsGiven % 10 == 0) {
                boolean flag = true;
                if (this.crestsGiven == 90) {
                    chat.add(new ChatComponentTranslation("chat.zss.npc.orca.backslice.final.0", new Object[0]));
                    chat.add(new ChatComponentTranslation("chat.zss.npc.orca.backslice.final.1", new Object[0]));
                } else if (this.crestsGiven == 10) {
                    this.player.triggerAchievement((StatBase)ZSSAchievements.orcaFirstLesson);
                    chat.add(new ChatComponentTranslation("chat.zss.npc.orca.backslice.first.0", new Object[0]));
                    chat.add(new ChatComponentTranslation("chat.zss.npc.orca.backslice.first.1", new Object[0]));
                    chat.add(new ChatComponentTranslation("chat.zss.npc.orca.backslice.first.2", new Object[0]));
                } else {
                    chat.add(new ChatComponentTranslation("chat.zss.npc.orca.backslice.train", new Object[0]));
                    flag = false;
                }
                new TimedAddItem(this.player, new ItemStack(ZSSItems.skillOrb, 1, (int)SkillBase.backSlice.getId()), flag ? 4000 : 3000, "zeldaswordskills:success");
            } else {
                chat.add(new ChatComponentTranslation("chat.zss.npc.orca.more." + this.player.worldObj.rand.nextInt(4), new Object[]{this.crestsGiven}));
            }
            new TimedChatDialogue(this.player, chat.toArray(new IChatComponent[chat.size()]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void syncClientSideSkill(byte id, NBTTagCompound compound) {
        if (SkillBase.doesSkillExist(id)) {
            SkillBase skill = SkillBase.getNewSkillInstance(id).loadFromNBT(compound);
            if (skill.getLevel() > 0) {
                this.skills.put(id, skill);
            } else {
                this.skills.remove(id);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onRenderTick(float partialRenderTick) {
        boolean flag = false;
        if (this.animatingSkill != null) {
            if (this.animatingSkill.isAnimating()) {
                flag = this.animatingSkill.onRenderTick(this.player, partialRenderTick);
            } else if (!this.animatingSkill.isActive()) {
                this.setCurrentlyAnimatingSkill(null);
            }
        }
        ILockOnTarget skill = this.getTargetingSkill();
        if (!flag && skill != null && skill.isLockedOn()) {
            ((SkillActive)((Object)skill)).onRenderTick(this.player, partialRenderTick);
        }
    }

    public void onUpdate() {
        for (SkillBase skill : this.skills.values()) {
            skill.onUpdate(this.player);
        }
        Iterator<SkillActive> iterator = this.activeSkills.iterator();
        while (iterator.hasNext()) {
            SkillBase skill;
            skill = iterator.next();
            if (((SkillActive)skill).isActive()) continue;
            iterator.remove();
        }
        if (this.player.worldObj.isRemote && ZSSKeyHandler.keys[6].getIsKeyPressed() && this.isSkillActive(SkillBase.swordBasic) && this.player.getHeldItem() != null) {
            Minecraft.getMinecraft().playerController.sendUseItem(this.player, this.player.worldObj, this.player.getHeldItem());
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagList taglist = new NBTTagList();
        for (SkillBase skill : this.skills.values()) {
            NBTTagCompound skillTag = new NBTTagCompound();
            skill.writeToNBT(skillTag);
            taglist.appendTag((NBTBase)skillTag);
        }
        compound.setTag("ZeldaSwordSkills", (NBTBase)taglist);
        compound.setInteger("crestsGiven", this.crestsGiven);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.skills.clear();
        NBTTagList taglist = compound.getTagList("ZeldaSwordSkills", 10);
        for (int i = 0; i < taglist.tagCount(); ++i) {
            NBTTagCompound skill = taglist.getCompoundTagAt(i);
            byte id = skill.getByte("id");
            this.skills.put(id, SkillBase.getSkill(id).loadFromNBT(skill));
        }
        this.crestsGiven = compound.getInteger("crestsGiven");
    }
}

