/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.player.quests;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IChatComponent;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.entity.player.quests.IQuest;
import zeldaswordskills.entity.player.quests.IQuestHandler;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.SyncQuestPacket;

public abstract class QuestBase
implements IQuest {
    public static final IQuestHandler DEFAULT_QUEST_HANDLER = new IQuestHandler(){

        @Override
        public void onQuestBegun(IQuest quest, EntityPlayer player) {
        }

        @Override
        public void onQuestChanged(IQuest quest, EntityPlayer player) {
        }

        @Override
        public void onQuestCompleted(IQuest quest, EntityPlayer player) {
        }
    };
    protected static final int FLAG_BEGIN = 64;
    protected static final int FLAG_COMPLETE = 128;
    protected static final Random rand = new Random();
    protected int flag;

    protected boolean isset(int flag) {
        return (this.flag & flag) == flag;
    }

    protected void set(int flag) {
        this.flag |= flag;
    }

    protected void unset(int flag) {
        this.flag &= ~flag;
    }

    @Override
    public boolean canBegin(EntityPlayer player) {
        return !this.isset(64);
    }

    @Override
    public boolean begin(EntityPlayer player, Object ... data) {
        if (this.canBegin(player) && this.onBegin(player, data)) {
            this.set(64);
            return true;
        }
        return false;
    }

    protected abstract boolean onBegin(EntityPlayer var1, Object ... var2);

    @Override
    public boolean hasBegun(EntityPlayer player) {
        return this.isset(64);
    }

    @Override
    public boolean canComplete(EntityPlayer player) {
        return !this.isComplete(player);
    }

    @Override
    public boolean complete(EntityPlayer player, Object ... data) {
        if (this.canComplete(player) && this.onComplete(player, data)) {
            this.set(128);
            return true;
        }
        return false;
    }

    protected abstract boolean onComplete(EntityPlayer var1, Object ... var2);

    @Override
    public boolean isComplete(EntityPlayer player) {
        return this.isset(128);
    }

    @Override
    public boolean requiresSync() {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.setInteger("questFlag", this.flag);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.flag = compound.getInteger("questFlag");
    }

    public static NBTTagCompound saveToNBT(IQuest quest) {
        NBTTagCompound compound = new NBTTagCompound();
        quest.writeToNBT(compound);
        compound.setString("QuestClass", quest.getClass().getName());
        return compound;
    }

    public static IQuest loadFromNBT(NBTTagCompound compound) {
        try {
            Class<?> clazz = Class.forName(compound.getString("QuestClass"));
            Object o = clazz.newInstance();
            if (o instanceof IQuest) {
                ((IQuest)o).readFromNBT(compound);
                return (IQuest)o;
            }
            ZSSMain.logger.warn("Failed to load quest from NBT: " + compound);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static IQuest getQuestInstance(Class<? extends IQuest> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean checkQuestProgress(EntityPlayer player, IQuest quest, IQuestHandler handler, Object ... data) {
        IChatComponent hint;
        boolean changed = false;
        if (!quest.isComplete(player)) {
            if (quest.canBegin(player)) {
                if (quest.begin(player, data)) {
                    handler.onQuestBegun(quest, player);
                    changed = true;
                }
            } else if (quest.canComplete(player)) {
                if (quest.complete(player, data)) {
                    handler.onQuestCompleted(quest, player);
                    changed = true;
                }
            } else if (quest.hasBegun(player) && quest.update(player, data)) {
                handler.onQuestChanged(quest, player);
                changed = true;
            }
        }
        if (!changed && (hint = quest.getHint(player, data)) != null) {
            if (!player.worldObj.isRemote && !hint.getUnformattedText().equals("")) {
                player.addChatMessage(hint);
            }
            return true;
        }
        if (changed && quest.requiresSync() && player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SyncQuestPacket(quest), (EntityPlayerMP)player);
        }
        return changed;
    }
}

