/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.player.quests;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.player.quests.QuestBase;
import zeldaswordskills.entity.player.quests.QuestMaskSales;
import zeldaswordskills.entity.player.quests.QuestZeldasLetter;
import zeldaswordskills.entity.player.quests.ZSSQuests;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TimedChatDialogue;

public class QuestMaskShop
extends QuestBase {
    public QuestMaskShop() {
        this.set(64);
    }

    @Override
    protected boolean onBegin(EntityPlayer player, Object ... data) {
        return false;
    }

    @Override
    public boolean canComplete(EntityPlayer player) {
        return this.isHoldingZeldasLetter(player);
    }

    private boolean isHoldingZeldasLetter(EntityPlayer player) {
        ItemStack stack = player.getHeldItem();
        return stack != null && stack.getItem() == ZSSItems.treasure && ItemTreasure.Treasures.byDamage(stack.getItemDamage()) == ItemTreasure.Treasures.ZELDAS_LETTER;
    }

    @Override
    protected boolean onComplete(EntityPlayer player, Object ... data) {
        if (PlayerUtils.consumeHeldItem(player, ZSSItems.treasure, ItemTreasure.Treasures.ZELDAS_LETTER.ordinal(), 1)) {
            PlayerUtils.playSound(player, "zeldaswordskills:success", 1.0f, 1.0f);
            player.triggerAchievement((StatBase)ZSSAchievements.maskTrader);
            if (this.isComplete(player)) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.mask_salesman.shop.open", new Object[0]);
            } else {
                IChatComponent[] chat = new IChatComponent[5];
                for (int i = 0; i < 5; ++i) {
                    chat[i] = new ChatComponentTranslation("chat.zss.npc.mask_salesman.shop.complete." + i, new Object[0]);
                }
                new TimedChatDialogue(player, chat);
                ZSSQuests.get(player).add(new QuestMaskSales());
            }
            return true;
        }
        return false;
    }

    @Override
    public void forceComplete(EntityPlayer player, Object ... data) {
        this.set(128);
        player.triggerAchievement((StatBase)ZSSAchievements.maskTrader);
        ZSSQuests.get(player).add(new QuestMaskSales(ZSSPlayerInfo.get(player).getCurrentMaskStage()));
    }

    @Override
    public boolean update(EntityPlayer player, Object ... data) {
        return false;
    }

    @Override
    public IChatComponent getHint(EntityPlayer player, Object ... data) {
        if (this.isComplete(player)) {
            if (ZSSQuests.get(player).hasCompleted(QuestMaskSales.class) || !this.isHoldingZeldasLetter(player)) {
                return null;
            }
            return new ChatComponentTranslation("chat.zss.npc.mask_salesman.shop.opening", new Object[0]);
        }
        if (this.canComplete(player)) {
            return new ChatComponentTranslation("chat.zss.npc.mask_salesman.shop.hint.letter", new Object[0]);
        }
        if (ZSSQuests.get(player).hasCompleted(QuestZeldasLetter.class)) {
            return new ChatComponentTranslation("chat.zss.npc.mask_salesman.shop.hint.zelda", new Object[0]);
        }
        return new ChatComponentTranslation("chat.zss.npc.mask_salesman.shop.hint." + rand.nextInt(4), new Object[0]);
    }

    @Override
    public boolean requiresSync() {
        return true;
    }
}

