/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.player.quests;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import zeldaswordskills.entity.player.quests.QuestBase;
import zeldaswordskills.entity.player.quests.QuestLightArrows;
import zeldaswordskills.entity.player.quests.QuestPendants;
import zeldaswordskills.entity.player.quests.ZSSQuests;
import zeldaswordskills.item.ItemInstrument;
import zeldaswordskills.item.ItemPendant;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TimedAddItem;
import zeldaswordskills.util.TimedChatDialogue;

public final class QuestMasterSword
extends QuestBase {
    @Override
    public boolean canBegin(EntityPlayer player) {
        return super.canBegin(player) && ZSSQuests.get(player).hasCompleted(QuestPendants.class);
    }

    @Override
    public boolean begin(EntityPlayer player, Object ... data) {
        if (!this.canBegin(player)) {
            return false;
        }
        for (ItemPendant.PendantType pendant : ItemPendant.PendantType.values()) {
            ItemStack stack = new ItemStack(ZSSItems.pendant, 1, pendant.ordinal());
            int delay = 3000 + pendant.ordinal() * 250;
            String sound = pendant == ItemPendant.PendantType.WISDOM ? "zeldaswordskills:success" : null;
            new TimedAddItem(player, stack, delay, sound);
        }
        new TimedChatDialogue(player, new IChatComponent[]{new ChatComponentTranslation("chat.zss.npc.zelda.master_sword.begin.0", new Object[0]), new ChatComponentTranslation("chat.zss.npc.zelda.master_sword.begin.1", new Object[0]), new ChatComponentTranslation("chat.zss.npc.zelda.master_sword.begin.2", new Object[0])});
        this.set(64);
        return true;
    }

    @Override
    protected boolean onBegin(EntityPlayer player, Object ... data) {
        return true;
    }

    @Override
    protected boolean onComplete(EntityPlayer player, Object ... data) {
        new TimedChatDialogue(player, new IChatComponent[]{new ChatComponentTranslation("chat.zss.npc.zelda.master_sword.complete.0", new Object[0]), new ChatComponentTranslation("chat.zss.npc.zelda.master_sword.complete.1", new Object[0]), new ChatComponentTranslation("chat.zss.npc.zelda.master_sword.complete.2", new Object[0]), new ChatComponentTranslation("chat.zss.npc.zelda.master_sword.complete.3", new Object[0])});
        ItemStack stack = new ItemStack(ZSSItems.instrument, 1, ItemInstrument.Instrument.OCARINA_TIME.ordinal());
        new TimedAddItem(player, stack, 3250, "zeldaswordskills:success");
        ZSSQuests.get(player).add(new QuestLightArrows());
        return true;
    }

    @Override
    public boolean canComplete(EntityPlayer player) {
        return super.canComplete(player) && PlayerUtils.isHoldingMasterSword((EntityLivingBase)player);
    }

    @Override
    public void forceComplete(EntityPlayer player, Object ... data) {
        this.set(128);
        ZSSQuests.get(player).add(new QuestLightArrows());
    }

    @Override
    public boolean update(EntityPlayer player, Object ... data) {
        return false;
    }

    @Override
    public IChatComponent getHint(EntityPlayer player, Object ... data) {
        if (this.hasBegun(player) && !this.isComplete(player) && rand.nextInt(8) < 3) {
            return new ChatComponentTranslation("chat.zss.npc.zelda.master_sword.hint." + rand.nextInt(3), new Object[0]);
        }
        return null;
    }

    @Override
    public boolean requiresSync() {
        return true;
    }
}

