/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.player.quests;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import zeldaswordskills.entity.player.quests.QuestBase;
import zeldaswordskills.entity.player.quests.QuestMaskShop;
import zeldaswordskills.entity.player.quests.QuestPendants;
import zeldaswordskills.entity.player.quests.ZSSQuests;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;

public final class QuestZeldasLetter
extends QuestBase {
    public QuestZeldasLetter() {
        this.set(64);
    }

    @Override
    protected boolean onBegin(EntityPlayer player, Object ... data) {
        return false;
    }

    @Override
    public boolean canComplete(EntityPlayer player) {
        return !this.isComplete(player) && ZSSQuests.get(player).hasBegun(QuestMaskShop.class);
    }

    @Override
    protected boolean onComplete(EntityPlayer player, Object ... data) {
        PlayerUtils.addItemToInventory(player, new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.ZELDAS_LETTER.ordinal()));
        PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.zelda.letter.give", new Object[0]);
        return true;
    }

    @Override
    public boolean isComplete(EntityPlayer player) {
        if (!this.isset(128) && ZSSQuests.get(player).hasCompleted(QuestMaskShop.class)) {
            this.forceComplete(player, new Object[0]);
        }
        return super.isComplete(player);
    }

    @Override
    public void forceComplete(EntityPlayer player, Object ... data) {
        this.set(128);
    }

    @Override
    public boolean update(EntityPlayer player, Object ... data) {
        return false;
    }

    @Override
    public IChatComponent getHint(EntityPlayer player, Object ... data) {
        ZSSQuests quests = ZSSQuests.get(player);
        if (!this.isComplete(player) && !quests.hasBegun(QuestMaskShop.class) && quests.hasCompleted(QuestPendants.class) && rand.nextInt(8) < 3) {
            return new ChatComponentTranslation("chat.zss.npc.zelda.letter.hint." + rand.nextInt(3), new Object[0]);
        }
        return null;
    }
}

