/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.damage.EnumDamageType;
import zeldaswordskills.api.entity.IEntityEvil;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.projectile.EntityArrowCustom;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.WorldUtils;

public class EntityArrowElemental
extends EntityArrowCustom {
    private static final String[] particles = new String[]{"flame", "magicCrit", "explode"};
    private static final int ARROWTYPE_DATAWATCHER_INDEX = 25;

    public EntityArrowElemental(World world) {
        super(world);
    }

    public EntityArrowElemental(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityArrowElemental(World world, EntityLivingBase shooter, float velocity) {
        super(world, shooter, velocity);
    }

    public EntityArrowElemental(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
    }

    @Override
    public void entityInit() {
        super.entityInit();
        this.setDamage(4.0);
        this.dataWatcher.addObject(25, (Object)ElementType.FIRE.ordinal());
    }

    public ElementType getType() {
        return ElementType.values()[this.dataWatcher.getWatchableObjectInt(25)];
    }

    public EntityArrowElemental setType(ElementType type) {
        this.dataWatcher.updateObject(25, (Object)type.ordinal());
        if (type == ElementType.FIRE) {
            this.setFire(100);
        }
        return this;
    }

    @Override
    protected float getVelocityFactor() {
        return 1.3f;
    }

    @Override
    protected DamageSource getDamageSource(Entity entity) {
        switch (this.getType()) {
            case FIRE: {
                return new DamageUtils.DamageSourceFireIndirect("arrow.fire", (Entity)this, this.shootingEntity).setProjectile().setMagicDamage();
            }
            case ICE: {
                return new DamageUtils.DamageSourceIceIndirect("arrow.ice", (Entity)this, this.shootingEntity, 50, 1).setProjectile().setMagicDamage();
            }
            case LIGHT: {
                return entity instanceof EntityEnderman ? new DamageUtils.DamageSourceBaseDirect("arrow.light", (Entity)(this.shootingEntity != null ? this.shootingEntity : this), EnumDamageType.HOLY).setProjectile().setMagicDamage().setDamageBypassesArmor() : new DamageUtils.DamageSourceBaseIndirect("arrow.light", (Entity)this, this.shootingEntity, EnumDamageType.HOLY).setProjectile().setMagicDamage().setDamageBypassesArmor();
            }
        }
        return super.getDamageSource(entity);
    }

    @Override
    protected boolean canTargetEntity(Entity entity) {
        return this.getType() == ElementType.LIGHT || super.canTargetEntity(entity);
    }

    @Override
    protected String getParticleName() {
        return particles[this.getType().ordinal()];
    }

    @Override
    protected boolean shouldSpawnParticles() {
        return true;
    }

    @Override
    protected void updateInAir() {
        boolean flag;
        super.updateInAir();
        boolean bl = flag = this.getType() == ElementType.FIRE && this.worldObj.handleMaterialAcceleration(this.boundingBox, Material.water, (Entity)this);
        if (!this.worldObj.isRemote && this.getType() == ElementType.ICE && (this.worldObj.handleMaterialAcceleration(this.boundingBox, Material.water, (Entity)this) || this.worldObj.handleMaterialAcceleration(this.boundingBox, Material.lava, (Entity)this))) {
            flag = this.affectBlocks();
        }
        if (flag) {
            if (this.getType() == ElementType.FIRE) {
                this.worldObj.playSoundEffect(this.posX, this.posY, this.posZ, "random.fizz", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
            }
            if (!this.worldObj.isRemote) {
                this.setDead();
            }
        }
    }

    @Override
    protected void onImpactBlock(MovingObjectPosition mop) {
        boolean flag;
        boolean bl = flag = this.getType() == ElementType.LIGHT && !Config.enableLightArrowNoClip();
        if (this.getType() != ElementType.LIGHT || flag) {
            super.onImpactBlock(mop);
            if (!this.worldObj.isRemote && this.affectBlocks()) {
                this.setDead();
            }
            if (flag) {
                this.extinguishLightArrow();
            }
        } else if (this.ticksExisted < 25) {
            Block block = this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ);
            if (block.getMaterial() != Material.air) {
                block.onEntityCollidedWithBlock(this.worldObj, mop.blockX, mop.blockY, mop.blockZ, (Entity)this);
            }
        } else {
            this.extinguishLightArrow();
        }
    }

    @Override
    protected void onImpactEntity(MovingObjectPosition mop) {
        if (this.getType() == ElementType.LIGHT && mop.entityHit instanceof EntityLivingBase && this.canOneHitKill(mop.entityHit)) {
            float velocity = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
            EntityLivingBase entity = (EntityLivingBase)mop.entityHit;
            entity.attackEntityFrom(this.getDamageSource((Entity)entity), entity.getMaxHealth() * 0.425f * velocity);
            this.playSound("random.bowhit", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
            if (!this.worldObj.isRemote) {
                this.setDead();
            }
        } else {
            super.onImpactEntity(mop);
        }
    }

    @Override
    protected float calculateDamage(Entity entityHit) {
        float dmg = super.calculateDamage(entityHit);
        if (this.getType() == ElementType.LIGHT && entityHit instanceof IEntityEvil) {
            dmg = ((IEntityEvil)entityHit).getLightArrowDamage(dmg);
        }
        return dmg;
    }

    @Override
    protected void handlePostDamageEffects(EntityLivingBase entity) {
        super.handlePostDamageEffects(entity);
        if (!entity.isDead && this.getType() == ElementType.ICE) {
            ZSSEntityInfo.get(entity).stun(MathHelper.ceiling_float_int((float)this.calculateDamage((Entity)entity)) * 10, true);
            int i = MathHelper.floor_double((double)entity.posX);
            int j = MathHelper.floor_double((double)entity.posY);
            int k = MathHelper.floor_double((double)entity.posZ);
            this.worldObj.setBlock(i, j, k, Blocks.ice);
            this.worldObj.setBlock(i, j + 1, k, Blocks.ice);
            this.worldObj.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "dig.glass", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
        }
    }

    private boolean canOneHitKill(Entity entity) {
        if (entity instanceof IEntityEvil) {
            return ((IEntityEvil)entity).isLightArrowFatal();
        }
        boolean flag = entity instanceof EntitySkeleton && ((EntitySkeleton)entity).getSkeletonType() == 1;
        return !(entity instanceof IBossDisplayData) && (flag || entity instanceof EntityEnderman);
    }

    protected boolean affectBlocks() {
        boolean flag = false;
        HashSet<ChunkPosition> affectedBlocks = new HashSet<ChunkPosition>(WorldUtils.getAffectedBlocksList(this.worldObj, this.rand, 1.5f, this.posX, this.posY, this.posZ, null));
        block4: for (ChunkPosition position : affectedBlocks) {
            int i = position.chunkPosX;
            int j = position.chunkPosY;
            int k = position.chunkPosZ;
            Block block = this.worldObj.getBlock(i, j, k);
            switch (this.getType()) {
                case FIRE: {
                    if (block.getMaterial() == Material.air && Config.enableFireArrowIgnite()) {
                        Block block2 = this.worldObj.getBlock(i, j - 1, k);
                        if (!block2.func_149730_j() || this.rand.nextInt(8) != 0) continue block4;
                        this.worldObj.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "fire.ignite", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
                        this.worldObj.setBlock(i, j, k, (Block)Blocks.fire);
                        flag = true;
                        break;
                    }
                    if (!WorldUtils.canMeltBlock(this.worldObj, block, i, j, k)) break;
                    this.worldObj.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.fizz", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
                    this.worldObj.setBlockToAir(i, j, k);
                    flag = true;
                    break;
                }
                case ICE: {
                    if (block.getMaterial() == Material.water) {
                        this.worldObj.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "dig.glass", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
                        this.worldObj.setBlock(i, j, k, Blocks.ice);
                        flag = true;
                        break;
                    }
                    if (block.getMaterial() == Material.lava) {
                        this.worldObj.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.fizz", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
                        this.worldObj.setBlock(i, j, k, block == Blocks.lava ? Blocks.obsidian : Blocks.cobblestone);
                        flag = true;
                        break;
                    }
                    if (block.getMaterial() != Material.fire) break;
                    this.worldObj.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.fizz", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
                    this.worldObj.setBlockToAir(i, j, k);
                    flag = true;
                    break;
                }
            }
        }
        return flag;
    }

    private void extinguishLightArrow() {
        for (int i = 0; i < 10; ++i) {
            double d0 = this.rand.nextGaussian() * 0.02;
            double d1 = this.rand.nextGaussian() * 0.02;
            double d2 = this.rand.nextGaussian() * 0.02;
            this.worldObj.spawnParticle("explode", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d0, d1, d2);
        }
        if (!this.worldObj.isRemote) {
            this.setDead();
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setInteger("arrowType", this.getType().ordinal());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.setType(ElementType.values()[compound.getInteger("arrowType") % ElementType.values().length]);
    }

    public static enum ElementType {
        FIRE,
        ICE,
        LIGHT;

    }
}

