/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockLever;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.block.IBoomerangBlock;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.entity.projectile.EntityMobThrowable;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class EntityBoomerang
extends EntityMobThrowable {
    private static final int ITEM_DATAWATCHER_INDEX = 22;
    private static final int TARGET_DATAWATCHER_INDEX = 23;
    private int distance = 12;
    private static final int LIFESPAN = 100;
    private int slot;
    private boolean captureAll = false;
    private List<ItemStack> capturedItems = new ArrayList<ItemStack>();
    private int xp = 0;

    public EntityBoomerang(World world) {
        super(world);
    }

    public EntityBoomerang(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntityBoomerang(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityBoomerang(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
        this.setTarget(target);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(23, (Object)-1);
        this.dataWatcher.addObjectByDataType(22, 5);
    }

    public EntityBoomerang setInvStack(ItemStack stack, int slot) {
        this.dataWatcher.updateObject(22, (Object)stack);
        this.slot = slot;
        return this;
    }

    public ItemStack getBoomerang() {
        return this.dataWatcher.getWatchableObjectItemStack(22);
    }

    public EntityBoomerang setRange(int range) {
        this.distance = range;
        return this;
    }

    public EntityBoomerang setCaptureAll(boolean captureAll) {
        this.captureAll = captureAll;
        return this;
    }

    protected EntityLivingBase getTarget() {
        int id = this.dataWatcher.getWatchableObjectInt(23);
        return id > 0 ? (EntityLivingBase)this.worldObj.getEntityByID(id) : null;
    }

    public void setTarget(EntityLivingBase target) {
        this.dataWatcher.updateObject(23, (Object)(target != null ? target.getEntityId() : -1));
    }

    protected DamageSource getDamageSource() {
        return new DamageUtils.DamageSourceBaseIndirect("boomerang", (Entity)this, (Entity)this.getThrower()).setStunDamage(200, 5, true).setProjectile();
    }

    @Override
    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected float getVelocity() {
        return this.func_70182_d();
    }

    protected float func_70182_d() {
        return 1.25f;
    }

    @Override
    public void onUpdate() {
        --this.distance;
        if (this.shouldDrop() && !this.worldObj.isRemote) {
            this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, this.getBoomerang()));
            this.dropXpOrbs();
            this.releaseDrops(null);
            this.setDead();
        } else {
            if (this.ticksExisted % 4 == 0) {
                WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
            }
            this.captureDrops();
            this.captureXpOrbs();
            this.destroyVines();
            this.updateMotion();
            super.onUpdate();
        }
    }

    private boolean shouldDrop() {
        return this.distance < -100 || this.getThrower() == null || !this.getThrower().isEntityAlive();
    }

    protected void updateMotion() {
        EntityLivingBase target;
        if (this.distance < 0 && this.getTarget() != this.getThrower()) {
            this.setTarget(this.getThrower());
        }
        if ((target = this.getTarget()) != null) {
            double d0 = target.posX - this.posX;
            double d1 = target.boundingBox.minY + (double)target.height - this.posY;
            double d2 = target.posZ - this.posZ;
            this.setThrowableHeading(d0, d1, d2, this.getVelocity(), 0.0f);
        }
    }

    public void onCollideWithPlayer(EntityPlayer player) {
        if (this.distance < 0 && !this.worldObj.isRemote) {
            if (player.inventory.getStackInSlot(this.slot) == null) {
                player.inventory.setInventorySlotContents(this.slot, this.getBoomerang());
            } else {
                int i = player.inventory.getFirstEmptyStack();
                if (i >= 0) {
                    player.inventory.setInventorySlotContents(i, player.inventory.getStackInSlot(this.slot));
                    player.inventory.setInventorySlotContents(this.slot, this.getBoomerang());
                } else {
                    PlayerUtils.addItemToInventory(player, this.getBoomerang());
                }
            }
            this.dropXpOrbs();
            this.releaseDrops(player);
            this.setDead();
        }
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
            if (mop.entityHit != this.getThrower() && mop.entityHit.attackEntityFrom(this.getDamageSource(), this.getDamage())) {
                this.playSound("game.neutral.hurt", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                if (mop.entityHit instanceof EntityLivingBase && this.getThrower() != null) {
                    EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)mop.entityHit), (Entity)this.getThrower());
                    EnchantmentHelper.func_151385_b((EntityLivingBase)this.getThrower(), (Entity)mop.entityHit);
                }
            }
        } else {
            Block block = this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ);
            boolean flag = block.getMaterial().blocksMovement();
            if (block instanceof IBoomerangBlock) {
                flag = ((IBoomerangBlock)block).onBoomerangCollided(this.worldObj, mop.blockX, mop.blockY, mop.blockZ, this);
            } else {
                block.onEntityCollidedWithBlock(this.worldObj, mop.blockX, mop.blockY, mop.blockZ, (Entity)this);
                float hardness = block.getBlockHardness(this.worldObj, mop.blockX, mop.blockY, mop.blockZ);
                if (block.getMaterial() != Material.air && hardness >= 0.0f && hardness < 0.1f && !this.worldObj.isRemote) {
                    this.worldObj.func_147480_a(mop.blockX, mop.blockY, mop.blockZ, true);
                } else if (block instanceof BlockButton || block instanceof BlockLever && this.getBoomerang() != null && this.getBoomerang().getItem() == ZSSItems.boomerangMagic) {
                    WorldUtils.activateButton(this.worldObj, block, mop.blockX, mop.blockY, mop.blockZ);
                    flag = true;
                }
            }
            if (flag && !this.noClip) {
                this.noClip = true;
                this.distance = Math.min(this.distance, 0);
                this.setThrowableHeading(-this.motionX, -this.motionY, -this.motionZ, this.getVelocity(), 1.0f);
            }
        }
    }

    public boolean captureItem(EntityItem item) {
        if (item.isEntityAlive()) {
            if (this.riddenByEntity == null) {
                item.mountEntity((Entity)this);
                return true;
            }
            if (this.captureAll && item != this.riddenByEntity) {
                this.capturedItems.add(item.getEntityItem());
                item.setDead();
                return true;
            }
        }
        return false;
    }

    private void captureDrops() {
        if (this.riddenByEntity == null || this.captureAll) {
            List items = this.worldObj.getEntitiesWithinAABB(EntityItem.class, this.boundingBox.expand(1.0, 1.0, 1.0));
            for (EntityItem item : items) {
                if (!this.captureItem(item) || this.captureAll) continue;
                return;
            }
        }
    }

    private void releaseDrops(EntityPlayer player) {
        for (ItemStack stack : this.capturedItems) {
            if (player != null) {
                PlayerUtils.addItemToInventory(player, stack);
                continue;
            }
            WorldUtils.spawnItemWithRandom(this.worldObj, stack, this.posX, this.posY, this.posZ);
        }
    }

    private void captureXpOrbs() {
        List orbs = this.worldObj.getEntitiesWithinAABB(EntityXPOrb.class, this.boundingBox.expand(1.0, 1.0, 1.0));
        for (EntityXPOrb orb : orbs) {
            this.xp += orb.getXpValue();
            this.worldObj.playSoundAtEntity((Entity)this, "random.orb", 0.1f, 0.5f * ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.8f));
            orb.setDead();
        }
    }

    private void dropXpOrbs() {
        int j;
        for (int i = this.xp; i > 0; i -= j) {
            j = EntityXPOrb.getXPSplit((int)i);
            this.worldObj.spawnEntityInWorld((Entity)new EntityXPOrb(this.worldObj, this.posX, this.posY, this.posZ, j));
            this.worldObj.playSoundAtEntity((Entity)this, "random.orb", 0.1f, 0.5f * ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.8f));
        }
    }

    private void destroyVines() {
        int k;
        int j;
        int i = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.getBlock(i, j = MathHelper.floor_double((double)this.posY), k = MathHelper.floor_double((double)this.posZ)).getMaterial() == Material.vine) {
            this.worldObj.func_147480_a(i, j, k, true);
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setInteger("distance", this.distance);
        NBTTagCompound item = new NBTTagCompound();
        this.getBoomerang().writeToNBT(item);
        compound.setTag("item", (NBTBase)item);
        compound.setInteger("invSlot", this.slot);
        compound.setInteger("target", this.getTarget() != null ? this.getTarget().getEntityId() : -1);
        compound.setBoolean("captureAll", this.captureAll);
        if (this.captureAll) {
            NBTTagList items = new NBTTagList();
            for (ItemStack stack : this.capturedItems) {
                NBTTagCompound dropNBT = new NBTTagCompound();
                stack.writeToNBT(dropNBT);
                items.appendTag((NBTBase)dropNBT);
            }
            compound.setTag("items", (NBTBase)items);
        }
        compound.setInteger("capturedXP", this.xp);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.distance = compound.getInteger("distance");
        this.dataWatcher.updateObject(22, (Object)ItemStack.loadItemStackFromNBT((NBTTagCompound)compound.getCompoundTag("item")));
        this.slot = compound.getInteger("invSlot");
        this.dataWatcher.updateObject(23, (Object)(compound.hasKey("target") ? compound.getInteger("target") : -1));
        this.captureAll = compound.getBoolean("captureAll");
        if (this.captureAll) {
            NBTTagList items = compound.getTagList("items", (int)compound.getId());
            for (int i = 0; i < items.tagCount(); ++i) {
                this.capturedItems.add(ItemStack.loadItemStackFromNBT((NBTTagCompound)items.getCompoundTagAt(i)));
            }
        }
        this.xp = compound.getInteger("capturedXP");
    }
}

