/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import zeldaswordskills.api.entity.MagicType;
import zeldaswordskills.client.particle.FXCycloneRing;
import zeldaswordskills.entity.projectile.EntityMobThrowable;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.WorldUtils;

public class EntityCyclone
extends EntityMobThrowable {
    private static float maxPitch = 0.4f;
    private float yaw = 0.0f;
    private float yawVelocity = 0.1f;
    private float pitch = 0.0f;
    private static float pitchVelocity = 0.0f;
    private static final int AREA_INDEX = 23;
    private List<Integer> affectedEntities = new ArrayList<Integer>();
    private List<ItemStack> capturedItems = new ArrayList<ItemStack>();
    private boolean canGrief = true;

    public EntityCyclone(World world) {
        super(world);
        this.setSize(1.0f, 2.0f);
    }

    public EntityCyclone(World world, EntityLivingBase entity) {
        super(world, entity);
        this.setSize(1.0f, 2.0f);
    }

    public EntityCyclone(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.setSize(1.0f, 2.0f);
    }

    public EntityCyclone(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
        this.setSize(1.0f, 2.0f);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(23, (Object)Float.valueOf(2.0f));
    }

    public float getArea() {
        return this.dataWatcher.getWatchableObjectFloat(23);
    }

    public EntityCyclone setArea(float radius) {
        this.dataWatcher.updateObject(23, (Object)Float.valueOf(radius));
        return this;
    }

    public EntityCyclone disableGriefing() {
        this.canGrief = false;
        return this;
    }

    protected DamageSource getDamageSource() {
        return new EntityDamageSourceIndirect("blast.wind", (Entity)this, (Entity)this.getThrower()).setProjectile().setMagicDamage();
    }

    public void applyEntityCollision(Entity entity) {
    }

    public boolean handleWaterMovement() {
        return false;
    }

    public boolean handleLavaMovement() {
        return false;
    }

    @Override
    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected float func_70182_d() {
        return 0.75f;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.motionY += 0.01;
        if (!this.worldObj.isRemote) {
            this.captureDrops();
            this.attackNearbyEntities();
            if (this.canGrief) {
                this.destroyLeaves();
            }
            if (this.ticksExisted > 40) {
                this.setDead();
                this.releaseDrops();
            } else if (this.ticksExisted % MagicType.WIND.getSoundFrequency() == MagicType.WIND.getSoundFrequency() - 1) {
                this.worldObj.playSoundAtEntity((Entity)this, MagicType.WIND.getMovingSound(), MagicType.WIND.getSoundPitch(this.rand), MagicType.WIND.getSoundVolume(this.rand));
            }
        } else {
            this.spawnParticleRing();
        }
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            Material m = this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ).getMaterial();
            if (m == Material.leaves) {
                if (!this.worldObj.isRemote && this.canGrief && Config.canDekuDenude()) {
                    this.worldObj.func_147480_a(mop.blockX, mop.blockY, mop.blockZ, true);
                }
            } else if (m.blocksMovement()) {
                if (mop.sideHit == 1) {
                    this.posY = mop.blockY + 1;
                    this.rotationPitch = 0.0f;
                    this.motionY = 0.0;
                } else {
                    this.setDead();
                    this.releaseDrops();
                }
            }
        } else if (mop.entityHit != null && (mop.entityHit != this.getThrower() || this.ticksExisted >= 5)) {
            if (this.getDamage() > 0.0f && !this.affectedEntities.contains(mop.entityHit.getEntityId())) {
                mop.entityHit.attackEntityFrom(this.getDamageSource(), this.getDamage());
                this.affectedEntities.add(mop.entityHit.getEntityId());
            }
            if (!(mop.entityHit instanceof EntityLivingBase) || (double)this.rand.nextFloat() > ((EntityLivingBase)mop.entityHit).getAttributeMap().getAttributeInstance(SharedMonsterAttributes.knockbackResistance).getAttributeValue()) {
                mop.entityHit.motionX = this.motionX * 1.8;
                mop.entityHit.motionY = this.motionY + 0.5;
                mop.entityHit.motionZ = this.motionZ * 1.8;
                mop.entityHit.rotationYaw += 30.0f * (float)this.ticksExisted;
                if (mop.entityHit instanceof EntityPlayerMP && !this.worldObj.isRemote) {
                    ((EntityPlayerMP)mop.entityHit).playerNetServerHandler.sendPacket((Packet)new S12PacketEntityVelocity(mop.entityHit));
                }
            }
        }
    }

    private void attackNearbyEntities() {
        if (this.getDamage() > 0.0f) {
            double d = Math.max(0.5, (double)this.getArea() - 1.0);
            List entities = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, this.boundingBox.expand(d, d, d));
            for (EntityLivingBase entity : entities) {
                if (this.affectedEntities.contains(entity.getEntityId()) || entity == this.getThrower() && this.ticksExisted < 8) continue;
                entity.attackEntityFrom(new EntityDamageSourceIndirect("tornado", (Entity)this, (Entity)this.getThrower()).setProjectile().setMagicDamage(), this.getDamage());
                this.affectedEntities.add(entity.getEntityId());
            }
        }
    }

    private void captureDrops() {
        if (!this.isDead) {
            double d = Math.max(0.5, (double)this.getArea() - 1.0);
            List items = this.worldObj.getEntitiesWithinAABB(EntityItem.class, this.boundingBox.expand(d, d, d));
            for (EntityItem item : items) {
                if (!item.isEntityAlive()) continue;
                this.capturedItems.add(item.getEntityItem());
                item.setDead();
            }
        }
    }

    private void releaseDrops() {
        for (ItemStack stack : this.capturedItems) {
            WorldUtils.spawnItemWithRandom(this.worldObj, stack, this.posX, this.posY, this.posZ);
        }
    }

    private void destroyLeaves() {
        HashSet<ChunkPosition> affectedBlockPositions = WorldUtils.getAffectedBlocksList(this.worldObj, this.rand, this.getArea(), this.posX, this.posY, this.posZ, null);
        for (ChunkPosition chunkposition : affectedBlockPositions) {
            int i = chunkposition.chunkPosX;
            int j = chunkposition.chunkPosY;
            int k = chunkposition.chunkPosZ;
            Material m = this.worldObj.getBlock(i, j, k).getMaterial();
            if ((m != Material.leaves || !Config.canDekuDenude()) && m != Material.plants && m != Material.vine && m != Material.web) continue;
            this.worldObj.func_147480_a(i, j, k, true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticleRing() {
        this.yaw += this.yawVelocity;
        if ((double)this.yaw > Math.PI * 2) {
            this.yaw = (float)((double)this.yaw - Math.PI * 2);
        }
        if (Math.random() < 0.1) {
            pitchVelocity = 0.2f;
        }
        this.pitch += pitchVelocity;
        if (this.pitch > maxPitch) {
            this.pitch = maxPitch;
        }
        pitchVelocity = pitchVelocity > 0.0f ? (pitchVelocity -= 0.05f) : 0.0f;
        this.pitch = this.pitch > 0.0f ? (this.pitch -= 0.07f) : 0.0f;
        EffectRenderer effectRenderer = Minecraft.getMinecraft().effectRenderer;
        FXCycloneRing ring = new FXCycloneRing(this.worldObj, this.posX, this.posY + 0.1, this.posZ, this.motionX, this.motionY, this.motionZ, this.yaw, this.pitch, 0.7f, effectRenderer);
        effectRenderer.addEffect((EntityFX)ring);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setFloat("areaOfEffect", this.getArea());
        compound.setIntArray("affectedEntities", ArrayUtils.toPrimitive((Integer[])this.affectedEntities.toArray(new Integer[this.affectedEntities.size()])));
        NBTTagList items = new NBTTagList();
        for (ItemStack stack : this.capturedItems) {
            NBTTagCompound dropNBT = new NBTTagCompound();
            stack.writeToNBT(dropNBT);
            items.appendTag((NBTBase)dropNBT);
        }
        compound.setTag("items", (NBTBase)items);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.setArea(compound.getFloat("areaOfEffect"));
        int[] entities = compound.getIntArray("affectedEntities");
        for (int i = 0; i < entities.length; ++i) {
            this.affectedEntities.add(entities[i]);
        }
        NBTTagList items = compound.getTagList("items", (int)compound.getId());
        for (int i = 0; i < items.tagCount(); ++i) {
            this.capturedItems.add(ItemStack.loadItemStackFromNBT((NBTTagCompound)items.getCompoundTagAt(i)));
        }
    }
}

