/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.block.IHookable;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.item.ItemHookShot;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.UnpressKeyPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.TargetUtils;

public class EntityHookShot
extends EntityThrowable {
    protected static final int THROWER_INDEX = 22;
    protected static final int TARGET_INDEX = 23;
    protected static final int SHOTTYPE_INDEX = 24;
    protected static final int IN_GROUND_INDEX = 25;
    public static final int HIT_POS_X = 26;
    public static final int HIT_POS_Y = 27;
    public static final int HIT_POS_Z = 28;
    protected boolean reachedHook = false;

    public EntityHookShot(World world) {
        super(world);
    }

    public EntityHookShot(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntityHookShot(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected void entityInit() {
        super.entityInit();
        this.setSize(0.25f, 0.25f);
        this.dataWatcher.addObject(22, (Object)"");
        this.dataWatcher.addObject(23, (Object)-1);
        this.dataWatcher.addObject(24, (Object)IHookable.HookshotType.WOOD_SHOT.ordinal());
        this.dataWatcher.addObject(25, (Object)0);
        this.dataWatcher.addObject(26, (Object)Float.valueOf(0.0f));
        this.dataWatcher.addObject(27, (Object)Float.valueOf(0.0f));
        this.dataWatcher.addObject(28, (Object)Float.valueOf(0.0f));
    }

    public IHookable.HookshotType getType() {
        return IHookable.HookshotType.values()[this.dataWatcher.getWatchableObjectInt(24) % IHookable.HookshotType.values().length];
    }

    public EntityHookShot setType(IHookable.HookshotType type) {
        this.dataWatcher.updateObject(24, (Object)type.ordinal());
        return this;
    }

    public int getMaxDistance() {
        return Config.getHookshotRange() * (this.getType().isExtended() ? 2 : 1);
    }

    public void setThrower(EntityPlayer player) {
        this.dataWatcher.updateObject(22, (Object)(player != null ? player.getCommandSenderName() : ""));
    }

    protected Entity getTarget() {
        int id = this.dataWatcher.getWatchableObjectInt(23);
        return id == -1 ? null : this.worldObj.getEntityByID(id);
    }

    protected void setTarget(Entity entity) {
        this.dataWatcher.updateObject(23, (Object)(entity != null ? entity.getEntityId() : -1));
    }

    public EntityLivingBase getThrower() {
        String name = this.dataWatcher.getWatchableObjectString(22);
        return name.equals("") ? null : this.worldObj.getPlayerEntityByName(name);
    }

    public boolean isInGround() {
        return (this.dataWatcher.getWatchableObjectByte(25) & 1) == 1;
    }

    protected void setInGround(boolean isInGround) {
        this.dataWatcher.updateObject(25, (Object)(isInGround ? (byte)1 : 0));
        this.inGround = isInGround;
    }

    protected DamageSource getDamageSource() {
        return new DamageUtils.DamageSourceBaseIndirect("hookshot", (Entity)this, (Entity)this.getThrower()).setStunDamage(50, 1, true).setProjectile();
    }

    protected boolean canGrabBlock(Block block, int x, int y, int z, int side) {
        Material material = block.getMaterial();
        Event.Result result = Event.Result.DEFAULT;
        if (block instanceof IHookable) {
            result = ((IHookable)block).canGrabBlock(this.getType(), this.worldObj, x, y, z, side);
            material = ((IHookable)block).getHookableMaterial(this.getType(), this.worldObj, x, y, z);
        } else if (Config.allowHookableOnly()) {
            return false;
        }
        switch (result) {
            case DEFAULT: {
                switch (this.getType()) {
                    case WOOD_SHOT: 
                    case WOOD_SHOT_EXT: {
                        return material == Material.wood;
                    }
                    case CLAW_SHOT: 
                    case CLAW_SHOT_EXT: {
                        return material == Material.rock || block instanceof BlockPane && material == Material.iron;
                    }
                    case MULTI_SHOT: 
                    case MULTI_SHOT_EXT: {
                        return material == Material.wood || material == Material.rock || material == Material.ground || material == Material.grass || material == Material.clay;
                    }
                }
            }
        }
        return result == Event.Result.ALLOW;
    }

    protected boolean canDestroyBlock(Block block, int x, int y, int z, int side) {
        Event.Result result = Event.Result.DEFAULT;
        if (block instanceof IHookable) {
            result = ((IHookable)block).canDestroyBlock(this.getType(), this.worldObj, x, y, z, side);
        } else if (Config.allowHookableOnly()) {
            return false;
        }
        switch (result) {
            case DEFAULT: {
                boolean isBreakable = block.getBlockHardness(this.worldObj, x, y, z) >= 0.0f;
                boolean canPlayerEdit = false;
                if (this.getThrower() instanceof EntityPlayer) {
                    canPlayerEdit = ((EntityPlayer)this.getThrower()).capabilities.allowEdit && Config.canHookshotBreakBlocks();
                }
                Material m = block.getMaterial();
                return isBreakable && canPlayerEdit && (m == Material.glass || m == Material.wood && this.getType().ordinal() / 2 == IHookable.HookshotType.CLAW_SHOT.ordinal() / 2);
            }
        }
        return result == Event.Result.ALLOW;
    }

    protected float func_70182_d() {
        return 1.25f;
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && this.getTarget() == null) {
            Block block = this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ);
            if (!block.getMaterial().blocksMovement()) {
                return;
            }
            if (block.getMaterial() != Material.air) {
                block.onEntityCollidedWithBlock(this.worldObj, mop.blockX, mop.blockY, mop.blockZ, (Entity)this);
            }
            if (!this.isInGround() && this.ticksExisted < this.getMaxDistance()) {
                this.motionZ = 0.0;
                this.motionY = 0.0;
                this.motionX = 0.0;
                if (this.canGrabBlock(block, mop.blockX, mop.blockY, mop.blockZ, mop.sideHit)) {
                    this.setInGround(true);
                    this.posX = (double)mop.blockX + 0.5;
                    this.posY = (double)mop.blockY + 0.5;
                    this.posZ = (double)mop.blockZ + 0.5;
                    switch (mop.sideHit) {
                        case 5: {
                            this.posX += 0.5;
                            break;
                        }
                        case 4: {
                            this.posX -= 0.515;
                            break;
                        }
                        case 3: {
                            this.posZ += 0.5;
                            break;
                        }
                        case 2: {
                            this.posZ -= 0.515;
                            break;
                        }
                        case 1: {
                            this.posY = (double)mop.blockY + 1.0;
                            break;
                        }
                        case 0: {
                            this.posY = mop.blockY;
                        }
                    }
                    this.dataWatcher.updateObject(26, (Object)Float.valueOf((float)this.posX));
                    this.dataWatcher.updateObject(27, (Object)Float.valueOf((float)this.posY));
                    this.dataWatcher.updateObject(28, (Object)Float.valueOf((float)this.posZ));
                } else if (!this.worldObj.isRemote) {
                    if (this.canDestroyBlock(block, mop.blockX, mop.blockY, mop.blockZ, mop.sideHit)) {
                        this.worldObj.func_147480_a(mop.blockX, mop.blockY, mop.blockZ, false);
                    }
                    this.setDead();
                }
            }
            if (!this.worldObj.isRemote) {
                this.worldObj.playSoundAtEntity((Entity)this, block.stepSound.getStepResourcePath(), 1.0f, 1.0f);
            } else {
                for (int i = 0; i < 10; ++i) {
                    this.worldObj.spawnParticle("blockcrack_" + Block.getIdFromBlock((Block)block) + "_" + this.worldObj.getBlockMetadata(mop.blockX, mop.blockY, mop.blockZ), this.posX, this.posY, this.posZ, this.rand.nextGaussian(), this.rand.nextGaussian(), this.rand.nextGaussian());
                }
            }
        } else if (mop.entityHit != null && this.getTarget() == null) {
            EntityPlayer player;
            mop.entityHit.attackEntityFrom(this.getDamageSource(), 1.0f);
            this.worldObj.playSoundAtEntity(mop.entityHit, "random.wood_click", 1.0f, 1.0f);
            EntityPlayer entityPlayer = player = this.getThrower() instanceof EntityPlayer ? (EntityPlayer)this.getThrower() : null;
            if (player != null && player.getCurrentArmor(0) != null && player.getCurrentArmor(0).getItem() == ZSSItems.bootsHeavy && player.isSneaking()) {
                this.setTarget(mop.entityHit);
                this.motionX = -this.motionX;
                this.motionY = -this.motionY;
                this.motionZ = -this.motionZ;
            } else {
                this.setDead();
            }
        }
    }

    public void onUpdate() {
        if (this.isInGround()) {
            super.onEntityUpdate();
        } else {
            super.onUpdate();
        }
        if (this.canUpdate()) {
            if (this.ticksExisted > this.getMaxDistance() && !this.isInGround() && this.getTarget() == null || this.ticksExisted > this.getMaxDistance() * 8) {
                if (this.worldObj.isRemote && this.getThrower() instanceof EntityPlayer && Config.enableHookshotSound) {
                    ((EntityPlayer)this.getThrower()).playSound("random.wood_click", 1.0f, 1.0f);
                }
                this.setDead();
            } else if (this.getTarget() != null) {
                this.pullTarget();
            } else {
                this.pullThrower();
            }
        } else {
            this.setDead();
        }
    }

    public void setDead() {
        super.setDead();
        if (this.getThrower() instanceof EntityPlayerMP && !this.worldObj.isRemote) {
            PacketDispatcher.sendTo(new UnpressKeyPacket(-99), (EntityPlayerMP)this.getThrower());
        }
    }

    protected boolean canUpdate() {
        EntityLivingBase thrower = this.getThrower();
        if (!this.isDead && thrower instanceof EntityPlayer && ((EntityPlayer)thrower).isUsingItem()) {
            ItemStack stack = thrower.getHeldItem();
            return stack.getItem() instanceof ItemHookShot && ((ItemHookShot)stack.getItem()).getType(stack.getItemDamage()) == this.getType();
        }
        return false;
    }

    protected void pullThrower() {
        EntityLivingBase thrower = this.getThrower();
        if (thrower != null && this.isInGround()) {
            thrower.fallDistance = 0.0f;
            double d = thrower.getDistanceSq((double)this.dataWatcher.getWatchableObjectFloat(26), (double)this.dataWatcher.getWatchableObjectFloat(27), (double)this.dataWatcher.getWatchableObjectFloat(28));
            if (!this.reachedHook) {
                boolean bl = this.reachedHook = d < 1.0;
            }
            if (this.reachedHook && thrower.isSneaking()) {
                thrower.motionZ = 0.0;
                thrower.motionX = 0.0;
                thrower.motionY = -0.15;
            } else if (this.reachedHook && d < 1.0) {
                thrower.motionZ = 0.0;
                thrower.motionY = 0.0;
                thrower.motionX = 0.0;
            } else {
                double dx = 0.15 * ((double)this.dataWatcher.getWatchableObjectFloat(26) - thrower.posX);
                double dy = 0.15 * ((double)(this.dataWatcher.getWatchableObjectFloat(27) + this.height / 3.0f) - thrower.posY + 0.05);
                double dz = 0.15 * ((double)this.dataWatcher.getWatchableObjectFloat(28) - thrower.posZ);
                TargetUtils.setEntityHeading((Entity)thrower, dx, dy, dz, 1.0f, 1.0f, true);
            }
        }
    }

    protected void pullTarget() {
        Entity target = this.getTarget();
        EntityLivingBase thrower = this.getThrower();
        if (target != null && thrower != null) {
            if (target instanceof EntityLivingBase) {
                ZSSEntityInfo.get((EntityLivingBase)target).removeBuff(Buff.STUN);
            }
            double d = target.getDistanceSq(thrower.posX, thrower.posY, thrower.posZ);
            if (!this.reachedHook) {
                boolean bl = this.reachedHook = d < 9.0;
            }
            if (this.reachedHook && d < 9.0) {
                target.motionZ = 0.0;
                target.motionY = 0.0;
                target.motionX = 0.0;
                this.motionZ = 0.0;
                this.motionY = 0.0;
                this.motionX = 0.0;
            } else {
                double dx = 0.15 * (thrower.posX - target.posX);
                double dy = 0.15 * (thrower.posY + (double)(this.height / 3.0f) - target.posY);
                double dz = 0.15 * (thrower.posZ - target.posZ);
                if (target instanceof EntityLivingBase) {
                    double resist = 1.0 - ((EntityLivingBase)target).getEntityAttribute(SharedMonsterAttributes.knockbackResistance).getAttributeValue();
                    dx *= resist;
                    dy *= resist;
                    dz *= resist;
                }
                TargetUtils.setEntityHeading(target, dx, dy, dz, 1.0f, 1.0f, true);
            }
        }
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setFloat("hitPosX", this.dataWatcher.getWatchableObjectFloat(26));
        compound.setFloat("hitPosY", this.dataWatcher.getWatchableObjectFloat(27));
        compound.setFloat("hitPosZ", this.dataWatcher.getWatchableObjectFloat(28));
        compound.setByte("customInGround", (byte)(this.isInGround() ? 1 : 0));
        compound.setByte("reachedHook", (byte)(this.reachedHook ? 1 : 0));
        compound.setByte("shotType", (byte)this.getType().ordinal());
        compound.setInteger("shotTarget", this.getTarget() != null ? this.getTarget().getEntityId() : -1);
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.dataWatcher.updateObject(26, (Object)Float.valueOf(compound.getFloat("hitPosX")));
        this.dataWatcher.updateObject(27, (Object)Float.valueOf(compound.getFloat("hitPosY")));
        this.dataWatcher.updateObject(28, (Object)Float.valueOf(compound.getFloat("hitPosZ")));
        this.dataWatcher.updateObject(25, (Object)compound.getByte("customInGround"));
        this.reachedHook = compound.getByte("reachedHook") == 1;
        this.dataWatcher.updateObject(22, (Object)compound.getString("ownerName"));
        this.dataWatcher.updateObject(24, (Object)IHookable.HookshotType.values()[compound.getByte("shotType") % IHookable.HookshotType.values().length]);
        this.dataWatcher.updateObject(23, (Object)compound.getInteger("shotTarget"));
    }
}

