/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.entity.IReflectable;
import zeldaswordskills.api.entity.MagicType;
import zeldaswordskills.entity.projectile.EntityMobThrowable;
import zeldaswordskills.item.ItemMagicRod;
import zeldaswordskills.util.WorldUtils;

public class EntityMagicSpell
extends EntityMobThrowable
implements IReflectable {
    private MagicType type = MagicType.FIRE;
    private boolean canGrief = true;
    private float radius = 2.0f;
    private boolean bypassesArmor;
    private float reflectChance = -1.0f;
    private boolean spawnParticles = true;

    public EntityMagicSpell(World world) {
        super(world);
        this.setGravityVelocity(0.02f);
    }

    public EntityMagicSpell(World world, EntityLivingBase entity) {
        super(world, entity);
        this.setGravityVelocity(0.02f);
        this.resetSize();
    }

    public EntityMagicSpell(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.setGravityVelocity(0.02f);
        this.resetSize();
    }

    public EntityMagicSpell(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
        this.setGravityVelocity(0.02f);
        this.resetSize();
    }

    private void resetSize() {
        float f = (float)((double)this.radius / 4.0);
        this.setSize(f, f);
    }

    public MagicType getType() {
        return this.type;
    }

    public EntityMagicSpell setType(MagicType type) {
        this.type = type;
        return this;
    }

    public EntityMagicSpell disableGriefing() {
        this.canGrief = false;
        return this;
    }

    public EntityMagicSpell setDamageBypassesArmor() {
        this.bypassesArmor = true;
        return this;
    }

    public float getArea() {
        return this.radius;
    }

    public EntityMagicSpell setArea(float radius) {
        this.radius = radius;
        this.resetSize();
        return this;
    }

    public EntityMagicSpell setReflectChance(float chance) {
        this.reflectChance = chance;
        return this;
    }

    public EntityMagicSpell disableTrailingParticles() {
        this.spawnParticles = false;
        return this;
    }

    protected DamageSource getDamageSource() {
        DamageSource source = new DamageUtils.DamageSourceFireIndirect("blast.fire", (Entity)this, (Entity)this.getThrower(), true).setProjectile().setMagicDamage();
        switch (this.getType()) {
            case ICE: {
                source = new DamageUtils.DamageSourceIceIndirect("blast.ice", (Entity)this, (Entity)this.getThrower(), 50, 1, true).setStunDamage(60, 10, true).setProjectile().setMagicDamage();
                break;
            }
            case LIGHTNING: {
                source = new DamageUtils.DamageSourceShockIndirect("blast.lightning", (Entity)this, (Entity)this.getThrower(), 50, 1.0f, true).setProjectile().setMagicDamage();
                break;
            }
            case WIND: {
                source = new DamageUtils.DamageSourceBaseIndirect("blast.wind", (Entity)this, (Entity)this.getThrower(), true).setProjectile().setMagicDamage();
                break;
            }
        }
        if (this.bypassesArmor) {
            source.setDamageBypassesArmor();
        }
        return source;
    }

    @Override
    public float getReflectChance(ItemStack mirrorShield, EntityPlayer player, Entity shooter) {
        return this.reflectChance < 0.0f ? 1.0f - this.getArea() / 4.0f : this.reflectChance;
    }

    @Override
    public void onReflected(ItemStack mirrorShield, EntityPlayer player, Entity shooter, Entity oldEntity) {
    }

    protected float func_70182_d() {
        return 1.0f;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        MagicType type = this.getType();
        if (this.worldObj.isRemote && this.spawnParticles) {
            String particle = type.getTrailingParticle();
            boolean flag = type != MagicType.FIRE;
            for (int i = 0; i < 4; ++i) {
                this.worldObj.spawnParticle(particle, this.posX + this.motionX * (double)i / 4.0, this.posY + this.motionY * (double)i / 4.0, this.posZ + this.motionZ * (double)i / 4.0, -this.motionX * 0.25, -this.motionY + (flag ? 0.1 : 0.0), -this.motionZ * 0.25);
            }
        } else if (this.ticksExisted % type.getSoundFrequency() == 0) {
            this.worldObj.playSoundAtEntity((Entity)this, type.getMovingSound(), type.getSoundVolume(this.rand), type.getSoundPitch(this.rand));
        }
    }

    protected void onImpact(MovingObjectPosition mop) {
        double x = mop.entityHit != null ? mop.entityHit.posX : (double)mop.blockX + 0.5;
        double y = mop.entityHit != null ? mop.entityHit.posY : (double)mop.blockY + 0.5;
        double z = mop.entityHit != null ? mop.entityHit.posZ : (double)mop.blockZ + 0.5;
        float r = this.getArea();
        List list = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, AxisAlignedBB.getBoundingBox((double)(x - (double)r), (double)(y - (double)r), (double)(z - (double)r), (double)(x + (double)r), (double)(y + (double)r), (double)(z + (double)r)));
        for (EntityLivingBase entity : list) {
            Block block;
            Vec3 vec31;
            Vec3 vec3 = Vec3.createVectorHelper((double)(this.posX - this.motionX), (double)(this.posY - this.motionY), (double)(this.posZ - this.motionZ));
            MovingObjectPosition mop1 = this.worldObj.rayTraceBlocks(vec3, vec31 = Vec3.createVectorHelper((double)entity.posX, (double)entity.posY, (double)entity.posZ));
            if (mop1 != null && mop1.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && (block = this.worldObj.getBlock(mop1.blockX, mop1.blockY, mop1.blockZ)).getMaterial().blocksMovement() || !entity.attackEntityFrom(this.getDamageSource(), this.getDamage()) || entity.isDead) continue;
            this.handlePostDamageEffects(entity);
        }
        if (this.worldObj.isRemote) {
            this.spawnImpactParticles("largeexplode", 4, -0.1f);
            this.spawnImpactParticles(this.getType().getTrailingParticle(), 16, this.getType() == MagicType.ICE ? 0.0f : -0.2f);
        } else {
            this.worldObj.playSoundAtEntity((Entity)this, "random.explode", 2.0f, (1.0f + (this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()) * 0.2f) * 0.7f);
            if (this.canGrief && this.getType().affectsBlocks(this.worldObj, this.getThrower())) {
                HashSet<ChunkPosition> affectedBlocks = new HashSet<ChunkPosition>(WorldUtils.getAffectedBlocksList(this.worldObj, this.rand, r, this.posX, this.posY, this.posZ, null));
                ItemMagicRod.affectAllBlocks(this.worldObj, affectedBlocks, this.getType());
            }
            this.setDead();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnImpactParticles(String particle, int n, float offsetY) {
        for (int i = 0; i < n; ++i) {
            double dx = this.posX - this.motionX * (double)i / 4.0;
            double dy = this.posY - this.motionY * (double)i / 4.0;
            double dz = this.posZ - this.motionX * (double)i / 4.0;
            this.worldObj.spawnParticle(particle, dx + (double)this.rand.nextFloat() - 0.5, dy + (double)this.rand.nextFloat() - 0.5, dz + (double)this.rand.nextFloat() - 0.5, (double)(0.25f * (this.rand.nextFloat() - 0.5f)), (double)(this.rand.nextFloat() * 0.25f + offsetY), (double)(0.25f * (this.rand.nextFloat() - 0.5f)));
        }
    }

    protected void handlePostDamageEffects(EntityLivingBase entity) {
        switch (this.getType()) {
            case ICE: {
                int i = MathHelper.floor_double((double)entity.posX);
                int j = MathHelper.floor_double((double)entity.posY);
                int k = MathHelper.floor_double((double)entity.posZ);
                if (this.getThrower() instanceof EntityPlayer) {
                    this.worldObj.setBlock(i, j, k, Blocks.ice);
                    this.worldObj.setBlock(i, j + 1, k, Blocks.ice);
                }
                this.worldObj.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "dig.glass", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
                break;
            }
            case FIRE: {
                if (entity.isImmuneToFire()) break;
                entity.setFire((int)Math.ceil(this.getDamage()));
                break;
            }
            case WIND: {
                float f3;
                double power = Math.min(3.0, (double)this.getDamage() / 6.0);
                if (!(power > 0.0) || !((f3 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ))) > 0.0f)) break;
                double knockback = power * (double)0.6f / (double)f3;
                entity.addVelocity(this.motionX * knockback, 0.1, this.motionZ * knockback);
                break;
            }
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setInteger("magicType", this.getType().ordinal());
        compound.setFloat("areaOfEffect", this.getArea());
        compound.setFloat("reflectChance", this.reflectChance);
        compound.setBoolean("bypassesArmor", this.bypassesArmor);
        compound.setBoolean("canGrief", this.canGrief);
        compound.setBoolean("spawnParticles", this.spawnParticles);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.setType(MagicType.values()[compound.getInteger("magicType") % MagicType.values().length]);
        this.setArea(compound.getFloat("areaOfEffect"));
        this.reflectChance = compound.getFloat("reflectChance");
        this.bypassesArmor = compound.getBoolean("bypassesArmor");
        this.canGrief = compound.getBoolean("canGrief");
        this.spawnParticles = compound.getBoolean("spawnParticles");
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(this.type.ordinal());
        buffer.writeFloat(this.radius);
        buffer.writeBoolean(this.spawnParticles);
    }

    @Override
    public void readSpawnData(ByteBuf buffer) {
        super.readSpawnData(buffer);
        this.type = MagicType.values()[buffer.readInt() % MagicType.values().length];
        this.radius = buffer.readFloat();
        this.spawnParticles = buffer.readBoolean();
    }
}

