/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.skills.sword.SwordBeam;
import zeldaswordskills.util.WorldUtils;

public class EntitySwordBeam
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    private float damage = 4.0f;
    private int level = 1;
    private int lifespan = 12;
    private boolean isMaster = false;

    public EntitySwordBeam(World world) {
        super(world);
    }

    public EntitySwordBeam(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntitySwordBeam(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public void entityInit() {
        this.setSize(0.5f, 0.5f);
    }

    public EntitySwordBeam setLevel(int level) {
        this.level = level;
        this.lifespan += level;
        return this;
    }

    public EntitySwordBeam setDamage(float amount) {
        this.damage = amount;
        return this;
    }

    public EntitySwordBeam setMasterSword(boolean isMaster) {
        this.isMaster = isMaster;
        return this;
    }

    protected float func_70182_d() {
        return 1.0f + (float)this.level * 0.15f;
    }

    public float getGravityVelocity() {
        return 0.0f;
    }

    public float getBrightness(float partialTick) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float partialTick) {
        return 0xF000F0;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.inGround || this.ticksExisted > this.lifespan) {
            this.setDead();
        }
        for (int i = 0; i < 2; ++i) {
            this.worldObj.spawnParticle(i % 2 == 1 ? "magicCrit" : "crit", this.posX, this.posY, this.posZ, this.motionX + this.rand.nextGaussian(), 0.01, this.motionZ + this.rand.nextGaussian());
            this.worldObj.spawnParticle(i % 2 == 1 ? "magicCrit" : "crit", this.posX, this.posY, this.posZ, -this.motionX + this.rand.nextGaussian(), 0.01, -this.motionZ + this.rand.nextGaussian());
        }
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (!this.worldObj.isRemote) {
            SwordBeam skill;
            EntityPlayer player = this.getThrower() instanceof EntityPlayer ? (EntityPlayer)this.getThrower() : null;
            SwordBeam swordBeam = skill = player != null ? (SwordBeam)ZSSPlayerSkills.get(player).getPlayerSkill(SkillBase.swordBeam) : null;
            if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
                Entity entity = mop.entityHit;
                if (player != null) {
                    if (skill != null) {
                        skill.onImpact(player, false);
                    }
                    if (entity.attackEntityFrom(DamageUtils.causeIndirectComboDamage((Entity)this, (Entity)player), this.damage)) {
                        WorldUtils.playSoundAtEntity(entity, "game.neutral.hurt", 0.4f, 0.5f);
                    }
                    this.damage *= 0.8f;
                }
                if (!this.isMaster) {
                    this.setDead();
                }
            } else {
                Block block = this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ);
                if (block.getMaterial() != Material.air) {
                    block.onEntityCollidedWithBlock(this.worldObj, mop.blockX, mop.blockY, mop.blockZ, (Entity)this);
                }
                if (block.getMaterial().blocksMovement()) {
                    if (player != null && skill != null) {
                        skill.onImpact(player, true);
                    }
                    this.setDead();
                }
            }
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        String throwerName = "";
        if (this.getThrower() != null) {
            throwerName = this.getThrower().getCommandSenderName();
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)throwerName);
    }

    public void readSpawnData(ByteBuf buffer) {
        String throwerName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        if (this.getThrower() == null && throwerName != null && throwerName.length() > 0) {
            ReflectionHelper.setPrivateValue(EntityThrowable.class, (Object)((Object)this), (Object)this.worldObj.getPlayerEntityByName(throwerName), (String[])new String[]{"field_70192_c", "thrower"});
        }
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setBoolean("isMaster", this.isMaster);
        compound.setFloat("damage", this.damage);
        compound.setInteger("level", this.level);
        compound.setInteger("lifespan", this.lifespan);
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.isMaster = compound.getBoolean("isMaster");
        this.damage = compound.getFloat("damage");
        this.level = compound.getInteger("level");
        this.lifespan = compound.getInteger("lifespan");
    }
}

