/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import zeldaswordskills.entity.projectile.EntityMobThrowable;

public class EntityThrowingRock
extends EntityMobThrowable {
    private static final int IGNORE_WATER = 22;

    public EntityThrowingRock(World world) {
        super(world);
    }

    public EntityThrowingRock(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntityThrowingRock(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityThrowingRock(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
    }

    public EntityThrowingRock setIgnoreWater() {
        this.dataWatcher.updateObject(22, (Object)1);
        return this;
    }

    public boolean getIgnoresWater() {
        return this.dataWatcher.getWatchableObjectByte(22) != 0;
    }

    public void entityInit() {
        this.dataWatcher.addObject(22, (Object)0);
        this.setDamage(2.0f);
    }

    public boolean handleWaterMovement() {
        return !this.getIgnoresWater();
    }

    protected void onImpact(MovingObjectPosition mop) {
        for (int l = 0; l < 4; ++l) {
            this.worldObj.spawnParticle("crit", this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0);
        }
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            Block block = this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ);
            if (block.getMaterial() != Material.air) {
                block.onEntityCollidedWithBlock(this.worldObj, mop.blockX, mop.blockY, mop.blockZ, (Entity)this);
            }
        } else if (mop.entityHit != null) {
            mop.entityHit.attackEntityFrom(DamageSource.causeThrownDamage((Entity)this, (Entity)this.getThrower()), this.getDamage());
        }
        if (!this.worldObj.isRemote) {
            this.setDead();
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setByte("ignoreWater", this.getIgnoresWater() ? (byte)1 : 0);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        if (compound.getByte("ignoreWater") != 0) {
            this.setIgnoreWater();
        }
    }
}

