/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.entity.IEntityLootable;
import zeldaswordskills.api.entity.LootableEntityRegistry;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.item.ItemWhip;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.UnpressKeyPacket;
import zeldaswordskills.network.server.FallDistancePacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.skills.sword.Parry;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class EntityWhip
extends EntityThrowable {
    protected static final int THROWER_INDEX = 22;
    protected static final int WHIP_TYPE_INDEX = 24;
    protected static final int IN_GROUND_INDEX = 25;
    public static final int HIT_POS_X = 26;
    public static final int HIT_POS_Y = 27;
    public static final int HIT_POS_Z = 28;
    private int hitX;
    private int hitY;
    private int hitZ;
    private int ticksInGround = 0;
    private int swingTicks = 0;
    private Vec3 swingVec = null;
    private double dy;

    public EntityWhip(World world) {
        super(world);
    }

    public EntityWhip(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntityWhip(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected void entityInit() {
        super.entityInit();
        this.setSize(0.25f, 0.25f);
        this.dataWatcher.addObject(22, (Object)"");
        this.dataWatcher.addObject(24, (Object)IWhipBlock.WhipType.WHIP_SHORT.ordinal());
        this.dataWatcher.addObject(25, (Object)0);
        this.dataWatcher.addObject(26, (Object)Float.valueOf(0.0f));
        this.dataWatcher.addObject(27, (Object)Float.valueOf(0.0f));
        this.dataWatcher.addObject(28, (Object)Float.valueOf(0.0f));
    }

    public IWhipBlock.WhipType getType() {
        return IWhipBlock.WhipType.values()[this.dataWatcher.getWatchableObjectInt(24) % IWhipBlock.WhipType.values().length];
    }

    public EntityWhip setType(IWhipBlock.WhipType type) {
        this.dataWatcher.updateObject(24, (Object)type.ordinal());
        return this;
    }

    public float getMaxDistance() {
        return (float)Config.getWhipRange() * (this.getType().isExtended() ? 1.5f : 1.0f);
    }

    public void setThrower(EntityPlayer player) {
        this.dataWatcher.updateObject(22, (Object)(player != null ? player.getCommandSenderName() : ""));
    }

    public EntityLivingBase getThrower() {
        String name = this.dataWatcher.getWatchableObjectString(22);
        return name.equals("") ? null : this.worldObj.getPlayerEntityByName(name);
    }

    public boolean isInGround() {
        return (this.dataWatcher.getWatchableObjectByte(25) & 1) == 1;
    }

    protected void setInGround(boolean isInGround) {
        this.dataWatcher.updateObject(25, (Object)(isInGround ? (byte)1 : 0));
        this.inGround = isInGround;
    }

    protected float getDamage() {
        switch (this.getType()) {
            case WHIP_SHORT: {
                return 1.0f;
            }
            case WHIP_LONG: {
                return 2.0f;
            }
            case WHIP_MAGIC: {
                return 4.0f;
            }
        }
        return 1.0f;
    }

    protected DamageSource getDamageSource() {
        return new DamageUtils.DamageSourceBaseIndirect("whip", (Entity)this, (Entity)this.getThrower()).setStunDamage(40, 10, true);
    }

    protected boolean canBreakBlock(Block block, Material m, int x, int y, int z, int side) {
        EntityLivingBase thrower = this.getThrower();
        if (block instanceof IWhipBlock) {
            return ((IWhipBlock)block).canBreakBlock(this.getType(), thrower, this.worldObj, x, y, z, side);
        }
        boolean isBreakable = block.getBlockHardness(this.worldObj, x, y, z) >= 0.0f;
        boolean canPlayerEdit = false;
        if (thrower instanceof EntityPlayer) {
            canPlayerEdit = ((EntityPlayer)thrower).capabilities.allowEdit && Config.canHookshotBreakBlocks();
        }
        return isBreakable && canPlayerEdit && (block instanceof BlockTorch || m == Material.leaves || m == Material.plants);
    }

    protected boolean canGrabBlock(Block block, int x, int y, int z, int side) {
        if (block instanceof IWhipBlock) {
            return ((IWhipBlock)block).canGrabBlock(this.getType(), this.getThrower(), this.worldObj, x, y, z, side);
        }
        switch (this.getType()) {
            case WHIP_MAGIC: {
                if (block instanceof BlockSandStone || block instanceof BlockHugeMushroom || block.getMaterial().blocksMovement() && block.getBlockHardness(this.worldObj, x, y, z) > 1.0f) {
                    return true;
                }
            }
            case WHIP_SHORT: 
            case WHIP_LONG: {
                int clear = 0;
                if (this.isSideClear(x + 1, y, z) && this.isSideClear(x - 1, y, z)) {
                    ++clear;
                }
                if (this.isSideClear(x, y + 1, z) && this.isSideClear(x, y - 1, z)) {
                    ++clear;
                }
                if (this.isSideClear(x, y, z + 1) && this.isSideClear(x, y, z - 1)) {
                    ++clear;
                }
                return clear > 1 && (block instanceof BlockFence || block instanceof BlockLog || block instanceof BlockLever || block instanceof BlockSign || block instanceof BlockLadder);
            }
        }
        return false;
    }

    protected boolean isSideClear(int x, int y, int z) {
        Material m = this.worldObj.getBlock(x, y, z).getMaterial();
        return !m.blocksMovement() || m == Material.leaves;
    }

    protected float func_70182_d() {
        return 1.25f;
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onImpact(MovingObjectPosition mop) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            Block block = this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ);
            if (this.isInGround()) return;
            if (!((float)this.ticksExisted < this.getMaxDistance())) return;
            WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:whip_crack", 1.0f, 0.2f);
            this.motionZ = 0.0;
            this.motionY = 0.0;
            this.motionX = 0.0;
            if (this.canGrabBlock(block, mop.blockX, mop.blockY, mop.blockZ, mop.sideHit)) {
                this.setInGround(true);
                AxisAlignedBB box = block.getCollisionBoundingBoxFromPool(this.worldObj, mop.blockX, mop.blockY, mop.blockZ);
                if (box != null) {
                    this.posX = box.minX + (box.maxX - box.minX) / 2.0;
                    this.posY = box.minY + (box.maxY - box.minY) / 2.0;
                    this.posZ = box.minZ + (box.maxZ - box.minZ) / 2.0;
                    switch (mop.sideHit) {
                        case 5: {
                            this.posX = box.maxX;
                            break;
                        }
                        case 4: {
                            this.posX = box.minX - 0.015;
                            break;
                        }
                        case 3: {
                            this.posZ = box.maxZ;
                            break;
                        }
                        case 2: {
                            this.posZ = box.minZ - 0.015;
                            break;
                        }
                        case 1: {
                            this.posY = box.maxY;
                            break;
                        }
                        case 0: {
                            this.posY = box.minY - 0.015;
                            break;
                        }
                    }
                } else {
                    this.posX = (double)mop.blockX + 0.5;
                    this.posY = (double)mop.blockY + 0.5;
                    this.posZ = (double)mop.blockZ + 0.5;
                    switch (mop.sideHit) {
                        case 1: {
                            this.posY = (double)mop.blockY + 1.0;
                            break;
                        }
                        case 0: {
                            this.posY = (double)mop.blockY - 0.015;
                            break;
                        }
                    }
                }
                this.dataWatcher.updateObject(26, (Object)Float.valueOf((float)this.posX));
                this.dataWatcher.updateObject(27, (Object)Float.valueOf((float)this.posY));
                this.dataWatcher.updateObject(28, (Object)Float.valueOf((float)this.posZ));
                this.hitX = mop.blockX;
                this.hitY = mop.blockY;
                this.hitZ = mop.blockZ;
                return;
            }
            if (this.canBreakBlock(block, block.getMaterial(), mop.blockX, mop.blockY, mop.blockZ, mop.sideHit)) {
                if (this.worldObj.isRemote) return;
                boolean drop = this.getThrower() instanceof EntityPlayer ? !((EntityPlayer)this.getThrower()).capabilities.isCreativeMode : true;
                this.worldObj.func_147480_a(mop.blockX, mop.blockY, mop.blockZ, drop);
                this.setDead();
                return;
            }
            if (block.getMaterial().blocksMovement()) {
                block.onEntityCollidedWithBlock(this.worldObj, mop.blockX, mop.blockY, mop.blockZ, (Entity)this);
                return;
            }
            block.onEntityCollidedWithBlock(this.worldObj, mop.blockX, mop.blockY, mop.blockZ, (Entity)this);
            return;
        }
        if (mop.entityHit == null) return;
        this.worldObj.playSoundAtEntity(mop.entityHit, "zeldaswordskills:whip_crack", 1.0f, 1.0f);
        boolean inflictDamage = true;
        if (mop.entityHit instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)mop.entityHit;
            if (this.getThrower() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)this.getThrower();
                if (this.lootTarget(player, target)) {
                    inflictDamage = target instanceof IEntityLootable ? ((IEntityLootable)target).isHurtOnTheft(player, this.getType()) : Config.getHurtOnSteal();
                } else if (target.getHeldItem() != null && ZSSPlayerSkills.get(player).hasSkill(SkillBase.parry)) {
                    float yaw;
                    float chance = Parry.getDisarmModifier((EntityLivingBase)player, target);
                    for (yaw = target.rotationYaw - player.rotationYaw; yaw >= 360.0f; yaw -= 360.0f) {
                    }
                    while (yaw < 0.0f) {
                        yaw += 360.0f;
                    }
                    yaw = Math.abs(Math.abs(yaw) - 180.0f);
                    float mod = 0.5f - 0.25f * (yaw / 45.0f);
                    chance = 0.05f + chance * mod;
                    if (this.worldObj.rand.nextFloat() < chance) {
                        WorldUtils.dropHeldItem(target);
                        inflictDamage = false;
                    }
                }
            }
            if (inflictDamage && target.getEquipmentInSlot(3) != null) {
                inflictDamage = false;
            }
        }
        if (inflictDamage) {
            mop.entityHit.attackEntityFrom(this.getDamageSource(), this.getDamage());
        }
        this.setDead();
    }

    private boolean lootTarget(EntityPlayer player, EntityLivingBase target) {
        if (target.getEntityData().getBoolean("LootableEntityFlag")) {
            return false;
        }
        IEntityLootable lootable = target instanceof IEntityLootable ? (IEntityLootable)target : null;
        float lootChance = lootable != null ? lootable.getLootableChance(player, this.getType()) : LootableEntityRegistry.getEntityLootChance(target.getClass());
        lootChance *= Config.getWhipLootMultiplier();
        boolean wasItemStolen = false;
        if (this.rand.nextFloat() < lootChance) {
            ItemStack loot;
            ItemStack itemStack = loot = lootable != null ? lootable.getEntityLoot(player, this.getType()) : LootableEntityRegistry.getEntityLoot(target.getClass());
            if (target instanceof EntitySpider && this.rand.nextInt(25) == 0) {
                loot = new ItemStack(ZSSItems.skulltulaToken);
            }
            if (loot != null) {
                EntityItem item = new EntityItem(this.worldObj, this.posX, this.posY + 1.0, this.posZ, loot);
                double dx = player.posX - this.posX;
                double dy = player.posY - this.posY;
                double dz = player.posZ - this.posZ;
                TargetUtils.setEntityHeading((Entity)item, dx, dy, dz, 1.0f, 1.0f, true);
                if (!this.worldObj.isRemote) {
                    this.worldObj.spawnEntityInWorld((Entity)item);
                }
                player.triggerAchievement((StatBase)ZSSAchievements.orcaThief);
                wasItemStolen = true;
            }
        }
        if ((lootable == null || lootable.onLootStolen(player, wasItemStolen)) && !this.worldObj.isRemote) {
            target.getEntityData().setBoolean("LootableEntityFlag", true);
        }
        return wasItemStolen;
    }

    public void onUpdate() {
        if (this.isInGround()) {
            this.lastTickPosX = this.posX;
            this.lastTickPosY = this.posY;
            this.lastTickPosZ = this.posZ;
            super.onEntityUpdate();
        } else {
            super.onUpdate();
        }
        if (this.canUpdate()) {
            if (this.isInGround() && this.ticksExisted < 6000) {
                ++this.ticksInGround;
                if (this.shouldSwing()) {
                    this.swingThrower();
                }
            } else if ((float)this.ticksExisted > this.getMaxDistance()) {
                WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:whip_crack", 0.5f, 0.2f);
                this.setDead();
            }
        } else {
            this.setDead();
        }
    }

    private boolean shouldSwing() {
        Block block = this.worldObj.getBlock(this.hitX, this.hitY, this.hitZ);
        if (block.getMaterial() == Material.air) {
            this.setDead();
            return false;
        }
        if (block instanceof IWhipBlock) {
            Event.Result result = ((IWhipBlock)block).shouldSwing(this, this.worldObj, this.hitX, this.hitY, this.hitZ, this.ticksInGround);
            switch (result) {
                case ALLOW: {
                    return true;
                }
                case DENY: {
                    return false;
                }
            }
        }
        if (this.isDead) {
            return false;
        }
        if (block instanceof BlockLever) {
            if (this.ticksInGround > 10 && !this.worldObj.isRemote) {
                WorldUtils.activateButton(this.worldObj, block, this.hitX, this.hitY, this.hitZ);
                this.setDead();
            }
            return false;
        }
        if (this.worldObj.isRemote && this.swingVec == null && this.getThrower() != null) {
            return this.getThrower().posY < (double)this.dataWatcher.getWatchableObjectFloat(27);
        }
        return true;
    }

    public void setDead() {
        super.setDead();
        if (this.getThrower() instanceof EntityPlayer && this.getThrower() instanceof EntityPlayerMP && !this.worldObj.isRemote) {
            PacketDispatcher.sendTo(new UnpressKeyPacket(-99), (EntityPlayerMP)this.getThrower());
        }
    }

    protected boolean canUpdate() {
        EntityLivingBase thrower = this.getThrower();
        if (!this.isDead && thrower instanceof EntityPlayer && ((EntityPlayer)thrower).isUsingItem()) {
            return thrower.getHeldItem() != null && thrower.getHeldItem().getItem() instanceof ItemWhip;
        }
        return false;
    }

    protected void swingThrower() {
        EntityLivingBase thrower = this.getThrower();
        if (thrower != null && !thrower.onGround && this.isInGround() && thrower.worldObj.isRemote) {
            float x = this.dataWatcher.getWatchableObjectFloat(26);
            float y = this.dataWatcher.getWatchableObjectFloat(27);
            float z = this.dataWatcher.getWatchableObjectFloat(28);
            if (this.swingTicks == 0 && this.swingVec == null && thrower.motionY < 0.0) {
                this.swingVec = Vec3.createVectorHelper((double)((double)x - thrower.posX), (double)((double)y - (thrower.posY + (double)thrower.getEyeHeight())), (double)((double)z - thrower.posZ)).normalize();
                this.dy = thrower.getDistance((double)x, (double)y, (double)z) / 7.0;
                double d = Math.min(thrower.getDistance((double)x, thrower.posY, (double)z), (double)this.getMaxDistance());
                this.swingTicks = MathHelper.floor_double((double)(((double)this.getMaxDistance() - d) / (double)this.getMaxDistance() * 8.0));
            }
            if (this.swingVec != null) {
                double sin = Math.sin(10.0 * (double)this.swingTicks * Math.PI / 180.0);
                double f = 0.8;
                thrower.motionX = sin * this.swingVec.xCoord * f;
                thrower.motionZ = sin * this.swingVec.zCoord * f;
                thrower.motionY = this.dy * -Math.sin(20.0 * (double)this.swingTicks * Math.PI / 180.0);
                MovingObjectPosition mop = TargetUtils.checkForImpact(this.worldObj, (Entity)thrower, (Entity)this, -(thrower.width / 4.0f), false);
                if (mop != null && mop.typeOfHit != MovingObjectPosition.MovingObjectType.MISS) {
                    thrower.motionX = -thrower.motionX * 0.15;
                    thrower.motionY = -thrower.motionY * 0.15;
                    thrower.motionZ = -thrower.motionZ * 0.15;
                    this.swingVec = null;
                }
                ++this.swingTicks;
                if (thrower.fallDistance > 0.0f && thrower.motionY < 0.0) {
                    PacketDispatcher.sendToServer(new FallDistancePacket((Entity)thrower, -0.467f));
                    thrower.fallDistance -= 0.467f;
                }
            } else if (this.swingTicks > 0) {
                if (thrower.getDistanceSq((double)x, thrower.posY, (double)z) > 1.0) {
                    double dx = (double)x - thrower.posX;
                    double dz = (double)z - thrower.posZ;
                    thrower.motionX = 0.15 * dx;
                    thrower.motionZ = 0.15 * dz;
                }
                if (thrower.posY < (double)y - (double)this.getMaxDistance() / 2.0) {
                    thrower.motionY = 0.0;
                }
                ++this.swingTicks;
                PacketDispatcher.sendToServer(new FallDistancePacket((Entity)thrower, 0.0f));
                thrower.fallDistance = 0.0f;
            }
        }
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setFloat("hitPosX", this.dataWatcher.getWatchableObjectFloat(26));
        compound.setFloat("hitPosY", this.dataWatcher.getWatchableObjectFloat(27));
        compound.setFloat("hitPosZ", this.dataWatcher.getWatchableObjectFloat(28));
        compound.setInteger("hitX", this.hitX);
        compound.setInteger("hitY", this.hitY);
        compound.setInteger("hitZ", this.hitZ);
        compound.setByte("customInGround", (byte)(this.isInGround() ? 1 : 0));
        compound.setInteger("whipType", this.getType().ordinal());
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.dataWatcher.updateObject(26, (Object)Float.valueOf(compound.getFloat("hitPosX")));
        this.dataWatcher.updateObject(27, (Object)Float.valueOf(compound.getFloat("hitPosY")));
        this.dataWatcher.updateObject(28, (Object)Float.valueOf(compound.getFloat("hitPosZ")));
        this.hitX = compound.getInteger("hitX");
        this.hitY = compound.getInteger("hitY");
        this.hitZ = compound.getInteger("hitZ");
        this.dataWatcher.updateObject(22, (Object)compound.getString("ownerName"));
        this.dataWatcher.updateObject(24, (Object)IWhipBlock.WhipType.values()[compound.getInteger("whipType") % IWhipBlock.WhipType.values().length]);
        this.dataWatcher.updateObject(25, (Object)compound.getByte("customInGround"));
    }
}

